<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 */

/**
 * Settings metadata file
 */
return [
  'contact_view_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_view_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'optionGroupName' => 'contact_view_options',
    ],
    'default' => '1234567891013',
    'add' => '4.1',
    'title' => ts('Viewing Contacts'),
    'is_domain' => '1',
    'is_contact' => 0,
    'help_text' => ts("Select the tabs that should be displayed when viewing a contact record. EXAMPLE: If your organization does not keep track of 'Relationships', then un-check this option to simplify the screen display. Tabs for Contributions, Pledges, Memberships, Events, Grants and Cases are also hidden if the corresponding component is not enabled. Go to Administer > System Settings > Enable Components to modify the components which are available for your site."),
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 10]],
  ],
  'contact_edit_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_edit_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'optionGroupName' => 'contact_edit_options',
    ],
    'default' => '123456789111214151617',
    'add' => '4.1',
    'title' => ts('Editing Contacts'),
    'is_domain' => 1,
    'is_contact' => 0,
    'template' => 'CRM/Admin/Form/Preferences/DisplayContactEditOptions.tpl',
    'help_text' => ts('Select the sections that should be included when adding or editing a contact record. EXAMPLE: If your organization does not record Gender and Birth Date for individuals, then simplify the form by un-checking this option. Drag interface allows you to change the order of the panes displayed on contact add/edit screen.'),
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 20]],
  ],
  'advanced_search_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'advanced_search_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'optionGroupName' => 'advanced_search_options',
    ],
    'default' => '123456789101112131516171819',
    'add' => '4.1',
    'title' => ts('Advanced Search'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Select the sections that should be included in the Basic and Advanced Search forms. EXAMPLE: If you don\'t track Relationships - then you do not need this section included in the advanced search form. Simplify the form by un-checking this option.'),
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'settings_pages' => ['search' => ['section' => 'legacy', 'weight' => 70]],
  ],
  'user_dashboard_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'user_dashboard_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'optionGroupName' => 'user_dashboard_options',
    ],
    'default' => '1234578',
    'add' => '4.1',
    'title' => ts('Contact Dashboard'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('Select the sections that should be included in the Contact Dashboard. EXAMPLE: If you don\'t want constituents to view their own contribution history, un-check that option.'),
      ts('In order to enable logged in users to download invoices and credit notes from the dashboard, please first enable CiviCRM invoicing functionality.'),
    ],
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 50]],
  ],
  'address_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'address_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'optionGroupName' => 'address_options',
    ],
    'default' => '1234568910',
    'add' => '4.1',
    'title' => ts('Address Fields'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Select the fields to be included when editing a contact or event address.'),
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'settings_pages' => ['address' => ['section' => 'edit', 'weight' => 10]],
  ],
  'address_format' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'address_format',
    'type' => 'String',
    'html_type' => 'textarea',
    'default' => "{contact.address_name}\n{contact.street_address}\n{contact.supplemental_address_1}\n{contact.supplemental_address_2}\n{contact.supplemental_address_3}\n{contact.city}{, }{contact.state_province}{ }{contact.postal_code}\n{contact.country}",
    'add' => '4.1',
    'title' => ts('Address Display Format'),
    'is_domain' => 1,
    'is_contact' => 0,
    'template' => 'CRM/Admin/Form/Preferences/AddressFormat.tpl',
    'settings_pages' => ['address' => ['section' => 'display', 'weight' => 10]],
  ],
  'mailing_format' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'mailing_format',
    'type' => 'String',
    'html_type' => 'textarea',
    'default' => "{contact.addressee}\n{contact.street_address}\n{contact.supplemental_address_1}\n{contact.supplemental_address_2}\n{contact.supplemental_address_3}\n{contact.city}{, }{contact.state_province}{ }{contact.postal_code}\n{contact.country}",
    'add' => '4.1',
    'title' => ts('Mailing Label Format'),
    'is_domain' => 1,
    'is_contact' => 0,
    'template' => 'CRM/Admin/Form/Preferences/AddressMailingFormat.tpl',
    'settings_pages' => ['address' => ['section' => 'labels', 'weight' => 10]],
  ],
  'display_name_format' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'display_name_format',
    'type' => 'String',
    'html_type' => 'textarea',
    'default' => '{contact.prefix_id:label}{ }{contact.first_name}{ }{contact.last_name}{ }{contact.suffix_id:label}',
    'add' => '4.1',
    'title' => ts('Individual Display Name Format'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Display name format for individual contact display names.'),
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 70]],
  ],
  'sort_name_format' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'sort_name_format',
    'type' => 'String',
    'html_type' => 'textarea',
    'default' => '{contact.last_name}{, }{contact.first_name}{ }{contact.suffix_id:label}',
    'add' => '4.1',
    'title' => ts('Individual Sort Name Format'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Sort name format for individual contact display names.'),
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 80]],
  ],
  'remote_profile_submissions' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'remote_profile_submissions',
    'type' => 'Boolean',
    'default' => FALSE,
    'html_type' => 'toggle',
    'add' => '4.7',
    'title' => ts('Accept profile submissions from external sites'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If enabled, CiviCRM will permit submissions from external sites to profiles. This is disabled by default to limit abuse.'),
    'settings_pages' => ['misc' => ['weight' => 200, 'section' => 'security']],
  ],
  'allow_alert_autodismissal' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'allow_alert_autodismissal',
    'type' => 'Boolean',
    'default' => TRUE,
    'html_type' => 'toggle',
    'add' => '4.7',
    'title' => ts('Allow alerts to auto-dismiss?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If disabled, CiviCRM will not automatically dismiss any alerts after 10 seconds.'),
    'settings_pages' => ['display' => ['weight' => 610]],
  ],
  'editor_id' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'editor_id',
    'type' => 'String',
    'html_type' => 'select',
    'default' => 'CKEditor',
    'add' => '4.1',
    'title' => ts('Wysiwyg Editor'),
    'pseudoconstant' => [
      'optionGroupName' => 'wysiwyg_editor',
      'keyColumn' => 'name',
    ],
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('A "WYSIWYG" (What You See Is What You Get) is a rich-text editor, like a mini word-processor, for editing HTML content in CiviCRM.'),
    'help_doc_url' => [
      'url' => 'https://civicrm.org/extensions?search=wysiwyg',
      'text' => ts('Additional WYSIWYG editors are available to download'),
    ],
    'settings_pages' => ['display' => ['weight' => 500]],
  ],
  'contact_ajax_check_similar' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_ajax_check_similar',
    'type' => 'String',
    'html_type' => 'radio',
    'default' => '1',
    'add' => '4.1',
    'title' => ts('Check for Similar Contacts'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('When enabled, checks for possible matches on the "New Contact" form using the Supervised matching rule specified in your system.'),
    ],
    'options' => ['1' => ts('While Typing'), '0' => ts('When Saving'), '2' => ts('Never')],
    'settings_pages' => ['display' => ['section' => 'contact', 'weight' => 30]],
  ],
  'ajaxPopupsEnabled' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'ajaxPopupsEnabled',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.5',
    'title' => ts('Enable Popup Forms'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If you disable this option, the CiviCRM interface will be limited to traditional browsing. Opening a form will refresh the page rather than opening a popup dialog.'),
    'settings_pages' => ['display' => ['weight' => 600]],
  ],
  'enableBackgroundQueue' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'enableBackgroundQueue',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'add' => '5.51',
    'title' => ts('Background Queues'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If enabled, some operations will be transferred to background workers. This requires configuring a background service.'),
    'settings_pages' => ['misc' => ['weight' => 30, 'section' => 'performance']],
  ],
  'defaultExternUrl' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'defaultExternUrl',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'default' => 'router',
    'add' => '5.27',
    'title' => ts('Extern URL Style'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('CiviCRM generates callback URLs for external services.'),
      ts('This setting provides transitional support. It should be set to "Prefer normal router." If your deployment requires "Prefer standalone script", then please ensure that the issue is tracked in lab.civicrm.org.'),
    ],
    'options' => [
      'standalone' => ts('Prefer standalone scripts'),
      'router' => ts('Prefer normal router'),
    ],
    'settings_pages' => ['url' => ['section' => 'advanced', 'weight' => 70]],
  ],
  'activity_assignee_notification' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'activity_assignee_notification',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => '1',
    'add' => '4.1',
    'title' => ts('Notify Activity Assignees'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('When enabled, contacts who are assigned activities will automatically receive an email notification with a copy of the activity.'),
    'settings_pages' => ['display' => ['section' => 'activity', 'weight' => 0]],
  ],
  'activity_assignee_notification_ics' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'activity_assignee_notification_ics',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => '0',
    'add' => '4.3',
    'title' => ts('Include ICal Invite to Activity Assignees'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('When enabled, activity assignee notification emails will also include an ical meeting invite.'),
    'settings_pages' => ['display' => ['section' => 'activity', 'weight' => 20]],
  ],
  'contact_autocomplete_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_autocomplete_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Search::getContactAutocompleteOptions',
    ],
    'default' => '12',
    'add' => '4.1',
    'title' => ts('Quicksearch results'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts("Fields to display in the menubar contact quick search. Contact Name is always included."),
      ts('A few legacy form fields also use this setting, but most autocompletes are configurable with Search Kit.'),
    ],
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'validate_callback' => 'CRM_Admin_Form_Setting_Search::enableOptionOne',
    'settings_pages' => ['search' => ['section' => 'autocomplete', 'weight' => 50]],
  ],
  'contact_reference_options' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_reference_options',
    'type' => 'String',
    'html_type' => 'checkboxes',
    'pseudoconstant' => [
      'callback' => 'CRM_Admin_Form_Setting_Search::getContactReferenceOptions',
    ],
    'default' => '12',
    'add' => '4.1',
    'title' => ts('Contact Reference Options'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts("Selected fields will be displayed in autocomplete dropdown search results for 'Contact Reference' custom fields. Contact Name is always included. NOTE: You must assign 'access contact reference fields' permission to the anonymous role if you want to use custom contact reference fields in profiles on public pages. For most situations, you should use the 'Limit List to Group' setting when configuring a contact reference field which will be used in public forms to prevent exposing your entire contact list."),
    'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
    'validate_callback' => 'CRM_Admin_Form_Setting_Search::enableOptionOne',
    'settings_pages' => ['search' => ['section' => 'autocomplete', 'weight' => 40]],
  ],
  'contact_smart_group_display' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_smart_group_display',
    'type' => 'String',
    'html_type' => 'radio',
    'default' => '1',
    'add' => '4.7',
    'title' => ts('Viewing Smart Groups'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Controls display of the smart groups that a contact is part of in each contact\'s "Groups" tab. "Show on Demand" provides the best performance, and is recommended for most sites.'),
    'pseudoconstant' => [
      'optionGroupName' => 'contact_smart_group_display',
    ],
    'settings_pages' => ['display' => ['weight' => 120]],
  ],
  'smart_group_cache_refresh_mode' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'smart_group_cache_refresh_mode',
    'type' => 'String',
    'html_type' => 'radio',
    'default' => 'opportunistic',
    'add' => '4.7',
    'title' => ts('Smart Group Refresh Mode'),
    'is_domain' => 1,
    'is_contact' => 0,
    'pseudoconstant' => [
      'callback' => 'CRM_Contact_BAO_GroupContactCache::getModes',
    ],
    'description' => ts('Should the smart groups be flushed by cron jobs or user actions'),
    'help_text' => ts('In "Opportunistic Flush" mode, caches are flushed in response to user actions; this mode is broadly compatible but may add latency during form-submissions. In "Cron Flush" mode, you should schedule a cron job to flush caches; this can improve latency on form-submissions but requires more setup.'),
  ],
  'acl_cache_refresh_mode' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'acl_cache_refresh_mode',
    'type' => 'String',
    'html_type' => 'radio',
    'default' => 'opportunistic',
    'add' => '5.37.0',
    'title' => ts('ACL Group Refresh Mode'),
    'is_domain' => 1,
    'is_contact' => 0,
    'pseudoconstant' => [
      'callback' => 'CRM_Contact_BAO_GroupContactCache::getModes',
    ],
    'description' => ts('Should the acl cache be flushed by cron jobs or user actions'),
    'help_text' => ts('In "Opportunistic Flush" mode, caches are flushed in response to user actions; this mode is broadly compatible but may add latency during form-submissions. In "Cron Flush" mode, you should schedule a cron job to flush caches if your site uses ACLs; this can improve latency on form-submissions but requires more setup.'),
  ],
  'max_attachments' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'max_attachments',
    'legacy_key' => 'maxAttachments',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
    ],
    'default' => 3,
    'add' => '4.3',
    'title' => ts('Maximum Attachments'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Maximum number of files (documents, images, etc.) which can be attached to emails or activities. This setting applies to UI forms and limits the number of fields available on the form.'),
    'settings_pages' => ['misc' => ['weight' => 100, 'section' => 'files']],
  ],
  'max_attachments_backend' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'max_attachments_backend',
    'legacy_key' => 'maxAttachmentsBackend',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
    ],
    'default' => CRM_Core_BAO_File::DEFAULT_MAX_ATTACHMENTS_BACKEND,
    'add' => '5.20',
    'title' => ts('Maximum Attachments For Backend Processes'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Maximum number of files (documents, images, etc.) which can be processed during backend processing such as automated inbound email processing. This should be a big number higher than the other Maximum Attachments setting above. This setting here merely provides an upper limit to prevent attacks that might overload the server.'),
    'settings_pages' => ['misc' => ['weight' => 110, 'section' => 'files']],
  ],
  'maxFileSize' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'maxFileSize',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
    ],
    // Set default to match php.ini 'upload_max_filesize'
    'default' => ini_get('upload_max_filesize') ? intval(ini_parse_quantity(ini_get('upload_max_filesize')) / (1024 * 1024)) : 3,
    'validate_callback' => 'CRM_Core_BAO_Setting::validateMaxFileSize',
    'add' => '4.3',
    'validate_callback' => 'CRM_Core_BAO_Setting::validateMaxFileSize',
    'title' => ts('Maximum File Size (in MB)'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('Maximum Size of file (documents, images, etc.) which can be attached to emails or activities.'),
      ts('Note: php.ini should support this file size.'),
    ],
    'settings_pages' => ['misc' => ['weight' => 120, 'section' => 'files']],
  ],
  'contact_undelete' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'contact_undelete',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.3',
    'title' => ts('Contact Trash and Undelete'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If enabled, deleted contacts will be moved to trash (instead of being destroyed). Users with the proper permission are able to search for the deleted contacts and restore them (or delete permanently).'),
    'validate_callback' => 'CRM_Core_BAO_Setting::validateBoolSetting',
    'settings_pages' => ['misc' => ['weight' => 20, 'section' => 'history']],
  ],
  'allowPermDeleteFinancial' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'allowPermDeleteFinancial',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => FALSE,
    'add' => '4.3',
    'title' => ts('Contact Permanent Delete'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Allow Permanent Delete for contacts who are linked to live financial transactions'),
  ],
  'securityAlert' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'securityAlert',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.4',
    'title' => ts('Status Alerts'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts("If enabled, CiviCRM will display pop-up notifications (no more than once per day) for security and misconfiguration issues identified in the system check."),
  ],
  'doNotAttachPDFReceipt' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'doNotAttachPDFReceipt',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'add' => '4.3',
    'title' => ts('Attach PDF copy to receipts'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts("If enabled, CiviCRM sends PDF receipt as an attachment during event signup or online contribution."),
    'settings_pages' => ['misc' => ['weight' => 40, 'section' => 'pdf']],
  ],
  'recordGeneratedLetters' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'recordGeneratedLetters',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'default' => 'multiple',
    'add' => '4.7',
    'title' => ts('Record generated letters'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('When generating a letter (PDF/Word) via mail-merge, how should the letter be recorded?'),
    'pseudoconstant' => [
      'callback' => 'CRM_Core_SelectValues::getPDFLoggingOptions',
    ],
    'settings_pages' => ['misc' => ['weight' => 50, 'section' => 'pdf']],
  ],
  'dompdf_font_dir' => [
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'dompdf_font_dir',
    'title' => ts('DOMPDF Font Folder'),
    'help_text' => ts('Additional folder where DOMPDF will look for fonts.'),
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 256,
    ],
    'default' => NULL,
    'add' => '5.43',
    'settings_pages' => ['misc' => ['weight' => 60, 'section' => 'pdf']],
  ],
  'dompdf_chroot' => [
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'dompdf_chroot',
    'title' => ts('DOMPDF Local Images Folder'),
    'help_text' => ts('Folder to restrict where DOMPDF looks when loading local images. By default it is the DOMPDF folder itself for security reasons. It will search in subfolders.'),
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 256,
    ],
    'default' => NULL,
    'add' => '5.43',
    'settings_pages' => ['misc' => ['weight' => 70, 'section' => 'pdf']],
  ],
  'dompdf_enable_remote' => [
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'dompdf_enable_remote',
    'title' => ts('DOMPDF Enable Remote Images'),
    'help_text' => ts('Enable the use of remote images. By default this is enabled, but if not using remote images you may wish to turn it off for security reasons.'),
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => TRUE,
    'add' => '5.43',
    'settings_pages' => ['misc' => ['weight' => 80, 'section' => 'pdf']],
  ],
  'dompdf_log_output_file' => [
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'dompdf_log_output_file',
    'title' => ts('DOMPDF Log File'),
    'help_text' => ts('DOMPDF will log debugging output in this file.'),
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 256,
    ],
    'default' => NULL,
    'add' => '5.43',
  ],
  'weasyprint_path' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'weasyprint_path',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'validate_callback' => 'CRM_Core_BAO_Setting::validateExecutable',
    'html_type' => 'text',
    'default' => NULL,
    'add' => '5.68',
    'title' => ts('Path to weasyprint executable'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('weasyprint is an alternative utility for generating PDFs which is a successor to the discontinued wkhtmltopdf. Your system administrator will need to download and install this utility, and enter the executable path here.'),
    'help_doc_url' => [
      'text' => 'weasyprint.org',
      'url' => 'https://weasyprint.org/',
    ],
    'settings_pages' => ['misc' => ['weight' => 90, 'section' => 'pdf']],
  ],
  'wkhtmltopdfPath' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'wkhtmltopdfPath',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => NULL,
    'validate_callback' => 'CRM_Core_BAO_Setting::validateExecutable',
    'add' => '4.3',
    'title' => ts('Path to wkhtmltopdf executable'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('wkhtmltopdf is a now-discontinued utility for generating PDFs. See weasyprint for an updated alternative.'),
    'help_doc_url' => [
      'text' => 'wkhtmltopdf.org',
      'url' => 'https://wkhtmltopdf.org/',
    ],
    'settings_pages' => ['misc' => ['weight' => 95, 'section' => 'pdf']],
  ],
  'checksum_timeout' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'checksum_timeout',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
      'step' => 1,
    ],
    'html_type' => 'number',
    'default' => 7,
    'add' => '4.3',
    'title' => ts('Checksum Lifespan'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('The number of days before a personalized (hashed) link will expire.'),
    'settings_pages' => ['misc' => ['weight' => 10, 'section' => 'security']],
  ],
  'blogUrl' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'blogUrl',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 128,
    ],
    'html_type' => 'text',
    'default' => '*default*',
    'add' => '4.3',
    'title' => ts('Blog Feed URL'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Blog feed URL used by the blog dashlet'),
    'help_text' => ts('Use "*default*" for the system default or override with a custom URL'),
  ],
  'communityMessagesUrl' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'communityMessagesUrl',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 128,
    ],
    'html_type' => 'text',
    'default' => '*default*',
    'add' => '4.3',
    'title' => ts('Community Messages URL'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Service providing CiviCRM community messages'),
    'help_text' => ts('Use "*default*" for the system default or override with a custom URL'),
  ],
  'gettingStartedUrl' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'gettingStartedUrl',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_attributes' => [
      'size' => 64,
      'maxlength' => 128,
    ],
    'html_type' => 'text',
    'default' => '*default*',
    'add' => '4.3',
    'title' => ts('Getting Started URL'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Service providing the Getting Started data'),
    'help_text' => ts('Use "*default*" for the system default or override with a custom URL'),
  ],
  'resCacheCode' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'resCacheCode',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => NULL,
    'add' => '4.3',
    'title' => ts('resCacheCode'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Code appended to resource URLs (JS/CSS) to coerce HTTP caching'),
  ],
  'verifySSL' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'verifySSL',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.3',
    'title' => ts('Verify SSL?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('Verifying the SSL certificate helps confirm that CiviCRM is securely communicating directly to payment processors.'),
      ts('If disabled, outbound web-service requests will allow unverified, insecure HTTPS connections'),
      ts('Unless you are absolutely unable to configure your server to check the SSL certificate of the remote server you should leave this set to Yes'),
    ],
    'settings_pages' => ['url' => ['section' => 'security', 'weight' => 60]],
  ],
  'enableSSL' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'enableSSL',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'add' => '4.5',
    'title' => ts('Force SSL?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'validateion_callback' => 'CRM_Core_BAO_Setting::validateEnableSSL',
    'help_text' => [
      ts('If enabled, inbound HTTP requests for sensitive pages will be redirected to HTTPS.'),
      ts('If you use a payment processor service where credit card and billing information is collected on your site, it is strongly recommended that you create or obtain an SSL certificate and configure your webserver to support SSL connections. Consult your hosting provider or web-server documentation for more information on obtaining and installing SSL certificates.'),
      ts('Once you have your certificate installed, test that is working by navigating to one of your online contribution pages and changing the URL prefix from "http://" to "https://". If your browser loads the page and indicates a valid security certificate - then you can change this setting to "Yes" and CiviCRM will automatically redirect requests for all online contribution / member / event / admin pages to the corresponding SSL secured URLs.'),
    ],
    'settings_pages' => ['url' => ['section' => 'security', 'weight' => 50]],
  ],
  'wpBasePage' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'wpBasePage',
    'type' => 'String',
    'html_type' => 'text',
    'quick_form_type' => 'Element',
    'default' => '',
    'add' => '4.3',
    'title' => ts('WordPress Base Page'),
    'is_domain' => 1,
    'is_contact' => 0,
    'metadata_callback' => ['CRM_Core_BAO_Setting', 'wpBasePageMetadataCallback'],
    'help_text' => [
      ts('If set, CiviCRM will use this setting as the base url.'),
      ts('By default, CiviCRM will generate front-facing pages using the home page as its base. If you want to use a different template for CiviCRM pages, set the path here.'),
    ],
    'settings_pages' => ['uf' => ['weight' => 10]],
  ],
  'secondDegRelPermissions' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'secondDegRelPermissions',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'add' => '4.3',
    'title' => ts('Allow second-degree relationship permissions'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts("If enabled, contacts with the permission to edit a related contact will inherit that contact's permission to edit other related contacts"),
    'settings_pages' => ['misc' => ['weight' => 130, 'section' => 'security']],
  ],
  'disable_core_css' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'disable_core_css',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'html_attributes' => [
      'on' => ts('Yes'),
      'off' => ts('No'),
    ],
    'default' => '0',
    'add' => '4.4',
    'title' => ts('Disable CiviCRM css'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Prevent the stylesheet "civicrm.css" from being loaded.'),
    'settings_pages' => ['url' => ['section' => 'style', 'weight' => 30]],
  ],
  'empoweredBy' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'empoweredBy',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.5',
    'title' => ts('Display "empowered by CiviCRM"'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('When enabled, "empowered by CiviCRM" is displayed at the bottom of public forms.'),
    'settings_pages' => ['display' => ['weight' => 35]],
  ],
  'logging_no_trigger_permission' => [
    'add' => '4.7',
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'help_text' => ts('If the MySQL user does not have permission to administer triggers, then you must create the triggers outside CiviCRM. No support is provided for this configuration.'),
    'name' => 'logging_no_trigger_permission',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'title' => ts('MySQL user does not have trigger permissions'),
    'description' => ts('Set this when you intend to manage trigger creation outside of CiviCRM'),
  ],
  'logging' => [
    'add' => '4.7',
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'logging',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => '0',
    'title' => ts('Logging'),
    'help_text' => ts('If enabled, all actions will be logged with a complete record of changes.'),
    'validate_callback' => 'CRM_Logging_Schema::checkLoggingSupport',
    'metadata_callback' => ['CRM_Core_BAO_Setting', 'loggingMetadataCallback'],
    'on_change' => [
      'CRM_Logging_Schema::onToggle',
    ],
    'settings_pages' => ['misc' => ['weight' => 0, 'section' => 'history']],
  ],
  'logging_uniqueid_date' => [
    'add' => '4.7',
    'help_text' => ts('This is the date when CRM-18193 was implemented'),
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'logging_uniqueid_date',
    'type' => 'Date',
    'quick_form_type' => 'DateTime',
    'html_type' => '',
    'default' => NULL,
    'title' => ts('Logging Unique ID not recorded before'),
    'description' => ts('This is the date when CRM-18193 was implemented'),
  ],
  'logging_all_tables_uniquid' => [
    'add' => '4.7',
    'help_text' => ts('This indicates there are no tables holdng pre-uniqid log_conn_id values (CRM-18193)'),
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'logging_all_tables_uniquid',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 0,
    'title' => ts('All tables use Unique Connection ID'),
    'description' => ts('Do some tables pre-date CRM-18193?'),
  ],
  'userFrameworkUsersTableName' => [
    'add' => '4.7',
    'is_domain' => 1,
    'is_contact' => 0,
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'userFrameworkUsersTableName',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => '32',
      'maxlength' => '64',
    ],
    'default' => 'users',
    'metadata_callback' => ['CRM_Core_BAO_Setting', 'userFrameworkUsersTableNameMetadataCallback'],
    'title' => ts('CMS Users Table Name'),
    'settings_pages' => ['uf' => ['weight' => 0]],
  ],
  'wpLoadPhp' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'wpLoadPhp',
    'type' => 'String',
    'html_type' => 'text',
    'quick_form_type' => 'Element',
    'default' => '',
    'add' => '4.6',
    'title' => ts('WordPress Path to wp-load.php'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('CiviCRM will use this setting as path to bootstrap WP.'),
  ],
  'secure_cache_timeout_minutes' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'secure_cache_timeout_minutes',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
    ],
    'default' => 120,
    'add' => '4.7',
    'title' => ts('Secure Cache Timeout'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Maximum number of minutes that secure form data should linger'),
  ],
  'site_id' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'site_id',
    'type' => 'String',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'default' => '',
    'add' => '4.6',
    'title' => ts('Unique Site ID'),
    'is_domain' => 1,
    'is_contact' => 0,
  ],
  'recentItemsMaxCount' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'recentItemsMaxCount',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
      'max' => CRM_Utils_Recent::MAX_ITEMS,
    ],
    'default' => 20,
    'add' => '4.7',
    'title' => ts('Recent Items'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('How many items should CiviCRM store in it\'s "Recently viewed" list.'),
      ts('NOTE: To view recent items in the menu, install the "Recent Items Menu" extension.'),
    ],
    'settings_pages' => ['misc' => ['weight' => 140, 'section' => 'history']],
  ],
  'recentItemsProviders' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'recentItemsProviders',
    'type' => 'Array',
    'html_type' => 'Select',
    'quick_form_type' => 'Select',
    'html_attributes' => [
      'multiple' => 1,
      'class' => 'crm-select2',
      'placeholder' => ts('All'),
    ],
    'default' => '',
    'add' => '4.7',
    'title' => ts('Recent Items Providers'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('What providers may save views in CiviCRM\'s "Recently viewed" list. If empty, all are in.'),
    'pseudoconstant' => [
      'callback' => 'CRM_Utils_Recent::getProviders',
    ],
    'settings_pages' => ['misc' => ['weight' => 150, 'section' => 'history']],
  ],
  'import_batch_size' => [
    'name' => 'import_batch_size',
    'type' => 'Integer',
    'default' => 50,
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 1,
    ],
    'add' => '5.62',
    'title' => ts('Import Batch Size'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('Number of records to process at once during import.'),
      ts('If your imports time out, reduce this number. You can increase it for better import performance on servers with longer timeouts.'),
    ],
    'settings_pages' => ['misc' => ['weight' => 10, 'section' => 'performance']],
  ],
  'disable_sql_memory_engine' => [
    'name' => 'disable_sql_memory_engine',
    'type' => 'Boolean',
    'default' => FALSE,
    'html_type' => 'toggle',
    'html_attributes' => [
      'on' => ts('Yes'),
      'off' => ts('No'),
    ],
    'add' => '5.82',
    'title' => ts('Disable SQL MEMORY Engine'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('Some hosting providers do not support this engine.'),
    'settings_pages' => ['misc' => ['weight' => 190, 'section' => 'performance']],
  ],
  'dedupe_default_limit' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'dedupe_default_limit',
    'type' => 'Integer',
    'default' => 0,
    'quick_form_type' => 'Element',
    'html_type' => 'number',
    'html_attributes' => [
      'class' => 'six',
      'min' => 0,
    ],
    'add' => '4.7',
    'title' => ts('Default limit for dedupe screen'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('Default to only loading matches against this number of contacts'),
      ts('Deduping larger databases can crash the server. By configuring a limit other than 0 here the dedupe query will only search for matches against a limited number of contacts.'),
    ],
    'settings_pages' => ['misc' => ['weight' => 0, 'section' => 'performance']],
  ],
  'syncCMSEmail' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'syncCMSEmail',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => 1,
    'add' => '4.7',
    'title' => ts('Sync CMS Email'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('If enabled, then CMS email id will be synchronised with CiviCRM contacts\'s primary email.'),
    'settings_pages' => ['uf' => ['weight' => 20]],
  ],
  'preserve_activity_tab_filter' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'preserve_activity_tab_filter',
    'type' => 'Boolean',
    'html_type' => 'toggle',
    'default' => '0',
    'add' => '4.7',
    'title' => ts('Preserve activity filters as a user preference'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => ts('When enabled, any filter settings a user selects on the contact\'s Activity tab will be remembered as they visit other contacts.'),
    'settings_pages' => ['display' => ['section' => 'activity', 'weight' => 30]],
  ],
  'do_not_notify_assignees_for' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'do_not_notify_assignees_for',
    'type' => 'Array',
    'add' => '4.7',
    'is_domain' => 1,
    'is_contact' => 0,
    'default' => [],
    'title' => ts('Do not notify assignees for'),
    'help_text' => ts('These activity types will be excluded from automated email notifications to assignees.'),
    'html_type' => 'select',
    'html_attributes' => [
      'multiple' => 1,
      'class' => 'huge crm-select2',
    ],
    'pseudoconstant' => [
      'optionGroupName' => 'activity_type',
    ],
    'quick_form_type' => 'Select',
    'settings_pages' => ['display' => ['section' => 'activity', 'weight' => 10]],
  ],
  'requestableMimeTypes' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'requestableMimeTypes',
    'type' => 'String',
    'html_type' => 'Text',
    'default' => 'image/jpeg,image/pjpeg,image/gif,image/x-png,image/png,image/jpg,text/html,application/pdf',
    'add' => '5.13',
    'title' => ts('Mime Types that can be passed as URL params'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Acceptable Mime Types that can be used as part of file urls'),
  ],
  'theme_frontend' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'theme_frontend',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'pseudoconstant' => [
      'callback' => 'call://themes/getAvailable',
    ],
    'default' => 'default',
    'add' => '5.16',
    'title' => ts('Frontend Theme'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('The theme system allows you to change CiviCRM\'s appearance by replacing important CSS files.'),
      ts('On WordPress, Joomla, or a similar CMS, the frontend theme determines the appearance on user-facing screens, such as the "Event Registration" screen.'),
    ],
    'settings_pages' => ['display' => ['section' => 'theme', 'weight' => 30]],
  ],
  'theme_backend' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'theme_backend',
    'type' => 'String',
    'quick_form_type' => 'Select',
    'html_type' => 'Select',
    'html_attributes' => [
      'class' => 'crm-select2',
    ],
    'pseudoconstant' => [
      'callback' => 'call://themes/getAvailable',
    ],
    'default' => 'default',
    'add' => '5.16',
    'title' => ts('Backend Theme'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => [
      ts('The theme system allows you to change CiviCRM\'s appearance by replacing important CSS files.'),
      ts('The backend theme determines the appearance on administrative screens, such as the "Manage Event" screen.'),
    ],
    'settings_pages' => ['display' => ['section' => 'theme', 'weight' => 10]],
  ],
  'http_timeout' => [
    'group_name' => 'CiviCRM Preferences',
    'group' => 'core',
    'name' => 'http_timeout',
    'type' => 'Integer',
    'quick_form_type' => 'Element',
    'html_type' => 'text',
    'html_attributes' => [
      'size' => 2,
      'maxlength' => 3,
    ],
    'default' => 5,
    'add' => '5.14',
    'title' => ts('HTTP request timeout'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('How long should HTTP requests through Guzzle application run for in seconds'),
    'help_text' => ts('Set the number of seconds http requests should run for before terminating'),
  ],
  'queue_paused' => [
    'name' => 'queue_paused',
    'type' => 'Boolean',
    'default' => FALSE,
    'html_type' => 'yesno',
    'add' => '5.67',
    'title' => ts('Is background queue temporarily disabled?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('If enabled, CiviCRM will not process background queues.'),
    'help_text' => ts('This setting will only affect sites that have background queue processing enabled (eg. coworker)'),
  ],
];
