<?php

return [
  'name' => 'PledgeBlock',
  'table' => 'civicrm_pledge_block',
  'class' => 'CRM_Pledge_DAO_PledgeBlock',
  'getInfo' => fn() => [
    'title' => ts('Pledge Block'),
    'title_plural' => ts('Pledge Blocks'),
    'description' => ts('Table containing Pledge blocks'),
    'log' => TRUE,
    'add' => '2.1',
  ],
  'getIndices' => fn() => [
    'index_entity' => [
      'fields' => [
        'entity_table' => TRUE,
        'entity_id' => TRUE,
      ],
      'add' => '2.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Pledge Block ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Pledge ID'),
      'add' => '2.1',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'entity_table' => [
      'title' => ts('Entity Table'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('physical tablename for entity being joined to pledge, e.g. civicrm_contact'),
      'add' => '2.1',
    ],
    'entity_id' => [
      'title' => ts('Entity ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('FK to entity table specified in entity_table column.'),
      'add' => '2.1',
      'entity_reference' => [
        'dynamic_entity' => 'entity_table',
        'key' => 'id',
      ],
    ],
    'pledge_frequency_unit' => [
      'title' => ts('Pledge Frequency Unit'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Text',
      'description' => ts('Delimited list of supported frequency units'),
      'add' => '2.1',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_TRIMMED,
    ],
    'is_pledge_interval' => [
      'title' => ts('Expose Frequency Interval?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is frequency interval exposed on the contribution form.'),
      'add' => '2.1',
      'default' => FALSE,
    ],
    'max_reminders' => [
      'title' => ts('Maximum Number of Reminders'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('The maximum number of payment reminders to send for any given payment.'),
      'add' => '2.1',
      'default' => 1,
    ],
    'initial_reminder_day' => [
      'title' => ts('Initial Reminder Day'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Send initial reminder this many days prior to the payment due date.'),
      'add' => '2.1',
      'default' => 5,
    ],
    'additional_reminder_day' => [
      'title' => ts('Additional Reminder Days'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Send additional reminder this many days after last one sent, up to maximum number of reminders.'),
      'add' => '2.1',
      'default' => 5,
    ],
    'pledge_start_date' => [
      'title' => ts('Pledge Start Date'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('The date the first scheduled pledge occurs.'),
      'add' => '4.7',
    ],
    'is_pledge_start_date_visible' => [
      'title' => ts('Show Recurring Donation Start Date?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If true - recurring start date is shown.'),
      'add' => '4.7',
      'default' => FALSE,
    ],
    'is_pledge_start_date_editable' => [
      'title' => ts('Allow Edits to Recurring Donation Start Date?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If true - recurring start date is editable.'),
      'add' => '4.7',
      'default' => FALSE,
    ],
  ],
];
