<?php

return [
  'name' => 'PCPBlock',
  'table' => 'civicrm_pcp_block',
  'class' => 'CRM_PCP_DAO_PCPBlock',
  'getInfo' => fn() => [
    'title' => ts('Personal Campaign Block'),
    'title_plural' => ts('Personal Campaign Blocks'),
    'description' => ts('A Personal Campaign Page Block stores admin configurable status options and rules'),
    'log' => TRUE,
    'add' => '2.2',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('PCP Block ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('PCP block ID'),
      'add' => '2.2',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'entity_table' => [
      'title' => ts('Entity Table'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'add' => '2.2',
    ],
    'entity_id' => [
      'title' => ts('Entity'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('FK to civicrm_contribution_page.id OR civicrm_event.id'),
      'add' => '2.2',
      'entity_reference' => [
        'dynamic_entity' => 'entity_table',
        'key' => 'id',
      ],
    ],
    'target_entity_type' => [
      'title' => ts('Target Entity'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('The type of entity that this pcp targets'),
      'add' => '4.1',
      'default' => 'contribute',
    ],
    'target_entity_id' => [
      'title' => ts('Target Entity ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('The entity that this pcp targets'),
      'add' => '4.1',
      'entity_reference' => [
        'dynamic_entity' => 'target_entity_type',
        'key' => 'id',
      ],
    ],
    'supporter_profile_id' => [
      'title' => ts('Supporter Profile ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_uf_group.id. Does Personal Campaign Page require manual activation by administrator? (is inactive by default after setup)?'),
      'add' => '2.2',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Supporter Profile'),
      ],
      'entity_reference' => [
        'entity' => 'UFGroup',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'owner_notify_id' => [
      'title' => ts('Owner Notification'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Radio',
      'description' => ts('FK to civicrm_option_group with name = PCP owner notifications'),
      'add' => '4.6',
      'default' => 0,
      'pseudoconstant' => [
        'option_group_name' => 'pcp_owner_notify',
      ],
    ],
    'is_approval_needed' => [
      'title' => ts('Approval Required?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Does Personal Campaign Page require manual activation by administrator? (is inactive by default after setup)?'),
      'add' => '2.2',
      'default' => FALSE,
    ],
    'is_tellfriend_enabled' => [
      'title' => ts('Tell a Friend Enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Does Personal Campaign Page allow using tell a friend?'),
      'add' => '2.2',
      'default' => FALSE,
    ],
    'tellfriend_limit' => [
      'title' => ts('Tell A Friend Limit'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Maximum recipient fields allowed in tell a friend'),
      'add' => '2.2',
      'default' => NULL,
    ],
    'link_text' => [
      'title' => ts('Link Text'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Link text for PCP.'),
      'add' => '2.2',
      'default' => NULL,
    ],
    'is_active' => [
      'title' => ts('Enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is Personal Campaign Page Block enabled/active?'),
      'add' => '2.2',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'notify_email' => [
      'title' => ts('Notification Email'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('If set, notification is automatically emailed to this email-address on create/update Personal Campaign Page'),
      'add' => '2.2',
      'default' => NULL,
    ],
  ],
];
