<?php

return [
  'name' => 'ContributionPage',
  'table' => 'civicrm_contribution_page',
  'class' => 'CRM_Contribute_DAO_ContributionPage',
  'getInfo' => fn() => [
    'title' => ts('Contribution Page'),
    'title_plural' => ts('Contribution Pages'),
    'description' => ts('A Contribution object store meta information about a single customized contribution page'),
    'log' => TRUE,
    'add' => '1.3',
    'label_field' => 'title',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/contribute/add?reset=1&action=add',
    'update' => 'civicrm/admin/contribute/settings?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/admin/contribute/manage?reset=1&action=delete&id=[id]',
    'browse' => 'civicrm/admin/contribute',
  ],
  'getIndices' => fn() => [
    'UI_name' => [
      'fields' => [
        'name' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '2.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Contribution Page ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Contribution ID'),
      'add' => '1.3',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'title' => [
      'title' => ts('Page Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'localizable' => TRUE,
      'description' => ts('Contribution Page title. For top of page display'),
      'add' => '1.3',
    ],
    'frontend_title' => [
      'title' => ts('Public Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'default_fallback' => ['title'],
      'localizable' => TRUE,
      'description' => ts('Contribution Page Public title'),
      'add' => '5.20',
    ],
    'name' => [
      'title' => ts('Unique Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Unique name for identifying contribution page'),
      'add' => '5.63',
    ],
    'intro_text' => [
      'title' => ts('Contribution Page Introduction Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Text and html allowed. Displayed below title.'),
      'add' => '1.3',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('default financial type assigned to contributions submitted via this page, e.g. Contribution, Campaign Contribution'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Financial Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'label',
        'condition_provider' => ['CRM_Financial_BAO_FinancialType', 'alterIncomeFinancialTypes'],
      ],
      'entity_reference' => [
        'entity' => 'FinancialType',
        'key' => 'id',
      ],
    ],
    'payment_processor' => [
      'title' => ts('Payment Processor'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Select',
      'description' => ts('Payment Processors configured for this contribution Page'),
      'add' => '1.8',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_TRIMMED,
      'input_attrs' => [
        'label' => ts('Payment Processors'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_payment_processor',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
    ],
    'is_credit_card_only' => [
      'title' => ts('Is Credit Card Only?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - processing logic must reject transaction at confirmation stage if pay method != credit card'),
      'add' => '1.3',
      'default' => FALSE,
    ],
    'is_monetary' => [
      'title' => ts('Is Monetary'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows real-time monetary transactions otherwise non-monetary transactions'),
      'add' => '1.6',
      'default' => TRUE,
    ],
    'is_recur' => [
      'title' => ts('Is Recurring'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows recurring contributions, valid only for PayPal_Standard'),
      'add' => '1.6',
      'default' => FALSE,
    ],
    'is_confirm_enabled' => [
      'title' => ts('Confirmation Page?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if FALSE, the confirm page in contribution pages gets skipped'),
      'add' => '4.2',
      'default' => TRUE,
    ],
    'recur_frequency_unit' => [
      'title' => ts('Recurring Frequency'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Select',
      'description' => ts('Supported recurring frequency units.'),
      'add' => '2.1',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_TRIMMED,
      'input_attrs' => [
        'multiple' => TRUE,
      ],
      'pseudoconstant' => [
        'option_group_name' => 'recur_frequency_units',
        'key_column' => 'name',
      ],
    ],
    'is_recur_interval' => [
      'title' => ts('Support Recurring Intervals'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - supports recurring intervals'),
      'add' => '2.1',
      'default' => FALSE,
    ],
    'is_recur_installments' => [
      'title' => ts('Recurring Installments?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - asks user for recurring installments'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'adjust_recur_start_date' => [
      'title' => ts('Adjust Recurring Start Date'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - user is able to adjust payment start date'),
      'add' => '4.7',
      'default' => FALSE,
    ],
    'is_pay_later' => [
      'title' => ts('Pay Later'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows the user to send payment directly to the org later'),
      'add' => '2.0',
      'default' => FALSE,
    ],
    'pay_later_text' => [
      'title' => ts('Pay Later Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('The text displayed to the user in the main form'),
      'add' => '2.0',
    ],
    'pay_later_receipt' => [
      'title' => ts('Pay Later Receipt'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('The receipt sent to the user instead of the normal receipt text'),
      'add' => '2.0',
      'input_attrs' => [
        'rows' => 8,
        'cols' => 60,
      ],
    ],
    'is_partial_payment' => [
      'title' => ts('Allow Partial Payment'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'description' => ts('is partial payment enabled for this online contribution page'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'initial_amount_label' => [
      'title' => ts('Initial Amount Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Initial amount label for partial payment'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Initial Amount Label'),
      ],
    ],
    'initial_amount_help_text' => [
      'title' => ts('Initial Amount Help Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Initial amount help text for partial payment'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Initial Amount Help Text'),
      ],
    ],
    'min_initial_amount' => [
      'title' => ts('Min Initial Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('Minimum initial amount for partial payment'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Min. Initial Amount'),
      ],
    ],
    'is_allow_other_amount' => [
      'title' => ts('Allow Other Amounts'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if TRUE, page will include an input text field where user can enter their own amount'),
      'add' => '1.3',
      'default' => FALSE,
    ],
    'default_amount_id' => [
      'title' => ts('Default Amount'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('FK to civicrm_option_value.'),
      'add' => '1.7',
    ],
    'min_amount' => [
      'title' => ts('Minimum Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('if other amounts allowed, user can configure minimum allowed.'),
      'add' => '1.3',
    ],
    'max_amount' => [
      'title' => ts('Maximum Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('if other amounts allowed, user can configure maximum allowed.'),
      'add' => '1.3',
    ],
    'goal_amount' => [
      'title' => ts('Goal Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('The target goal for this page, allows people to build a goal meter'),
      'add' => '1.5',
      'input_attrs' => [
        'label' => ts('Goal Amount'),
      ],
    ],
    'thankyou_title' => [
      'title' => ts('Thank-you Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Title for Thank-you page (header title tag, and display at the top of the page).'),
      'add' => '1.3',
    ],
    'thankyou_text' => [
      'title' => ts('Thank-you Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('text and html allowed. displayed above result on success page'),
      'add' => '1.3',
      'input_attrs' => [
        'rows' => 8,
        'cols' => 60,
      ],
    ],
    'thankyou_footer' => [
      'title' => ts('Thank-you Footer'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Text and html allowed. displayed at the bottom of the success page. Common usage is to include link(s) to other pages such as tell-a-friend, etc.'),
      'add' => '1.3',
      'input_attrs' => [
        'rows' => 8,
        'cols' => 60,
      ],
    ],
    'is_email_receipt' => [
      'title' => ts('Send email Receipt'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if TRUE, receipt is automatically emailed to contact on success'),
      'add' => '1.3',
      'default' => FALSE,
    ],
    'receipt_from_name' => [
      'title' => ts('Receipt From'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('FROM email name used for receipts generated by contributions to this contribution page.'),
      'add' => '1.3',
    ],
    'receipt_from_email' => [
      'title' => ts('Receipt From email'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('FROM email address used for receipts generated by contributions to this contribution page.'),
      'add' => '1.3',
    ],
    'cc_receipt' => [
      'title' => ts('Receipt cc'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('comma-separated list of email addresses to cc each time a receipt is sent'),
      'add' => '1.3',
    ],
    'bcc_receipt' => [
      'title' => ts('Receipt bcc'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('comma-separated list of email addresses to bcc each time a receipt is sent'),
      'add' => '1.3',
    ],
    'receipt_text' => [
      'title' => ts('Receipt Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('text to include above standard receipt info on receipt email. emails are text-only, so do not allow html for now'),
      'add' => '1.3',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'is_active' => [
      'title' => ts('Is Page Active?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this page active?'),
      'add' => '1.3',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'footer_text' => [
      'title' => ts('Footer Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Text and html allowed. Displayed at the bottom of the first page of the contribution wizard.'),
      'add' => '1.4',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'amount_block_is_active' => [
      'title' => ts('Is Amount Block Active?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property active?'),
      'add' => '1.5',
      'default' => TRUE,
    ],
    'start_date' => [
      'title' => ts('Contribution Page Start Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that this page starts.'),
      'add' => '1.8',
    ],
    'end_date' => [
      'title' => ts('Contribution Page End Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that this page ends. May be NULL if no defined end date/time'),
      'add' => '1.8',
    ],
    'created_id' => [
      'title' => ts('Created By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contact, who created this contribution page'),
      'add' => '3.0',
      'default_callback' => ['CRM_Core_Session', 'getLoggedInContactID'],
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'created_date' => [
      'title' => ts('Contribution Page Created Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that contribution page was created.'),
      'required' => TRUE,
      'readonly' => TRUE,
      'default' => 'CURRENT_TIMESTAMP',
      'add' => '3.0',
    ],
    'currency' => [
      'title' => ts('Contribution Page Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.3',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
        'description_column' => 'IFNULL(CONCAT(name, " (", symbol, ")"), name)',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The campaign for which we are collecting contributions with this page.'),
      'add' => '3.4',
      'component' => 'CiviCampaign',
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'is_share' => [
      'title' => ts('Is Contribution Page Shared?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Can people share the contribution page through social media?'),
      'add' => '4.1',
      'default' => TRUE,
    ],
    'is_billing_required' => [
      'title' => ts('Is billing block required'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - billing block is required for online contribution page'),
      'add' => '4.6',
      'default' => FALSE,
    ],
  ],
];
