# CiviCRM 6.9.0

Released December 3, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Allow setting labels for SK imports and batches
  ([dev/core#6104](https://lab.civicrm.org/dev/core/-/issues/6104):
  [33743](https://github.com/civicrm/civicrm-core/pull/33743),
  [33803](https://github.com/civicrm/civicrm-core/pull/33803),
  [33810](https://github.com/civicrm/civicrm-core/pull/33810) and
  [33737](https://github.com/civicrm/civicrm-core/pull/33737))**

   Makes it so users can add a label/title to SK imports and batches, like they
   could for the old-style accounting batches. Making it easier for accounting
   folks to keep track of their imports and batches, which is currently
   difficult.

 - **Open files in new tab
   ([33923](https://github.com/civicrm/civicrm-core/pull/33923))**

   Adds target="_blank" to file links.

- **Make Font Awesome icons more accessible
  ([dev/core#5041](https://lab.civicrm.org/dev/core/-/issues/5041):
  [33630](https://github.com/civicrm/civicrm-core/pull/33630))**

  Improves accessibility of font awesome icons.

- **Enable user to pick columns when viewing/downloading table search displays
  ([33807](https://github.com/civicrm/civicrm-core/pull/33807),
  [33914](https://github.com/civicrm/civicrm-core/pull/33914),
  [33948](https://github.com/civicrm/civicrm-core/pull/33948) and
  [33994](https://github.com/civicrm/civicrm-core/pull/33994))**

  Adds a setting to enable clientside column toggling on table searchkit
  displays.

- **Setup - Install FormBuilder by default
  ([33788](https://github.com/civicrm/civicrm-core/pull/33788))**

  Begins installing FormBuilder by default for new sites.

- **Adding Toggle to Afform
  ([33949](https://github.com/civicrm/civicrm-core/pull/33949))**

  Adds a new Field input type that replicates the Checkbox but outputs as a
  toggle.

- **Proposal: Add possibilty to assign custom CSS classes to containers in Form
  Builder ([33956](https://github.com/civicrm/civicrm-core/pull/33956))**

  Makes container styles an Afform option group.

- **FormBuilder - Add config option for min & max of number fields
  ([33514](https://github.com/civicrm/civicrm-core/pull/33514))**

  Makes it so one can configure a min and max value for formbuilder number
  fields.

- **Afform - Add per-user submission limit
  ([33645](https://github.com/civicrm/civicrm-core/pull/33645))**

  Makes it so one can limit afform submissions per user.

- **Add more helpful error logs when things go wrong with searchkit/formbuilder
  ([33558](https://github.com/civicrm/civicrm-core/pull/33558))**

  Improves logging for SearchKit/FormBuilder errors.

- **When processing an Afform set status to Pending on create and then Processed
  when it has actually been processed
  ([33947](https://github.com/civicrm/civicrm-core/pull/33947))**

  Adds a pending status for afform submissions when verifiying submissions.

- **afForm - let others know when submit fails
  ([34013](https://github.com/civicrm/civicrm-core/pull/34013))**

  Adds two new events: `crmFormSuccess` event lets people know afForm submit
  has succeeded. `crmFormError` event lets people know afForm submit has failed.

- **Multilingual FormBuilder: allow to force translation source locale
  ([33875](https://github.com/civicrm/civicrm-core/pull/33875))**

  Improves form builder user experience for multilingual users.

- **Afform: extra context information for activity and autofill activity in
  FormBuilder ([dev/core#6147](https://lab.civicrm.org/dev/core/-/issues/6147):
  [33764](https://github.com/civicrm/civicrm-core/pull/33764))**

  Makes it so one can add activity ID to the Bearer Token and adds formbuilder
  behavior to autofill activity ID based on the bearer token.

- **SearchKit - Make option format selectable in main search  
  ([33600](https://github.com/civicrm/civicrm-core/pull/33600))**

  Makes searchkit main search option formats selectable.

- **SearchKit: Add new EmailReport action for the SearchDisplay entity.
  ([33915](https://github.com/civicrm/civicrm-core/pull/33915))**

  Adds the ability to Email a SearchDisplay to one or more contacts.

- **SearchKit admin - accordions, use Civi accordion pattern/class and body
  wrapper ([33798](https://github.com/civicrm/civicrm-core/pull/33798))**

  Makes the searchkit admin user interface accordions styling consistent with
  the rest of civi.

- **Add 'No Results' text to SearchKit grid display
  ([33721](https://github.com/civicrm/civicrm-core/pull/33721))**

  Allows one to configure "No Results" text on SearchKit grid displays, this is
  already available on table, list etc.

- **Order API: Support API4 style pseudoconstants for related entities on
  lineitems ([33971](https://github.com/civicrm/civicrm-core/pull/33971))**

  Improves Order API to support pseudoconstants for related entities.

- **Api4 - Accept rule group id in Contact::getDuplicates
  ([33812](https://github.com/civicrm/civicrm-core/pull/33812))**

  Improves the Api4 dedupe function to accept name or id of a dedupe rule.

- **importer: recognize urls for eck entities
  ([33628](https://github.com/civicrm/civicrm-core/pull/33628))**

  Makes it so one can use the importer for eck entities.

- **Riverlea adds input:disabled support
  ([33804](https://github.com/civicrm/civicrm-core/pull/33804))**

  Adds support input:disabled ie, `<input disabled />`.

- **Riverlea: add settings item to set the font size for all streams
  ([33849](https://github.com/civicrm/civicrm-core/pull/33849))**

  Adds a setting to the Riverlea settings screen to set the font size.

- **Restructure colour variable handing (prep for customiser)
  ([dev/riverlea#149](https://lab.civicrm.org/extensions/riverlea/-/issues/149):
  [33802](https://github.com/civicrm/civicrm-core/pull/33802) and
  [34135](https://github.com/civicrm/civicrm-core/pull/34135))**

  Improvements to RiverLea colour variable handling.

- **Riverlea - allow sourcing fonts locally
  ([33612](https://github.com/civicrm/civicrm-core/pull/33612))**

  Allows RiverLea sites to source fonts locally.

- **RiverLea: tidies disabled row for scheduled jobs
  ([33816](https://github.com/civicrm/civicrm-core/pull/33816))**

  Improves the display of disabled scheduled jobs.

- **Use civicrm/home rather than civicrm/dashboard for home nav url
  ([33782](https://github.com/civicrm/civicrm-core/pull/33782))**

  Changes the CiviCRM home link to civicrm/home rather than civicrm/dashboard.
  This is the current behaviour on Standalone, and makes it easier to provide a
  custom home page with FormBuilder.

- **Manage Extensions Improvements
  ([33830](https://github.com/civicrm/civicrm-core/pull/33830),
  [33872](https://github.com/civicrm/civicrm-core/pull/33872) and
  [33856](https://github.com/civicrm/civicrm-core/pull/33856))**

  Improves the Manage extension page by adding search, cleaning up and
  supporting url label translations.

- **OAuth Client - Show button to manually refresh token
  ([33539](https://github.com/civicrm/civicrm-core/pull/33539))**

  Updates the screen "Admin => System Settings => OAuth" with another button
  that helps with debugging/development/etc.

- **Add brief description of what Scheduled Communications does
  ([33820](https://github.com/civicrm/civicrm-core/pull/33820))**

  Adds more information about what Scheduled Communications does.

- **Encourage `scan-classes` for extensions providing Api4 entities
  ([33713](https://github.com/civicrm/civicrm-core/pull/33713))**

  Adds a status check when a site has an extension providing entities through
  the Legacy Entity Scanner to encourage them to update the code to use
  <code>scan-classes</code> mixin for better performance and future proofing.

- **Add / update forms for quick edit contacts from autocomplete
  ([33935](https://github.com/civicrm/civicrm-core/pull/33935))**

  Adds quick edit forms for Organizations and Households and expands the
  Individual form to include the email and address blocks.

- **Autocomplete - Add entity id if available
  ([33719](https://github.com/civicrm/civicrm-core/pull/33719))**

  Makes the entity id being edited known to autocomplete subscribers.

- **OAuthProvider - Allow tags on providers (e.g. "CiviConnect")
  ([33835](https://github.com/civicrm/civicrm-core/pull/33835))**

  Adds an extra field on the OAuthProvider record called tags. Tags can be used
  as a basic flag for the purpose/behavior of each OAuth integration.

- **OAuthClient - Add `$ttl` and `$responseMode` to AuthorizationCode flow
  ([33712](https://github.com/civicrm/civicrm-core/pull/33712))**

  OAuth's "Authorization Code" defines a pageflow where a client site (e.g.
  Civi) requests credentials from an external site. This Adds two more
  options for that flow: "time to live" ($ttl) and "response mode"
  ($responseMode).

- **Settings - Add support for metadata callbacks
  ([33768](https://github.com/civicrm/civicrm-core/pull/33768))**

  Allows setting metadata to be dynamic.

- **Improve ALL settings pages: sections, help text, validation
  ([33985](https://github.com/civicrm/civicrm-core/pull/33985),
  [33900](https://github.com/civicrm/civicrm-core/pull/33900),
  [33786](https://github.com/civicrm/civicrm-core/pull/33786) and
  [33767](https://github.com/civicrm/civicrm-core/pull/33767))**

  Improves CiviCRM settings pages and settings metadata.

- **Make Dashboard And Dashboard Contact Entities Searchable
  ([33983](https://github.com/civicrm/civicrm-core/pull/33983))**

  Makes dashboard and dashboard contact entities searchable in search kit
  reports as it could be useful for configuring the dashboards for back office
  users.

- **JWT - Add support for signing/verifying with EdDSA
  ([33667](https://github.com/civicrm/civicrm-core/pull/33667))**

  Adds support for asymmetric signatures (using EdDSA with public/private
  key-pair).

- **Use labels for pseudoconstants in import SearchDisplays
  ([33717](https://github.com/civicrm/civicrm-core/pull/33717))**

  Makes it so Pseudoconstants show their label, but only when they are fields on
  the entity imported, not on joined entities.

### CiviContribute

- **SearchUI Find Contributions - use Line Item for Financial Type
  ([33573](https://github.com/civicrm/civicrm-core/pull/33573))**

  Amends the Find Contributions search in SearchUI to use Financial Type from
  Line Item rather than Contribution.

- **Add created/modified date columns to Contribution
  ([33855](https://github.com/civicrm/civicrm-core/pull/33855))**

  Adds columns for created_date and modified_date to the contribution table.

- **Add Refund permission and API4 PaymentProcessor.Refund
  ([33694](https://github.com/civicrm/civicrm-core/pull/33694))**

  Adds a "Refund contributions" permission to CiviCRM. Adds an
  API4 PaymentProcessor.Refund. Makes both API3 PaymentProcessor.Refund and API4
  PaymentProcessor.Refund require "Refund contributions" permission. Removes
  "Record Refund" buttons and access to Refund (AdditionalPayment in refund
  mode) form if user doesn't have permission.

### CiviEvent

- **Add created/modified date columns to Participant
  ([33867](https://github.com/civicrm/civicrm-core/pull/33867))**

  Adds columns for created_date and modified_date to the participants table.

- **Extend events to disable confirmation screen for paid events
  ([33720](https://github.com/civicrm/civicrm-core/pull/33720))**

  Extends event to disable confirmation screen for paid events.

### CiviMail

- **Proposal Queue validating / recording some mailing events (Work towards
  [dev/core#6087](https://lab.civicrm.org/dev/core/-/issues/6087):
  [33936](https://github.com/civicrm/civicrm-core/pull/33936),
  [33998](https://github.com/civicrm/civicrm-core/pull/33998),
  [34002](https://github.com/civicrm/civicrm-core/pull/34002) and
  [33992](https://github.com/civicrm/civicrm-core/pull/33992))**

  Adds a queuing mechansim to process tracked opens and click throughs to avoid
  potential congestion issues on the civicrm_mailing_event_queue table.

- **CiviMail - Use native html range elements instead of jQuery sliders
  ([33989](https://github.com/civicrm/civicrm-core/pull/33989))**

  Replaces jQuery sliders with native html range inputs.

- **AdminUI: add Mailing Click-Through report
  ([33814](https://github.com/civicrm/civicrm-core/pull/33814))**

  Provides a SearchKit/FormBuilder alternative to the Mailing Click-Through
  report that is accessible from the Mailing Report.

### Joomla Integration

- **Joomla 5 compatibility (Work Towards
  [dev/joomla#54](https://lab.civicrm.org/dev/joomla/-/issues/54):
  [33916](https://github.com/civicrm/civicrm-core/pull/33916))**

  Works towards Joomla 5 compatibility.

### WordPress Integration

- **Proposal: Support access by CMS role on all CMSes
  (Work towards [dev/core#6008](https://lab.civicrm.org/dev/core/-/issues/6008):
  [33486](https://github.com/civicrm/civicrm-core/pull/33486))**

  Check for CiviReport access by role in WordPress.

### Standalone Integration

- **standalone: Remember me MFA bypass
  ([33833](https://github.com/civicrm/civicrm-core/pull/33833))**

  Implements a "remember me" functionality, which means that after a successful
  login including MFA, next time logins from that browser will not require MFA
  for a longer period.

- **Standalone crmLogin component - render a message if a user is already logged
  in ([33800](https://github.com/civicrm/civicrm-core/pull/33800))**

  Improves standalone login workflow by rendering a message if the user is
  already logged in.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Use submitted date format instead of template format for contact import
  ([34097](https://github.com/civicrm/civicrm-core/pull/34097))**

- **Can't upgrade from before 6.8 using web UI
  ([dev/core#6214](https://lab.civicrm.org/dev/core/-/issues/6214):
  [34114](https://github.com/civicrm/civicrm-core/pull/34114))**

- **Employer Relationship update removes employer_id on contact
  ([dev/core#6211](https://lab.civicrm.org/dev/core/-/issues/6211):
  [34149](https://github.com/civicrm/civicrm-core/pull/34149))**

- **Prevent duplication of unsent scheduled reminders
  ([31600](https://github.com/civicrm/civicrm-core/pull/31600))**

- **Remove id from cache tables
  ([dev/core#2290](https://lab.civicrm.org/dev/core/-/issues/2290):
  [30906](https://github.com/civicrm/civicrm-core/pull/30906))**

- **Problem with navigation keys stored in civicrm_settings table / proposal to
  move it ([dev/core#4073](https://lab.civicrm.org/dev/core/-/issues/4073):
  [33759](https://github.com/civicrm/civicrm-core/pull/33759))**

- **Let "Number" and "Money"-type custom fields be nullable
  ([dev/core#4169](https://lab.civicrm.org/dev/core/-/issues/4169):
  [33497](https://github.com/civicrm/civicrm-core/pull/33497))**

- **The action in SearchKit "download spreadsheet" requires a permission (access
  CiviCRM backend and API) that is too large
  ([dev/core#5950](https://lab.civicrm.org/dev/core/-/issues/5950):
  [33912](https://github.com/civicrm/civicrm-core/pull/33912))**

- **Custom Checkbox/Radio lists - multiple issues
  ([dev/core#6039](https://lab.civicrm.org/dev/core/-/issues/6039):
  [33466](https://github.com/civicrm/civicrm-core/pull/33466))**

  Fixes multiple display issues with custom-field radio/checkboxes.

- **Error when deleting file upload from profile
  ([dev/core#6098](https://lab.civicrm.org/dev/core/-/issues/6098):
  [33776](https://github.com/civicrm/civicrm-core/pull/33776))**

- **Back office membership creation with status override and pending
  contribution: Pending (Incomplete Transaction) instead of Pending (Pay Later)
  ([dev/core#6115](https://lab.civicrm.org/dev/core/-/issues/6115):
  [33702](https://github.com/civicrm/civicrm-core/pull/33702))**

- **SearchKitBatch: User Job Type of search_batch_import prevents FK from import
  table to entity
  ([dev/core#6125](https://lab.civicrm.org/dev/core/-/issues/6125):
  [33715](https://github.com/civicrm/civicrm-core/pull/33715))**

- **Fixes Search kit Task issues in the front end
  ([dev/core#6179](https://lab.civicrm.org/dev/core/-/issues/6179):
  [33993](https://github.com/civicrm/civicrm-core/pull/33993) and
  [33951](https://github.com/civicrm/civicrm-core/pull/33951))**

- **Fatal error: Uncaught TypeError:
  Civi\AfformAdmin\AfformAdminMeta::getLocales(): Return value must be of type
  array, null returned
  ([dev/core#6180](https://lab.civicrm.org/dev/core/-/issues/6180):
  [33954](https://github.com/civicrm/civicrm-core/pull/33954) and
  [33952](https://github.com/civicrm/civicrm-core/pull/33952))**

- **Recent toggle columns change breaks SKBatch
  ([dev/core#6185](https://lab.civicrm.org/dev/core/-/issues/6185):
  [33986](https://github.com/civicrm/civicrm-core/pull/33986))**

- **Afform Translations - Search box doesn't work
  ([dev/core#6191](https://lab.civicrm.org/dev/core/-/issues/6191):
  [34158](https://github.com/civicrm/civicrm-core/pull/34158))**

- **Afform - Prevent double-validation messages
  ([33769](https://github.com/civicrm/civicrm-core/pull/33769))**

- **Add getSubmittedValues() to Afform AbstractProcessor so that we have access to
  all form values when processing a specific entity
  ([33741](https://github.com/civicrm/civicrm-core/pull/33741))**

- **Generate Base Page URL for front-end Afform "MessageTokens"
  ([33636](https://github.com/civicrm/civicrm-core/pull/33636))**

- **Show detailed error message for anonymous users when Afform validation fails
  ([33924](https://github.com/civicrm/civicrm-core/pull/33924))**

- **riverlea - fix loading fonts with relative urls
  ([34024](https://github.com/civicrm/civicrm-core/pull/34024))**

- **RiverLea: Form table label column - change width to minimum to avoid
  inconsistent squishing
  ([33836](https://github.com/civicrm/civicrm-core/pull/33836))**

- **Riverlea - rename stream vars file to `_main.css`, move overrides from
  `civicrm.css` ([33859](https://github.com/civicrm/civicrm-core/pull/33859))**

- **Links in the Search Kit search results are not clearly differentiated from
  normal text.
  ([extensions/riverlea/#157](https://lab.civicrm.org/extensions/riverlea/-/issues/157):
  [33850](https://github.com/civicrm/civicrm-core/pull/33850))**

- **Riverlea - remove some double defs of vars
  ([33817](https://github.com/civicrm/civicrm-core/pull/33817))**

- **RiverLea / FormBuilder UI - removes last of the wobbly mouseover…
  ([33988](https://github.com/civicrm/civicrm-core/pull/33988))**

- **RL: select-list close icon position
  ([33778](https://github.com/civicrm/civicrm-core/pull/33778))**

- **Make sure FormBuilder GUI Editor field settings button is clickable
  ([33773](https://github.com/civicrm/civicrm-core/pull/33773))**

- **FormBuilder - Fix js error
  ([33978](https://github.com/civicrm/civicrm-core/pull/33978))**

- **FormBuilder - Fix labels for CheckBoxes
  ([33963](https://github.com/civicrm/civicrm-core/pull/33963))**

- **Make copy button optional in af-repeat
  ([33955](https://github.com/civicrm/civicrm-core/pull/33955))**

- **Only show copy button in af-repeat block when there is at least one row
  ([33957](https://github.com/civicrm/civicrm-core/pull/33957))**

- **FormBuilder - Take guesswork out of multiselect vs single select
  ([34017](https://github.com/civicrm/civicrm-core/pull/34017))**

- **Fixes red on red button in Formbuilder Admin UI in Thames stream.
  ([33891](https://github.com/civicrm/civicrm-core/pull/33891))**

- **SearchKit - Remove redundant table classes from "Header" section
  ([33910](https://github.com/civicrm/civicrm-core/pull/33910))**

- **SearchKit - Fix db entity views with long column names
  ([33809](https://github.com/civicrm/civicrm-core/pull/33809))**

- **Remove double error alert on searchkit batch runner. Make
  runMsg/successMsg/errorMsg optional
  ([33790](https://github.com/civicrm/civicrm-core/pull/33790))**

- **CRM_Api4_Page_AJAX: Always log errors
  ([33890](https://github.com/civicrm/civicrm-core/pull/33890))**

- **APIv4 Explorer - Joins for write actions fixes
  ([33799](https://github.com/civicrm/civicrm-core/pull/33799))**

- **Api4 Explorer - Fix cli formatting
  ([33793](https://github.com/civicrm/civicrm-core/pull/33793))**

- **EFv1 - Add 'module' if missing
  ([34000](https://github.com/civicrm/civicrm-core/pull/34000))**

- **CustomGroup - Return to main screen after deleting group
  ([33997](https://github.com/civicrm/civicrm-core/pull/33997))**

- **Update database defaults when custom field option values are saved.
  ([33979](https://github.com/civicrm/civicrm-core/pull/33979))**

- **BAO - Consistently call hook_civicrm_post with $params
  ([33962](https://github.com/civicrm/civicrm-core/pull/33962))**

- **Fix product image upload URL, bigger thumbnail
  ([33748](https://github.com/civicrm/civicrm-core/pull/33748))**

- **Additional settings help text cleanup
  ([33909](https://github.com/civicrm/civicrm-core/pull/33909))**

- **Use loaded contribution now that it is always populated
  ([33899](https://github.com/civicrm/civicrm-core/pull/33899))**

- **Manage Extensions: fix License PHP warning
  ([33895](https://github.com/civicrm/civicrm-core/pull/33895))**

- **Allow expired user jobs to exist until they have been deleted
  ([33828](https://github.com/civicrm/civicrm-core/pull/33828))**

- **Remove 'every minute' repetition option from scheduled reminder form
  ([33683](https://github.com/civicrm/civicrm-core/pull/33683))**

- **Settings - Add validate_callback to maxFileSize + test fix
  ([33754](https://github.com/civicrm/civicrm-core/pull/33754))**

- **[PHP8.5] Use canonical type casts
  ([33906](https://github.com/civicrm/civicrm-core/pull/33906))**

- **Prevent errors when creating tables that already exist
  ([33913](https://github.com/civicrm/civicrm-core/pull/33913))**

- **smarty/php warning on relationship types screen
  ([33784](https://github.com/civicrm/civicrm-core/pull/33784))**

- **CRM_Utils_Type - Return floats as floats
  ([33925](https://github.com/civicrm/civicrm-core/pull/33925))**

- **Mixins - Add mgd-php@2. Use tighter search to ignore nested submodules.
  ([33921](https://github.com/civicrm/civicrm-core/pull/33921))**

- **AbstractProcessor: use stricter regex for replacing tokens
  ([33757](https://github.com/civicrm/civicrm-core/pull/33757))**

- **bin/csv/export.php: support PHP 8
  ([33736](https://github.com/civicrm/civicrm-core/pull/33736))**

- **Stop passing contribution_mode from v3 order, participant form
  ([33884](https://github.com/civicrm/civicrm-core/pull/33884))**

- **Don't break word in Contact summary tab count
  ([33714](https://github.com/civicrm/civicrm-core/pull/33714))**

- **Status Check - Fix extraneous PHP warning
  ([34077](https://github.com/civicrm/civicrm-core/pull/34077))**

- **Geocoder: Don't set lat/lon to 0,0 on error
  ([33960](https://github.com/civicrm/civicrm-core/pull/33960))**

- **AbstractAction: Execute options callback only if container is booted
  ([33897](https://github.com/civicrm/civicrm-core/pull/33897))**

- **Fix wobbly mouseover in AfGuiEditor
  ([33869](https://github.com/civicrm/civicrm-core/pull/33869))**

- **Fix group contact import to work
  ([33878](https://github.com/civicrm/civicrm-core/pull/33878))**

- **Fix page title on report template list
  ([33907](https://github.com/civicrm/civicrm-core/pull/33907))**

- **Clarify IF
  ([33887](https://github.com/civicrm/civicrm-core/pull/33887))**

- **Fix function name
  ([33946](https://github.com/civicrm/civicrm-core/pull/33946))**

- **Fixing Toggle padding
  ([34041](https://github.com/civicrm/civicrm-core/pull/34041))**

- **fix locale selector hide on monolingual
  ([34010](https://github.com/civicrm/civicrm-core/pull/34010))**

- **Fix float precision edge case (server dependent)
  ([33847](https://github.com/civicrm/civicrm-core/pull/33847))**

- **Forms - Fix the little x next to radio buttons
  ([34056](https://github.com/civicrm/civicrm-core/pull/34056))**

- **Stop passing static array to only one function
  ([33888](https://github.com/civicrm/civicrm-core/pull/33888))**

- **Utils - Ensure consistent return values from `getRgb()`
  ([33806](https://github.com/civicrm/civicrm-core/pull/33806))**

- **DocUrl - Code cleanup and html escaping
  ([33726](https://github.com/civicrm/civicrm-core/pull/33726))**

- **pick correct contact type when updating contact sub types
  ([33689](https://github.com/civicrm/civicrm-core/pull/33689))**

- **Misc ts usage fixes
  ([33779](https://github.com/civicrm/civicrm-core/pull/33779) and
  [33783](https://github.com/civicrm/civicrm-core/pull/33783))**

- **Keep PNG transparency when resizing images
  ([33747](https://github.com/civicrm/civicrm-core/pull/33747))**

- **Throw exception if the contact ID in an import is deleted
  ([33760](https://github.com/civicrm/civicrm-core/pull/33760))**

- **Fix E-notice passing null to explode.
  ([33739](https://github.com/civicrm/civicrm-core/pull/33739))**

### CiviCase

- **Fix crash when you don't have a target contact and are updating a case
  activity ([34166](https://github.com/civicrm/civicrm-core/pull/34166))**

- **CiviCase: when opening case display custom fields by default if there is
  only one case type
  ([dev/core#6158](https://lab.civicrm.org/dev/core/-/issues/6158):
  [33822](https://github.com/civicrm/civicrm-core/pull/33822))**

- **CiviCase: if contact is an Organization or Household, cannot change Case
  Coordinator (or, must edit Case Coordinator relationship type)
  ([dev/core#3145](https://lab.civicrm.org/dev/core/-/issues/3145):
  [33725](https://github.com/civicrm/civicrm-core/pull/33725))**

### CiviContribute

- **CiviContribute - Subsystem admin cannot edit payment processor
  ([dev/core#6216](https://lab.civicrm.org/dev/core/-/issues/6216):
  [34125](https://github.com/civicrm/civicrm-core/pull/34125))**

- **Fix API4 Payment.Get contribution_id field not found when passing in
  contribution ID and use where clause for more flexibility/standardisation
  ([33695](https://github.com/civicrm/civicrm-core/pull/33695))**

- **PaymentProcessor Setting Errors
  ([dev/core#6165](https://lab.civicrm.org/dev/core/-/issues/6165):
  [33837](https://github.com/civicrm/civicrm-core/pull/33837))**

  Adds a checks for values before trying to use potential null references.

- **'Import to' fields not loading from template in import contributions process
  ([dev/core#6169](https://lab.civicrm.org/dev/core/-/issues/6169):
  [33917](https://github.com/civicrm/civicrm-core/pull/33917))**

- **User/Admin groups are exposed in receipt email when contribution page
  profile has groups field and receipt is re-sent by admin from backend
  ([dev/core#5854](https://lab.civicrm.org/dev/core/-/issues/5854):
  [32978](https://github.com/civicrm/civicrm-core/pull/32978))**

- **Download invoice button on contribution fails to attach it to activity on
  windows ([dev/core#3807](https://lab.civicrm.org/dev/core/-/issues/3807):
  [33723](https://github.com/civicrm/civicrm-core/pull/33723))**

- **Stop assigning deprecated mail variables to online contribution receipt
  ([33942](https://github.com/civicrm/civicrm-core/pull/33942))**

- **Fix misleading message on Premiums section of contribution pages
  ([33575](https://github.com/civicrm/civicrm-core/pull/33575))**

- **Stop passing a slightly different copy of params just to get the
  contribution status
  ([33853](https://github.com/civicrm/civicrm-core/pull/33853))**

- **Having a custom name for a Contact Type breaks Contribution Import process
  ([dev/core#6160](https://lab.civicrm.org/dev/core/-/issues/6160):
  [33826](https://github.com/civicrm/civicrm-core/pull/33826))**

- **Consistently use "Invoice Reference" instead of "Invoice ID"
  ([dev/core#6092](https://lab.civicrm.org/dev/core/-/issues/6092):
  [33718](https://github.com/civicrm/civicrm-core/pull/33718))**

### CiviEvent

- **Fix event import to work
  ([33873](https://github.com/civicrm/civicrm-core/pull/33873))**

- **Event Repeat is broken: The start date must be the first occurrence
  ([dev/core#6182](https://lab.civicrm.org/dev/core/-/issues/6182):
  [33973](https://github.com/civicrm/civicrm-core/pull/33973))**

- **Participant import: mapping UI broken if Households are disabled
  ([dev/core#6181](https://lab.civicrm.org/dev/core/-/issues/6181):
  [33964](https://github.com/civicrm/civicrm-core/pull/33964))**

### CiviMail

- **Mailings list shows duplicate (or multiple) entries for the same mailing
  ([dev/core#6199](https://lab.civicrm.org/dev/core/-/issues/6199):
  [34086](https://github.com/civicrm/civicrm-core/pull/34086))**

- **Fix failure to clear cache when editing mailing components
  ([33841](https://github.com/civicrm/civicrm-core/pull/33841))**

- **Browse Mailings: respect global search setting
  ([33777](https://github.com/civicrm/civicrm-core/pull/33777))**

- **Fatal error when attempting to access civicrm/mailing/optout, due to
  case-sensitive reference to CRM_Mailing_Form_Optout
  ([dev/core#6173](https://lab.civicrm.org/dev/core/-/issues/6173):
  [33918](https://github.com/civicrm/civicrm-core/pull/33918))**

- **Stop passing ids into add function for `MailingComponent`
  ([33839](https://github.com/civicrm/civicrm-core/pull/33839))**

### Drupal Integration

- **Fix setUFLocale for Drupal10 and Backdrop
  ([34106](https://github.com/civicrm/civicrm-core/pull/34106))**

- **Drupal7/Backdrop: Smarty5 error if the CiviCRM-Smarty input filter is used
  ([dev/drupal#203](https://lab.civicrm.org/dev/drupal/-/issues/203):
  [693](https://github.com/civicrm/civicrm-drupal/pull/693))**

### Joomla Integration

- **RiverLea: Fix Joomla sticky header offset
  ([33846](https://github.com/civicrm/civicrm-core/pull/33846))**

### Standalone Integration

- **rename View My Contact menu item; remove on Standalone
  ([33781](https://github.com/civicrm/civicrm-core/pull/33781))**

  Renames the new View my contact menu item and remove it on Standalone because
  its redundant.

- **Logging in is quite slow (standalone)
  ([dev/core#6060](https://lab.civicrm.org/dev/core/-/issues/6060):
  [33414](https://github.com/civicrm/civicrm-core/pull/33414))**

### WordPress Integration

- **Workaround WordPress frontend always returning http 200
  ([33792](https://github.com/civicrm/civicrm-core/pull/33792) and
  [33976](https://github.com/civicrm/civicrm-core/pull/33976))**

- **Alternative way to avoid starting a PHP session unless necessary
  ([354](https://github.com/civicrm/civicrm-wordpress/pull/354))**

## <a name="misc"></a>Miscellany

- **rename new method AbstractProcessor::getEntityValues => getSubmittedValues
  ([34105](https://github.com/civicrm/civicrm-core/pull/34105)**

- **Move variables to where they are used
  ([33886](https://github.com/civicrm/civicrm-core/pull/33886))**

- **Use FinancialProcessor functions for status
  ([33870](https://github.com/civicrm/civicrm-core/pull/33870))**

- **Use financial processor to check original, updated contribution
  ([33864](https://github.com/civicrm/civicrm-core/pull/33864))**

- **Switch transferParticipant to use the v4 api
  ([33940](https://github.com/civicrm/civicrm-core/pull/33940))**

- **Extract out remaining usage of MembershipPayment
  ([32222](https://github.com/civicrm/civicrm-core/pull/32222))**

- **composer.lock - Update composer-compile-plugin
  ([33991](https://github.com/civicrm/civicrm-core/pull/33991))**

- **Deprecate function with no universe callers
  ([33926](https://github.com/civicrm/civicrm-core/pull/33926))**

- **Deprecate old `$lineItem` template assignment
  ([33943](https://github.com/civicrm/civicrm-core/pull/33943))**

- **Make financial processor non-static
  ([33871](https://github.com/civicrm/civicrm-core/pull/33871))**

- **Stop adding deprectated values to event online template
  ([33938](https://github.com/civicrm/civicrm-core/pull/33938))**

- **Make more functions non-static
  ([33881](https://github.com/civicrm/civicrm-core/pull/33881))**

- **Extract getToFinancialAccount
  ([33892](https://github.com/civicrm/civicrm-core/pull/33892))**

- **Deprecate passing less precise value to createDiscountTrxn
  ([33868](https://github.com/civicrm/civicrm-core/pull/33868))**

- **More removal of formally deprected event template vars for role
  ([33941](https://github.com/civicrm/civicrm-core/pull/33941))**

- **Make `participantTransfer`  function private, switch to array input
  ([33939](https://github.com/civicrm/civicrm-core/pull/33939))**

- **Replace some deprecated functions on contribution form
  ([33787](https://github.com/civicrm/civicrm-core/pull/33787))**

- **Civi::rebuild() - Reduce duplicative work
  ([33685](https://github.com/civicrm/civicrm-core/pull/33685))**

- **Delete unused Setting.tpl
  ([33729](https://github.com/civicrm/civicrm-core/pull/33729))**

- **Deprecate `CRM_Utils_Number::formatUnitSize` for `ini_parse_quantity`
  ([33755](https://github.com/civicrm/civicrm-core/pull/33755))**

- **RL - adds loading spinner utility class crm-loading-spinner
  ([33838](https://github.com/civicrm/civicrm-core/pull/33838))**

- **Cleanup - Update SearchKit js to use const/let instead of var keyword
  ([33840](https://github.com/civicrm/civicrm-core/pull/33840))**

- **Cleanup uses of null-coalescing operator
  ([33874](https://github.com/civicrm/civicrm-core/pull/33874))**

- **Cleanup - remove extra require_once statements
  ([33785](https://github.com/civicrm/civicrm-core/pull/33785))**

- **Cleanup getMaxFileSize function & add test
  ([33762](https://github.com/civicrm/civicrm-core/pull/33762))**

- **fix my name in release notes
  ([33815](https://github.com/civicrm/civicrm-core/pull/33815))**

- **Fix my name -- Nate Frank
  ([33805](https://github.com/civicrm/civicrm-core/pull/33805))**

- **Add myself to contributor-key.yml
  ([33829](https://github.com/civicrm/civicrm-core/pull/33829))**

- **Add myself to contributors
  ([33794](https://github.com/civicrm/civicrm-core/pull/33794))**

- **Update contributor-key.yml
  ([33761](https://github.com/civicrm/civicrm-core/pull/33761))**

- **CoreForm - Remove unused legacyDate param from addField
  ([34083](https://github.com/civicrm/civicrm-core/pull/34083))**

- **Remove unused variable
  ([33889](https://github.com/civicrm/civicrm-core/pull/33889))**

- **Hook - Remove unused deprecated hook code
  ([33880](https://github.com/civicrm/civicrm-core/pull/33880))**

- **Remove function noisily deprecated in 2019
  ([33854](https://github.com/civicrm/civicrm-core/pull/33854))**

- **Remove unreachable code
  ([33852](https://github.com/civicrm/civicrm-core/pull/33852))**

- **Remove deprecated note privacy handling and related code.
  ([33831](https://github.com/civicrm/civicrm-core/pull/33831))**

- **Remove deprecated snippet
  ([33865](https://github.com/civicrm/civicrm-core/pull/33865))**

- **[REF] reduce one layer of the IF clause
  ([33927](https://github.com/civicrm/civicrm-core/pull/33927))**

- **[REF] Riverlea - move common dark mode rules into a core _dark.css
  ([33818](https://github.com/civicrm/civicrm-core/pull/33818))**

- **[REF] move getAfformValues logic to afFieldset, remove lodash
  ([33905](https://github.com/civicrm/civicrm-core/pull/33905))**

- **[REF] tiny cleanup in Riverlea Styleloader
  ([33903](https://github.com/civicrm/civicrm-core/pull/33903))**

- **[REF] Move parameter setting back to calling function
  ([33851](https://github.com/civicrm/civicrm-core/pull/33851))**

- **Refactor: tokens for contact + case with createToken event
  ([33965](https://github.com/civicrm/civicrm-core/pull/33965))**

- **REF now that we are sure the contribution is 'complete' use it
  ([33862](https://github.com/civicrm/civicrm-core/pull/33862))**

- **[REF] ChartKit - use JS class for chart columns
  ([33550](https://github.com/civicrm/civicrm-core/pull/33550))**

- **[REF] use CivicrmPageState::addHtmlHeader directly
  ([112](https://github.com/civicrm/civicrm-drupal-8/pull/112))**

- **[NFC] first pass at 6.9 release Notes
  ([34100](https://github.com/civicrm/civicrm-core/pull/34100))**

- **(NFC) System::addHTMLHead() - Reframe as internal. Offer consistent
  alternatives. ([33824](https://github.com/civicrm/civicrm-core/pull/33824))**

- **[NFC] deprecate `CRM_Utils_System::addHTMLHead` in Drupal8+
  ([33727](https://github.com/civicrm/civicrm-core/pull/33727))**

- **Fix test readability
  ([33944](https://github.com/civicrm/civicrm-core/pull/33944))**

- **Replace assertApproxEquals with assertEqualsWithDelta in tests
  ([33930](https://github.com/civicrm/civicrm-core/pull/33930))**

- **Setting - Add test to demonstrate inconsistent default handling
  ([33763](https://github.com/civicrm/civicrm-core/pull/33763))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Iris; akwizgran; Artful Robot - Rich
Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor; Christian Wach; Christina;
Circle Interactive - Dave Jenkins, Rhiannon Davies; CiviCoop - Jaap Jansma;
CiviCRM - Coleman Watts, Tim Otten; civiservice.de - Gerhard Weber; CompuCo -
Muhammad Shahrukh; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove, Shane Bill;
CSES (Chelmsford Science and Engineering Society) - Adam Wood; Dave D; Duncan
Stanley White; Freeform Solutions - Herb van den Dool; Fuzion - Jitendra
Purohit, Luke Stewart; Giant Rabbit - Nathan Freestone; Greenpeace CEE; JMA
Consulting - Seamus Lee; Joinery - Allen Shaw; Lemniscus - Noah Miller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; OrtmannTeam GmbH - Andreas Lietz; Progressive Technology
Project - Jamie McClelland; Richard Baugh; Skvare - Sunil Pawar; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton;
Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; All In Appli.com - Guillaume Sorel; CiviCoop - Erik
Hommel; civiservice.de - Martin Correll, cs-bennwas; DevApp - David Cativo;
Greenpeace Central and Eastern Europe - Patrick Figel; JacquesVanH; Makoa - Usha
F. Matisson; Mosier Consulting - Justin Mosier; Nadaillac; Sarah Farrell-Graham;
Squiffle Consulting - Aidan Saunders;
