# CiviCRM 6.8.0

Released November 5, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add link to 'View My Contact' to CiviCRM user menu
  ([33674](https://github.com/civicrm/civicrm-core/pull/33674))**

  Adds a link to the CiviCRM user menu to quickly "View My Contact" to make it
  easy to access your own contact record.

- **Api4 - Add optimization to Extension.get
  ([33547](https://github.com/civicrm/civicrm-core/pull/33547))**

  Improves efficiency of the Extension.get Api.

- **SearchKit - Support date-only input widgets for editable fields
  ([33629](https://github.com/civicrm/civicrm-core/pull/33629))**

  On inline-edit and in batch-data entry displays adds support for the "Date
  Only" format type.

- **Enable ts() for inline editable component (crmSearchDisplayEditable)
  ([33570](https://github.com/civicrm/civicrm-core/pull/33570))**

  Improved accessibility for Searchkit Displays.

- **Allow setting labels for SK imports and batches
  ([dev/core#6104](https://lab.civicrm.org/dev/core/-/issues/6104):
  [33669](https://github.com/civicrm/civicrm-core/pull/33669),
  [33668](https://github.com/civicrm/civicrm-core/pull/33668) and
  [33665](https://github.com/civicrm/civicrm-core/pull/33665))**

  Makes it so users can set labels for SearchKit imports and batches.

- **SearchKit - Add formatting options for numbers
  ([33592](https://github.com/civicrm/civicrm-core/pull/33592))**

  Adds Max Decimal Places and Min Decimal Places to format floating point number
  fields.

- **Allow nested SQL functions in SqlFunctionCONCAT_WS/ SqlFunctionCONCAT
  ([dev/core#6117](https://lab.civicrm.org/dev/core/-/issues/6117):
  [33678](https://github.com/civicrm/civicrm-core/pull/33678))**

  Makes it so one can have nested SQL functions in APIv4.

- **SearchKit - Allow `<summary>` and `<details>` in html rewrites
  ([33589](https://github.com/civicrm/civicrm-core/pull/33589) and
  [33633](https://github.com/civicrm/civicrm-core/pull/33633))**

  Enables html rewritten columns to include a disclosure widget (`<summary>` and
  `<details>` markup).

- **Autocomplete - Add 'quick edit' feature
  ([33705](https://github.com/civicrm/civicrm-core/pull/33705))**

  Enables a popup afform to edit a record after selecting it on the searchkit
  batch entry form.

- **OAuth Client - Allow blank secret
  ([33538](https://github.com/civicrm/civicrm-core/pull/33538))**

  Marks the Oauth "Client Secret" field as optional.

- **Make site tokens exportable
  ([33615](https://github.com/civicrm/civicrm-core/pull/33615))**

  Makes the SiteTokens entity a managed entity. So it is exportable by Api4
  ("civix export SiteToken ID").

- **Add status check for invalid form_values
  ([33672](https://github.com/civicrm/civicrm-core/pull/33672))**

  Adds a status check for corrupt form_values.

- **civicrm_admin_ui: convert Browse mailing
  ([26532](https://github.com/civicrm/civicrm-core/pull/26532))**

  Converts the Browse Mailing screen for Admin UI users.

- **Smarty - Update icon markup for accessibility
  ([33595](https://github.com/civicrm/civicrm-core/pull/33595))**

  Improves accessibility for icon markup.

- **I18n - Add escape=html mode
  ([33634](https://github.com/civicrm/civicrm-core/pull/33634))**

  Adds new escaping mode for translated strings in Smarty.

- **Focus on date field or adjacent time field after selecting date in
  datepicker ([33654](https://github.com/civicrm/civicrm-core/pull/33654))**

  Improves user experience for date fields.

- **Setting form fixes
  ([33587](https://github.com/civicrm/civicrm-core/pull/33587) and
  [33596](https://github.com/civicrm/civicrm-core/pull/33596))**

  Cleans up settings form display.

- **Profile Admin - Move all help icons to the same position on the form
  ([33529](https://github.com/civicrm/civicrm-core/pull/33529))**

  Improves the consistency of the display of help icons.

- **Rethinking 20 minutes QF session timeouts
  ([dev/core#4516](https://lab.civicrm.org/dev/core/-/issues/4516):
  [33639](https://github.com/civicrm/civicrm-core/pull/33639))**

  Increases default quickform session timeout to 120 minutes.

- **Make Font Awesome icons more accessible
  ([dev/core#5041](https://lab.civicrm.org/dev/core/-/issues/5041):
  [33588](https://github.com/civicrm/civicrm-core/pull/33588))**

  Adds role img and ariahidden true to all Font Awesome icons to make them more
  accessible.

### CiviEvent

- **Event Dashboard: always display top buttons, move iCal feed under the list
  of events ([33673](https://github.com/civicrm/civicrm-core/pull/33673))**

  User interface improvements for the CiviEvent dashboard.

### CiviMail

- **CiviMail - Send back 400 invalid parameters response if url_id is not
  validated rather than a 500 error
  ([33541](https://github.com/civicrm/civicrm-core/pull/33541))**

  Better error when url_id is not validated.

### Standalone Integration

- **Standalone: a person should be able to see their account info on a "My
  Account" page
  ([dev/core#5670](https://lab.civicrm.org/dev/core/-/issues/5670):
  [32221](https://github.com/civicrm/civicrm-core/pull/32221))**

  Adds a "My Account" page to standalone sites.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Bad "Learn more" link in System Status "Duplicate records in UFMatch" check
  ([dev/core#5650](https://lab.civicrm.org/dev/core/-/issues/5650):
  [33677](https://github.com/civicrm/civicrm-core/pull/33677))**

- **Searchkit filter on IS NOT NULL with no gives wrong results
  ([dev/core#6056](https://lab.civicrm.org/dev/core/-/issues/6056):
  [33505](https://github.com/civicrm/civicrm-core/pull/33505))**

- **Smarty and JS variables: json_encode and escaping
  ([dev/core#6080](https://lab.civicrm.org/dev/core/-/issues/6080):
  [33553](https://github.com/civicrm/civicrm-core/pull/33553))**

- **Error with thousands separator character
  ([dev/core#6111](https://lab.civicrm.org/dev/core/-/issues/6111):
  [33691](https://github.com/civicrm/civicrm-core/pull/33691))**

- **Multiple address block + existing address field
  ([dev/core#6112](https://lab.civicrm.org/dev/core/-/issues/6112):
  [33842](https://github.com/civicrm/civicrm-core/pull/33842))**

  Fixes loading existing entities with multiple joins.

- **Contact Relationships tab shows all current and non-current relationships
  under Inactive
  ([dev/core#6128](https://lab.civicrm.org/dev/core/-/issues/6128):
  [33751](https://github.com/civicrm/civicrm-core/pull/33751))**

- **SearchKitBatch pager not working correctly
  ([dev/core#6131](https://lab.civicrm.org/dev/core/-/issues/6131):
  [33706](https://github.com/civicrm/civicrm-core/pull/33706))**

- **6.7 web upgrade crashes - civicrm_translation_source table not found
  ([dev/core#6135](https://lab.civicrm.org/dev/core/-/issues/6135):
  [33740](https://github.com/civicrm/civicrm-core/pull/33740))**

- **Upgrade UI: Double Vision
  ([dev/core#6142](https://lab.civicrm.org/dev/core/-/issues/6142):
  [33770](https://github.com/civicrm/civicrm-core/pull/33770))**

- **Crash when adding With Tags filter on SearchUI Find Contacts screen
  ([dev/core#6157](https://lab.civicrm.org/dev/core/-/issues/6157):
  [33808](https://github.com/civicrm/civicrm-core/pull/33808))**

- **Api4 Explorer - Fix action loading when entity changes in URL
  ([33523](https://github.com/civicrm/civicrm-core/pull/33523))**

- **Api4 - Fix php error when joining on tables with no primary key
  ([33813](https://github.com/civicrm/civicrm-core/pull/33813))**

- **Add form name to 'Silently ignoring exception' error message when submitting
  FormBuilder form
  ([33521](https://github.com/civicrm/civicrm-core/pull/33521))**

- **FormBuilder: fix 'verify submission before processing'
  ([33931](https://github.com/civicrm/civicrm-core/pull/33931))**

- **Allow cache rebuild as anonymous user for afformAdmin metadata
  ([33693](https://github.com/civicrm/civicrm-core/pull/33693))**

- **Afform - Fix editing button text & icon
  ([33766](https://github.com/civicrm/civicrm-core/pull/33766))**

- **For Individual searchkit tasks make sure we remove 'Contact' actions added
  by hooks ([33744](https://github.com/civicrm/civicrm-core/pull/33744))**

- **SearchKit pages throws : Uncaught PHP Exception "Authorization failed:
  CiviCRM APIv4 (Entity::get)
  ([33663](https://github.com/civicrm/civicrm-core/pull/33663))**

- **SearchKitBatch: Change "View Import Batches" links to only show batch
  imports  ([33618](https://github.com/civicrm/civicrm-core/pull/33618))**

- **Don't validate page size in SearchKit
  ([33708](https://github.com/civicrm/civicrm-core/pull/33708))**

- **Replace fa-pulse with fa-spin (animation tweak)
  ([33662](https://github.com/civicrm/civicrm-core/pull/33662))**

- **riverlea - use contrasting variables for hackney brook button palette
  ([33591](https://github.com/civicrm/civicrm-core/pull/33591))**

- **RiverLea: moves disabled icon on extension table
  ([33552](https://github.com/civicrm/civicrm-core/pull/33552))**

- **RiverLea fixes broken ol list style in notifications
  ([33551](https://github.com/civicrm/civicrm-core/pull/33551))**

- **RiverLea - 6.8 meta, and moves changelog to gitlab
  ([33697](https://github.com/civicrm/civicrm-core/pull/33697))**

- **RiverLea: maintain aspect ratio in some image blocks, ref
  /extensions/riverlea/133
  ([33601](https://github.com/civicrm/civicrm-core/pull/33601))**

- **RiverLea Walbrook: dont rename "Inter" to "Civitype"
  ([33610](https://github.com/civicrm/civicrm-core/pull/33610))**

- **RiverLea, remove custom css for Backbone profile editor, now it's not called
  by core ([33625](https://github.com/civicrm/civicrm-core/pull/33625))**

- **RiverLea: Reduces SK button/menu cells to width of only button/menus
  ([33603](https://github.com/civicrm/civicrm-core/pull/33603))**

- **Riverlea - cleanup around getAvailableStreamMeta
  ([33604](https://github.com/civicrm/civicrm-core/pull/33604))**

- **RiverLea: simplifies Walbrook bold/italic font-handling, allowing for fewer
  variables and lots of cleanup
  ([33607](https://github.com/civicrm/civicrm-core/pull/33607))**

- **Smarty - Fix a few oddball, non-portable strings
  ([33619](https://github.com/civicrm/civicrm-core/pull/33619))**

- **Settings.php - Remove redundant Smarty version
  ([33583](https://github.com/civicrm/civicrm-core/pull/33583))**

- **Smarty - Remove "bonkers" way of fetching help titles
  ([33534](https://github.com/civicrm/civicrm-core/pull/33534))**

- **Smarty - Fix notice on help text (again)
  ([33528](https://github.com/civicrm/civicrm-core/pull/33528))**

- **AdminUI - Fix links to profile fields
  ([33711](https://github.com/civicrm/civicrm-core/pull/33711))**

- **Fix logo not spinning in quicksearch on Thames
  ([33624](https://github.com/civicrm/civicrm-core/pull/33624))**

- **Prevent error when exporting with household relationship types disabled
  ([33698](https://github.com/civicrm/civicrm-core/pull/33698))**

- **Prevent deletion of users when merging
  ([33594](https://github.com/civicrm/civicrm-core/pull/33594))**

- **don't add % wildcard to quick search external id search
  ([33597](https://github.com/civicrm/civicrm-core/pull/33597))**

- **JSON - Use unescaped unicode & unescaped slashes when appropriate
  ([33613](https://github.com/civicrm/civicrm-core/pull/33613))**

- **LegacySearch - Check enabled before using block
  ([33546](https://github.com/civicrm/civicrm-core/pull/33546))**

- **Fix Continue buttons on My Imports and All Imports
  ([33599](https://github.com/civicrm/civicrm-core/pull/33599))**

- **fix 'update' on importing memberships/participants
  ([33832](https://github.com/civicrm/civicrm-core/pull/33832))**

- **Fix bug loading Entity in Generic import parser
  ([33876](https://github.com/civicrm/civicrm-core/pull/33876))**

- **core/ext - Remove unneeded phpcs comment
  ([33522](https://github.com/civicrm/civicrm-core/pull/33522))**

- **Missing user ID on contact screen
  ([33520](https://github.com/civicrm/civicrm-core/pull/33520))**

- **Api4 - Improve _itemsToGet prefilter
  ([33559](https://github.com/civicrm/civicrm-core/pull/33559))**

  Improves Api4 internal prefilter function to prevent potential errors.

- **Smaller font for inactive dashlet titles, so they don't get cutoff
  ([33571](https://github.com/civicrm/civicrm-core/pull/33571))**

- **MessageTemplates - Update title, help
  ([33564](https://github.com/civicrm/civicrm-core/pull/33564))**

  Removes broken help link.

### CiviCase

- **split out interface from CaseFormTrait and implement on other case forms
  ([33410](https://github.com/civicrm/civicrm-core/pull/33410))**

### CiviContribute

- **The profile frontend_title is printed twice in contribution page
  confirmation ([dev/core#5800](https://lab.civicrm.org/dev/core/-/issues/5800):
  [33681](https://github.com/civicrm/civicrm-core/pull/33681) and
  [33527](https://github.com/civicrm/civicrm-core/pull/33527))**

- **Fix 'ACL check failed' when saving Order lineitems for non-admin users
  ([33557](https://github.com/civicrm/civicrm-core/pull/33557))**

- **clearer label for Contribution is_test field
  ([33467](https://github.com/civicrm/civicrm-core/pull/33467))**

- **Set Contribution status to 'Partially Paid' when a partial refund is issued
  ([33696](https://github.com/civicrm/civicrm-core/pull/33696))**

- **Having a custom name for a Contact Type breaks Contribution Import process
  ([dev/core#6160](https://lab.civicrm.org/dev/core/-/issues/6160):
  [33843](https://github.com/civicrm/civicrm-core/pull/33843))**

### CiviEvent

- **Users with access to view/edit participants get error on View/Edit
  Participant, if not granted "access CiviContribute"
  ([dev/core#6088](https://lab.civicrm.org/dev/core/-/issues/6088):
  [33577](https://github.com/civicrm/civicrm-core/pull/33577))**

- **Creating an event exposes the user's emails
  ([dev/core#6127](https://lab.civicrm.org/dev/core/-/issues/6127):
  [33699](https://github.com/civicrm/civicrm-core/pull/33699))**

- **Allow backend price options to be un-selected or selected even when full
  ([33254](https://github.com/civicrm/civicrm-core/pull/33254))**

- **fix missing Fields button on event reg 'additional' profiles
  ([33716](https://github.com/civicrm/civicrm-core/pull/33716))**

- **Participant import: mapping UI broken if Households are disabled
  ([dev/core#6181](https://lab.civicrm.org/dev/core/-/issues/6181):
  [33967](https://github.com/civicrm/civicrm-core/pull/33967))**
  
### CiviGrant

- **fix grant field labels
  ([33690](https://github.com/civicrm/civicrm-core/pull/33690))**

### CiviMail

- **Fatal error when attempting to access civicrm/mailing/optout, due to
  case-sensitive reference to CRM_Mailing_Form_Optout
  ([dev/core#6173](https://lab.civicrm.org/dev/core/-/issues/6173):
  [33919](https://github.com/civicrm/civicrm-core/pull/33919))**

### CiviMember

- **Don't create duplicate membership when in invoice mode with a pending
  membership ([33002](https://github.com/civicrm/civicrm-core/pull/33002))**

### Drupal Integration

- **Remove Unnecessary Loading Of Themes For Mailing Urls
  ([692](https://github.com/civicrm/civicrm-drupal/pull/692))**

### Standalone Integration

- **Standalone civi-setup: avoid infinite loop if incorrect setup
  ([33566](https://github.com/civicrm/civicrm-core/pull/33566))**

## <a name="misc"></a>Miscellany

- **Fix organisation name to match Partner Profile in contributor-key.yml
  ([33598](https://github.com/civicrm/civicrm-core/pull/33598))**

- **Pledge form cleanup
  ([33543](https://github.com/civicrm/civicrm-core/pull/33543))**

- **JWT - Simplify implementation. Drop compat w/old library.
  ([33537](https://github.com/civicrm/civicrm-core/pull/33537))**

- **Cleanup `<style>` tags by removing obsolete `type` attributes.
  ([33554](https://github.com/civicrm/civicrm-core/pull/33554))**

- **CRM_Utils_Url - Add helper to determine origin of an absolute URL
  ([33700](https://github.com/civicrm/civicrm-core/pull/33700))**

- **Chartkit small cleanup
  ([33542](https://github.com/civicrm/civicrm-core/pull/33542))**

- **Remove reference to undefined property _fieldset and remove deprecated
  nullObject reference and define maxRecordLimit class variable
  ([33642](https://github.com/civicrm/civicrm-core/pull/33642))**

- **(REF) Addresses - Rename `$microformat` to `$useMarkup`
  ([33658](https://github.com/civicrm/civicrm-core/pull/33658))**

- **[REF] AuthX - flatten already logged in cases
  ([31062](https://github.com/civicrm/civicrm-core/pull/31062))**

- **[REF] simplify ical by removing compatibility with PHP 7.4
  ([33562](https://github.com/civicrm/civicrm-core/pull/33562))**

- **[REF] CRM_Core - Move shared smarty functionality into a trait  
  ([33620](https://github.com/civicrm/civicrm-core/pull/33620))**

- **SmartyConsistencyTest - Add E2E test to compare common notations across
  Smarty versions
  ([33565](https://github.com/civicrm/civicrm-core/pull/33565))**

- **(NFC) Test - Output more debug info for Scheduled Communications failure
  ([33660](https://github.com/civicrm/civicrm-core/pull/33660))**

- **[NFC] remove empty function riverlea_civicrm_alterBundle
  ([33602](https://github.com/civicrm/civicrm-core/pull/33602))**

- **[NFC] Comment about why line is needed in Case/Form/Case
  ([33549](https://github.com/civicrm/civicrm-core/pull/33549))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Iris; Artful Robot - Rich Lott;
Benjamin W; BrightMinded Ltd - Bradley Taylor; Christina; CiviCRM - Coleman
Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; CSES
(Chelmsford Science and Engineering Society) - Adam Wood; Dave D; Duncan Stanley
White; Freeform Solutions - Herb van den Dool; JMA Consulting - Monish Deb,
Seamus Lee; Joinery - Allen Shaw; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich; Parlamentwatch e.V. -
Philipp Michael; Progressive Technology Project - Jamie McClelland; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Chris Garaffa; All In Appli.com - Guillaume Sorel; CiviCoop -
Jaap Jansma; civiservice.de - Martin Correll; CompuCo - Muhammad Shahrukh; Coop
SymbioTIC - Shane Bill; Fuzion - Luke Stewart; Richard van Oosterhout; Skvare -
Sachin Doijad; Squiffle Consulting - Aidan Saunders; Third Sector Design -
Kurund Jalmi
