# CiviCRM 6.7.0

Released October 8, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**


## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add apiv4 support to Dedupe.getduplicates
  ([33434](https://github.com/civicrm/civicrm-core/pull/33434))**

  Adds apiv4 support to Dedupe.getduplicates

- **SearchKit - Add 'nowrap' styling option
  ([33487](https://github.com/civicrm/civicrm-core/pull/33487))**

  Adds a new option "No Wrapping" can be used to keep buttons and other stuff
  inline.

- **dev/core#5879 Extending Afform UI Permissions
  ([dev/core#5879](https://lab.civicrm.org/dev/core/-/issues/5879):
  [33358](https://github.com/civicrm/civicrm-core/pull/33358) and
  [33445](https://github.com/civicrm/civicrm-core/pull/33445))**

  Adds the ability to limit afform and searchkits to only those that the user
  has created to prevent them from accessing others.

- **FormBuilder Admin: set stability to Stable
  ([33384](https://github.com/civicrm/civicrm-core/pull/33384))**

  Changes the develState of afform_admin to stable.

- **FormBuilder Internationalization (i18n)
  ([32859](https://github.com/civicrm/civicrm-core/pull/32859))**

  Internationalization support for FormBuilder.

- **FormBuilder - Enable combining search filters in UI
  ([33432](https://github.com/civicrm/civicrm-core/pull/33432))**

  Improves FormBuilder functionality to enable combining search filters. Makes
  it easier to create an OR condition to search multiple fields.

- **Afform - Add link to view results
  ([33462](https://github.com/civicrm/civicrm-core/pull/33462))**

  Adds an item to the little gear menu floating above Afforms to view the
  submission results.

- **Riverlea is enabled for all new installs, remove Standalone-specific enabler
 ([33382](https://github.com/civicrm/civicrm-core/pull/33382))**

  Enable Riverlea for all new installs.

- **search_kit_reports - separate out permission check from CiviReport
  ([33374](https://github.com/civicrm/civicrm-core/pull/33374))**

  Allows using Search Kit Reports when not using CiviReport.

- **Search kit reports - little visual cleanup
  ([33375](https://github.com/civicrm/civicrm-core/pull/33375))**

  Fixes the reversed button order (which came pre #33336) and adds a column
  header to the buttons column for better accessibility.

- **Update Smarty SystemCheck to reflect new default, deadline
  ([33581](https://github.com/civicrm/civicrm-core/pull/33581))**

  Adds Smarty 5 implementation deadline to the system check.

- **Add Auto-renew Date trigger Action to Schedule Reminders
  ([32813](https://github.com/civicrm/civicrm-core/pull/32813))**

  Adds a new Scheduled Reminder date trigger action "Membership Auto-renew
  date".

- **CiviReport - Show collapse/expand icon on collapsible tabs
  ([33478](https://github.com/civicrm/civicrm-core/pull/33478))**

  In CiviReport you can click on tabs to collapse them. This adds a little icon
  to make that more obvious.

- **add ability to output iframe.php file to stdout
  ([31326](https://github.com/civicrm/civicrm-core/pull/31326))**

  Provides an API action for the iframe extension that outputs the iframe.php
  code to standard out.

- **Add php & smarty compatibility info to core extensions
  ([33378](https://github.com/civicrm/civicrm-core/pull/33378))**

  Adds php & smarty compatibility info to core extensions.

### CiviMail

- **One click unsubscribe - option to do opt out?
  ([dev/core#5482](https://lab.civicrm.org/dev/core/-/issues/5482):
  [31259](https://github.com/civicrm/civicrm-core/pull/31259))**

  Adds an Unsubscribe Mode setting and field to allow for site admins to
  configure if One Click should be unsubscribe or opt out and modify Mailing
  interface appropriately

### Standalone Integration

- **Use angular component for Standalone login
  ([33392](https://github.com/civicrm/civicrm-core/pull/33392))**

  Replaces the Standalone login page with an angular component (like password
  reset page / change password).

- **Standalone - Improve search filter on permissions screen
  ([33480](https://github.com/civicrm/civicrm-core/pull/33480))**

  Makes the search box more useful on "User Permissions" screen.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Province/State not displaying on Contact Summary (v6.4+)
  ([dev/core#6076](https://lab.civicrm.org/dev/core/-/issues/6076):
  [33656](https://github.com/civicrm/civicrm-core/pull/33656))**

- **User ID missing on main Contact screen
  ([dev/core#6078](https://lab.civicrm.org/dev/core/-/issues/6078):
  [33648](https://github.com/civicrm/civicrm-core/pull/33648))**

- **Fix cannot delete group due to missing saved search form values
  ([33638](https://github.com/civicrm/civicrm-core/pull/33638))**

- **BatchEntry - Fix extension installation error
  ([33631](https://github.com/civicrm/civicrm-core/pull/33631))**

- **QuickSearch: State Province and Country triggers DB syntax error
  ([dev/core#6081](https://lab.civicrm.org/dev/core/-/issues/6081):
  [33649](https://github.com/civicrm/civicrm-core/pull/33649))**

- **FormBuilder / Afform: Deleted options disappear when customizing options in
  a date field ([dev/core#4859](https://lab.civicrm.org/dev/core/-/issues/4859):
  [33411](https://github.com/civicrm/civicrm-core/pull/33411))**

- **Denmark regions possibly not updated correctly in 6.2
  ([dev/core#5925](https://lab.civicrm.org/dev/core/-/issues/5925):
  [33525](https://github.com/civicrm/civicrm-core/pull/33525))**

- **SearchKit - Allow filters to target specific joins
  ([dev/core#6021](https://lab.civicrm.org/dev/core/-/issues/6021):
  [33424](https://github.com/civicrm/civicrm-core/pull/33424))**

- **Inconsistency in timezone handling between APIv4 REST and logged in user
  using APIv4 Explorer
  ([dev/core#6045](https://lab.civicrm.org/dev/core/-/issues/6045):
  [33357](https://github.com/civicrm/civicrm-core/pull/33357))**

- **Riverlea - fix stream override load order  
  ([33635](https://github.com/civicrm/civicrm-core/pull/33635))**

- **Riverlea: Contact details pop-up from search results can open outside
  viewport ([dev/core#6072](https://lab.civicrm.org/dev/core/-/issues/6072):
  [33496](https://github.com/civicrm/civicrm-core/pull/33496))**

- **Add Note Form Does Not Work
  ([dev/core#6079](https://lab.civicrm.org/dev/core/-/issues/6079):
  [33533](https://github.com/civicrm/civicrm-core/pull/33533))**

- **SearchKit: Searching for != on a Yes/No Custom Field does not return the
  expected results
  ([dev/core#6083](https://lab.civicrm.org/dev/core/-/issues/6083):
  [33560](https://github.com/civicrm/civicrm-core/pull/33560))**

- **APIv4 - Ensure custom field default values are respected on new records
  ([33377](https://github.com/civicrm/civicrm-core/pull/33377))**

- **SearchKit - Hide search functions from entities that don't support it.
  ([33477](https://github.com/civicrm/civicrm-core/pull/33477))**

- **SearchKit - Fix inline-edit when using groupBy
  ([33454](https://github.com/civicrm/civicrm-core/pull/33454))**

- **SearchKit - Only export relevant Afform fields
  ([33359](https://github.com/civicrm/civicrm-core/pull/33359))**

- **SearchKit - Prevent errors after batch tasks
  ([33593](https://github.com/civicrm/civicrm-core/pull/33593))**

- **SearchKit - Fix hierarchical table style in Riverlea theme
  ([33484](https://github.com/civicrm/civicrm-core/pull/33484))**

- **SearchKit - Use CONTAINS filter on main search listing
  ([33501](https://github.com/civicrm/civicrm-core/pull/33501))**

- **FormBuilder - Don't wrap headers of afform listing
  ([33489](https://github.com/civicrm/civicrm-core/pull/33489))**

- **Afform - Ensure drafts don't count toward submit limit
  ([33641](https://github.com/civicrm/civicrm-core/pull/33641))**

- **Afform: Fix admin links to properly check permissions
  ([33461](https://github.com/civicrm/civicrm-core/pull/33461))**

- **Afform - Fix permission fallback check
  ([33442](https://github.com/civicrm/civicrm-core/pull/33442))**

- **Afform: Fix multivalued hidden fields
  ([33458](https://github.com/civicrm/civicrm-core/pull/33458))**

- **Afform: Fix "Select Current User" default
  ([33460](https://github.com/civicrm/civicrm-core/pull/33460))**

- **AdminUI - Fix links disappearing from civicrm/admin screen
  ([33584](https://github.com/civicrm/civicrm-core/pull/33584))**

- **RiverLea: SearchKit display - centre aligns table cells with multiple
  buttons ([33464](https://github.com/civicrm/civicrm-core/pull/33464))**

- **RiverLea: datepicker inactive dates, fix alignment & dark-mode contrast
  ([33456](https://github.com/civicrm/civicrm-core/pull/33456))**

- **RiverLea: Fixes contrast bug in datepicker darkmode, tidies datepicker css
  ([33455](https://github.com/civicrm/civicrm-core/pull/33455))**

- **RiverLea: fixes layout bug on FormBuilder inline layout inside Details
  ([33324](https://github.com/civicrm/civicrm-core/pull/33324))**

- **RiverLea Fixes: adds wordwrap on contact layout tabs to avoid UI break in
  Walbrook/Thames/Hackney
  ([33530](https://github.com/civicrm/civicrm-core/pull/33530))**

- **Riverlea - throw away throwaway script
  ([33485](https://github.com/civicrm/civicrm-core/pull/33485))**

- **RiverLea: Restores lists to SearchKit, adjusts paragraph margin in Claro
  ([33482](https://github.com/civicrm/civicrm-core/pull/33482))**

- **Riverlea - restore explicit order when bundling core assets
  ([33609](https://github.com/civicrm/civicrm-core/pull/33609))**

- **Riverlea - use bundle rather than @import for loading individual files
  ([33395](https://github.com/civicrm/civicrm-core/pull/33395))**

- **Prevent sending email receipt when importing from batch data entry
  ([33617](https://github.com/civicrm/civicrm-core/pull/33617))**

- **Import - Fix 'Help file not found' error
  ([33545](https://github.com/civicrm/civicrm-core/pull/33545))**

- **message_admin - Remove undeclared dependency on civi_mail
  ([33519](https://github.com/civicrm/civicrm-core/pull/33519))**

- **User ID missing on main Contact screen
  ([dev/core#6078](https://lab.civicrm.org/dev/core/-/issues/6078):
  [33524](https://github.com/civicrm/civicrm-core/pull/33524))**

- **OAuth Client - Multiple fixes for debugging tools
  ([33425](https://github.com/civicrm/civicrm-core/pull/33425))**

- **Ensure that Entity table is always included in the params passed to the
  CustomValueTable::create
  ([33499](https://github.com/civicrm/civicrm-core/pull/33499))**

- **patches - Generate test failure if the patch-list is not suitable for
  distribution ([33361](https://github.com/civicrm/civicrm-core/pull/33361))**

- **Deal with possibility that API result from cron is a throwable Exception
  e.g. TypeError and should not be accessed like an array
  ([33498](https://github.com/civicrm/civicrm-core/pull/33498))**

- **ensure adding wildcard to "quick search -> advanced search workflow" works
  when automatic wildcard setting is enabled
  ([33488](https://github.com/civicrm/civicrm-core/pull/33488))**

- **EntityProvider - Add new 'civi.entity.fields' event
  ([33447](https://github.com/civicrm/civicrm-core/pull/33447))**

  Adds a new EFv2 replacement for the legacy DAO fields_callback functions.
  Marks the latter as deprecated.

- **EntityProvider - Localized strings should be cached separately
  ([33472](https://github.com/civicrm/civicrm-core/pull/33472))**

- **CustomField - Clear cache when updating weight
  ([33469](https://github.com/civicrm/civicrm-core/pull/33469))**

- **Add timeout option to WeasyPrint PHP wrapper to prevent process timeouts on
  large batch PDF generation
  ([dev/core#5968](https://lab.civicrm.org/dev/core/-/issues/5968):
  [33373](https://github.com/civicrm/civicrm-core/pull/33373))**

- **Remove empty translation strings
  ([33426](https://github.com/civicrm/civicrm-core/pull/33426))**

- **Api4 Explorer - Fix debug param showing in generated code
  ([33388](https://github.com/civicrm/civicrm-core/pull/33388))**

- **Ang - Remove unused file
  ([33376](https://github.com/civicrm/civicrm-core/pull/33376))**

- **Fix modified_date not updating on delete-to-trash
  ([33439](https://github.com/civicrm/civicrm-core/pull/33439))**

- **Fix broken image thumbnails for uploaded files
  ([32914](https://github.com/civicrm/civicrm-core/pull/32914))**

- **fix: display double-opt-in group setting
  ([33585](https://github.com/civicrm/civicrm-core/pull/33585))**

- **Accordions - Fix html tag mismatch
  ([33574](https://github.com/civicrm/civicrm-core/pull/33574))**

- **avoid duplication in Api4 LegacyEntityScanner
  ([33371](https://github.com/civicrm/civicrm-core/pull/33371))**

### CiviCampaign

- **ensure we show unique contacts on survey interview page
  ([33459](https://github.com/civicrm/civicrm-core/pull/33459))**

  When interviewing respondents via CiviCampaign, each respondent shows up
  twice when they should only show up once.

### CiviCase

- **Every site with civicase is showing system status warnings about entity
  scanning ([dev/core#6062](https://lab.civicrm.org/dev/core/-/issues/6062):
  [33436](https://github.com/civicrm/civicrm-core/pull/33436))**

### CiviContribute

- **Alpha order financial types
  ([33399](https://github.com/civicrm/civicrm-core/pull/33399))**

- **Show Date on a new line on Thank You contribution page.
  ([33433](https://github.com/civicrm/civicrm-core/pull/33433))**

- **Fix Smarty2/3/4 Notices on missing value and type on some statistics fields
  in Repeat Contributions Report and fix showing the correct count in the Total
  amount 2 statistic
  ([33430](https://github.com/civicrm/civicrm-core/pull/33430))**

- **When using Order API make sure we always add an invoice ID to the
  contribution ([33512](https://github.com/civicrm/civicrm-core/pull/33512))**

- **Payment Processors - Fix Smarty warning. Allow deactivation of
  `accept_credit_cards`.
  ([33465](https://github.com/civicrm/civicrm-core/pull/33465))**

- **Payment Processor - Admin screen quietly copies live credentials to testing
  ([33450](https://github.com/civicrm/civicrm-core/pull/33450))**

- **Financial Type not updated in QuickConfig Price Field values after
  contribution page is copied
  ([dev/financial#234](https://lab.civicrm.org/dev/financial/-/issues/234):
  [33271](https://github.com/civicrm/civicrm-core/pull/33271))**

### CiviEvent

- **emailMode on in Web (SocialNetwork.tpl)
  ([dev/core#6064](https://lab.civicrm.org/dev/core/-/issues/6064):
  [33429](https://github.com/civicrm/civicrm-core/pull/33429))**

- **Event Cart checkout: participant registration fails - contact name and email
  not pre-filled and won't save
  ([dev/core#6069](https://lab.civicrm.org/dev/core/-/issues/6069):
  [33476](https://github.com/civicrm/civicrm-core/pull/33476))**

- **Ensure that if an Event is configured to show a map and that the map
  provider exists that if the address is ungeocoded that no notice error is
  generated from smarty
  ([33402](https://github.com/civicrm/civicrm-core/pull/33402))**

- **Don't show "My billing address is the same as above" for event payments on
  confirm ([33400](https://github.com/civicrm/civicrm-core/pull/33400))**

- **Fix Smarty Notice errors on Event Location tab
  ([33403](https://github.com/civicrm/civicrm-core/pull/33403))**

### CiviGrant

- **Grant Statistics report columns, tabs and table list are not visible
  ([dev/core#6096](https://lab.civicrm.org/dev/core/-/issues/6096):
  [33621](https://github.com/civicrm/civicrm-core/pull/33621))**

### CiviMail

- **Ensure that the civicrm_mailing.status field is saved in the database to
  Scheduled when mailing is scheduled
  ([33409](https://github.com/civicrm/civicrm-core/pull/33409))**

- **On new mailing screen the widget for include/exclude double-escapes
  characters ([dev/core#4561](https://lab.civicrm.org/dev/core/-/issues/4561):
  [33513](https://github.com/civicrm/civicrm-core/pull/33513))**

- **Mailing - Fix faulty metadata syntax
  ([33561](https://github.com/civicrm/civicrm-core/pull/33561))**

### Joomla Integration

- **Prevent CiviCRM upgrade routine interfering with non-CiviCRM permissions on
  Joomla ([33457](https://github.com/civicrm/civicrm-core/pull/33457))**

- **RiverLea: Joomla bugs: bootstrap secondary bg + sticky header offset
  ([33463](https://github.com/civicrm/civicrm-core/pull/33463))**

- **Fix userId 0 vs NULL confusion in CRM_Core_Permission_Joomla::check()
  ([33578](https://github.com/civicrm/civicrm-core/pull/33578))**

### Standalone Integration

- **Standalone: Deduping contacts with a user account can delete the user
  account ([dev/core#6068](https://lab.civicrm.org/dev/core/-/issues/6068):
  [33479](https://github.com/civicrm/civicrm-core/pull/33479))**

- **Standalone web installer crashes on 6.6 - "Civi\Standalone\SessionHandler"
  not found ([dev/core#6093](https://lab.civicrm.org/dev/core/-/issues/6093):
  [33608](https://github.com/civicrm/civicrm-core/pull/33608))**

- **StandaloneUsers - Cleanup settings file
  ([33453](https://github.com/civicrm/civicrm-core/pull/33453))**

### WordPress Integration

- **RiverLea: Resets radio/checkbox border-color to CMS default in WordPress
  ([33444](https://github.com/civicrm/civicrm-core/pull/33444))**

- **Afform: unable to verify submission when embedded on page/post using
  shortcode (WordPress)
  ([dev/core#6074](https://lab.civicrm.org/dev/core/-/issues/6074):
  [33506](https://github.com/civicrm/civicrm-core/pull/33506))**

## <a name="misc"></a>Miscellany

- **Strengthen api3 contact merge test; make assumptions more explicit
  ([33385](https://github.com/civicrm/civicrm-core/pull/33385))**

- **Unshare import getDedupeRule function
  ([33380](https://github.com/civicrm/civicrm-core/pull/33380))**

- **Bump tmp from 0.2.1 to 0.2.4
  ([33368](https://github.com/civicrm/civicrm-core/pull/33368))**

- **[REF] - Switch the switch to match
  ([33451](https://github.com/civicrm/civicrm-core/pull/33451))**

- **[REF] crmUi - Cleanup js code
  ([33295](https://github.com/civicrm/civicrm-core/pull/33295))**

- **[REF] Change visibilty of CustomValueTable::create to be private as no other
  classes directly call this function
  ([33508](https://github.com/civicrm/civicrm-core/pull/33508))**

- **[NFC] first pass at 6.7 release notes
  ([33647](https://github.com/civicrm/civicrm-core/pull/33647))**

- **[NFC] Follow up to #33400 ensure that showPaymentOnConfirm is always
  assigned to BillingBlock tpl
  ([33401](https://github.com/civicrm/civicrm-core/pull/33401))**

- **[NFC] Delete hated boilerplate comment
  ([33468](https://github.com/civicrm/civicrm-core/pull/33468))**

- **[NFC] Add unit test to demonstrate that Mailing Status is not correctly
  updated in the database when mailing is being scheduled
  ([33408](https://github.com/civicrm/civicrm-core/pull/33408))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; All In Appli.com - Guillaume Sorel; Artful
Robot - Rich Lott; Benjamin W; Circle Interactive - Dave Jenkins, Pradeep Nayak;
CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Samuel
Vanhove, Shane Bill; CSES (Chelmsford Science and Engineering Society) - Adam
Wood; Dave D; JMA Consulting - Monish Deb, Seamus Lee; Lemniscus - Noah Miller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; Parlamentwatch e.V. - Philipp Michael; Progressive Technology
Project - Jamie McClelland; Richard Baugh; Third Sector Design - Kurund Jalmi,
William Mortada; Wikimedia Foundation - Eileen McNaughton; Wildsight - Lars
Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Australian Greens - John Twyman; Coop SymbioTIC - mmyriam; Freeform Solutions -
Herb van den Dool; Guydn; JMA Consulting - Joe Murray; Joinery - Allen Shaw;
New York State Senate - Nate Frank; OPEN - dewy; Richard Baugh; Sjoerd
Langkemper; Systopia - Dominic Tubach; Tadpole Collective - Kevin Cristiano;
