# CiviCRM 6.5.0

Released August 6, 2025;

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| **Fix security vulnerabilities?**                               | **yes** |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="security"></a>Security advisories

* **[CIVI-SA-2025-01](https://civicrm.org/advisory/civi-sa-2025-01-insufficient-permission-denial): Insufficient Permission Denial**
* **[CIVI-SA-2025-02](https://civicrm.org/advisory/civi-sa-2025-02-contact-images-csrf): Contact Images (CSRF)**
* **[CIVI-SA-2025-03](https://civicrm.org/advisory/civi-sa-2025-03-dialog-title-xss): Dialog Title (XSS)**
* **[CIVI-SA-2025-04](https://civicrm.org/advisory/civi-sa-2025-04-arbitrary-file-move): Arbitrary File Move**

  Updates to APIv4 `File` could affect recent customizations. The `move_file` option will only be accepted from trusted callers.

* **[CIVI-SA-2025-05](https://civicrm.org/advisory/civi-sa-2025-05-embedded-searches): Embedded Searches**
* **[CIVI-SA-2025-06](https://civicrm.org/advisory/civi-sa-2025-06-weak-csrf-key): Weak CSRF Key**

  Updates to the CSRF key may briefly interrupt users with an active/open web-form.

## <a name="features"></a>Features

### Core CiviCRM

- **Organizations and households should be allowed to die
  ([dev/core#5962](https://lab.civicrm.org/dev/core/-/issues/5962):
  [33074](https://github.com/civicrm/civicrm-core/pull/33074))**

  Makes it so Organizations and Households can be marked as deceased.

- **Advanced Search: remembering which fieldset collapse preferences per-user
  ([dev/user-interface#82](https://lab.civicrm.org/dev/user-interface/-/issues/82):
  [33073](https://github.com/civicrm/civicrm-core/pull/33073))**

  Implements accordion sticky states for the Advanced Search settings.

- **SearchKit - Save to file rather than browser download.
  ([32329](https://github.com/civicrm/civicrm-core/pull/32329))**

  Allows for saving files to the system and you can also schedule jobs with the
  new action to have your reports saved automatically.

- **SearchKitBatch - Add formula for calculated field Contribution.net_amount
  ([33020](https://github.com/civicrm/civicrm-core/pull/33020))**

  When importing a contribution using the new SearchKit batch feature, this
  makes the 'net_amount' field readonly and calculated based on the total - fee
  amounts.

- **add stash for line items to Afform/AbstractProcessor
  ([33097](https://github.com/civicrm/civicrm-core/pull/33097))**

  Adds a simple stash to AbstractProcessor - so that line items can be gathered
  from all the entities on a form, in order to create a single contribution.

- **Add instructions to use your own civicrm.css in your extension stream in
  Riverlea ([33102](https://github.com/civicrm/civicrm-core/pull/33102))**

  Adds instructions on how to use your own civicrm.css in your extension stream
  in Riverlea.

- **Afform - Move status check for login-tokens. Make the text more actionable.
  ([31456](https://github.com/civicrm/civicrm-core/pull/31456))**

  Improves wording of status check.

- **add a relativeDate hook
  ([33027](https://github.com/civicrm/civicrm-core/pull/33027))**

  Introduces a new relativeDate hook, allowing custom extensions to define
  their own relative date options within CiviCRM.

- **make "DB Error Unknown Error" more knowable
  ([32944](https://github.com/civicrm/civicrm-core/pull/32944))**

  Makes error messages for PEAR errors (including DBError) include more details
  when debug is enabled.

- **Afform - compute redirects and confirmation messages server side
  ([32965](https://github.com/civicrm/civicrm-core/pull/32965))**

  Move post submit redirect/confirmation message content to the server so they
  can be more powerful.

- **Make Smarty default to version 5
  ([32998](https://github.com/civicrm/civicrm-core/pull/32998))**

  Makes the default smarty version 5 instead of 2.

### CiviCase

- **Store custom values for `CaseType`
  ([32977](https://github.com/civicrm/civicrm-core/pull/32977))**

  Makes it so you can create custom fields on case type.

### CiviEvent

- **Add custom fields for email to the event manage location form
  ([30990](https://github.com/civicrm/civicrm-core/pull/30990))**

  Support for custom fields on emails added to contact inline view / edit tab on
  summary but not present on Manage Location (even though address is).

### Drupal Integration

- **River Lea - Display a warning if using D7 Bartik
  ([32937](https://github.com/civicrm/civicrm-core/pull/32937))**

  Adds a status-check to warn that D7's default bartik theme may look poor.

- **Customizable name in user/edit/profile as in user/edit
  ([109](https://github.com/civicrm/civicrm-drupal-8/pull/109))**

  Allows the use of hook_user_format_name_alter for the CiviCRM profile edit
  page.

### Standalone Integration

- **Standalone login with email
  ([32979](https://github.com/civicrm/civicrm-core/pull/32979))**

  Makes it so users can login using their email on Standalone integrations.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **"cache_fill_took" causes log_civicrm_group to balloon in size
  ([dev/core#6019](https://lab.civicrm.org/dev/core/-/issues/6019):
  [33301](https://github.com/civicrm/civicrm-core/pull/33301))**

- **Proposal: Phase out public profile fields and profile listings
  (Work towards [dev/core#4808](https://lab.civicrm.org/dev/core/-/issues/4808):
  [32648](https://github.com/civicrm/civicrm-core/pull/32648))**

  Begins the process of hiding some profile options that are rarely used and
  often used in risky ways.

- **outgoing email fails when mail() is set as the mailer and a CC address is
  specified
  ([dev/core#5814](https://lab.civicrm.org/dev/core/-/issues/5814):
  [33064](https://github.com/civicrm/civicrm-core/pull/33064) and
  [33078](https://github.com/civicrm/civicrm-core/pull/33078))**

- **Please change the wording back to "From Email Addresses"
  ([dev/core#5911](https://lab.civicrm.org/dev/core/-/issues/5911):
  [33159](https://github.com/civicrm/civicrm-core/pull/33159))**

- **FormBuilder: Can't submit form with required date field with alternate
  format ([dev/core#5922](https://lab.civicrm.org/dev/core/-/issues/5922):
  [32912](https://github.com/civicrm/civicrm-core/pull/32912))**

- **FormBuilder: Trigging a select2 in a settings dropdown-menu dismisses the
  settings pane in Firefox
  ([dev/core#5932](https://lab.civicrm.org/dev/core/-/issues/5932):
  [32958](https://github.com/civicrm/civicrm-core/pull/32958))**

- **Potential crash in changelog report when using trigger-based logging
  ([dev/core#5963](https://lab.civicrm.org/dev/core/-/issues/5963):
  [33045](https://github.com/civicrm/civicrm-core/pull/33045))**

- **Contact name is not displayed in Contribution info for Participants
  ([dev/core#5967](https://lab.civicrm.org/dev/core/-/issues/5967):
  [33057](https://github.com/civicrm/civicrm-core/pull/33057))**

- **SearchKit - Stop storing dataType in display columns
  ([dev/core#5974](https://lab.civicrm.org/dev/core/-/issues/5974):
  [33101](https://github.com/civicrm/civicrm-core/pull/33101))**

- **SearchKit: Actions fail to load when search is based on Individuals and user
  is non-admin ([dev/core#5989](https://lab.civicrm.org/dev/core/-/issues/5989):
  [33142](https://github.com/civicrm/civicrm-core/pull/33142))**

- **Do not handle extension entities that have columns
  flagged as localizable in the same way as core
  ([33209](https://github.com/civicrm/civicrm-core/pull/33209))**

- **Fix regression using import mappings
  ([33194](https://github.com/civicrm/civicrm-core/pull/33194))**

- **Fix jQuery selector for jQuery 3 support
  ([33044](https://github.com/civicrm/civicrm-core/pull/33044))**

- **Fix overdue activity not listed in red in RiverLea
  ([33028](https://github.com/civicrm/civicrm-core/pull/33028))**

- **Fix activity-selectors/filters too wide
  ([33029](https://github.com/civicrm/civicrm-core/pull/33029))**

- **Fully hide pricesetTotal div when not needed
  ([33041](https://github.com/civicrm/civicrm-core/pull/33041))**

- **Stop deleting UserJobs if mapping is deleted
  ([33161](https://github.com/civicrm/civicrm-core/pull/33161))**

- **SearchKitBatch - Refresh display after creating new batch
  ([33156](https://github.com/civicrm/civicrm-core/pull/33156))**

- **Allow activities with > 50 contact targets to be edited
  ([33085](https://github.com/civicrm/civicrm-core/pull/33085))**

- **More consistent titles and copy on Extension pages and forms
  ([33098](https://github.com/civicrm/civicrm-core/pull/33098))**

- **Fix token labels for custom fields with colons in their labels
  ([32200](https://github.com/civicrm/civicrm-core/pull/32200))**

- **Avoid PHP Deprecated warning when image URL has no query vars
  ([33063](https://github.com/civicrm/civicrm-core/pull/33063))**

- **Relationship lost when merging if both contacts have the same relationship
  with the same contact
  ([dev/core#5426](https://lab.civicrm.org/dev/core/-/issues/5426):
  [33031](https://github.com/civicrm/civicrm-core/pull/33031))**

- **Remove non-functional Profile Update from SK contact actions
  ([32996](https://github.com/civicrm/civicrm-core/pull/32996))**

- **SearchKit: "Is Test" field behaves incorrectly
  ([33072](https://github.com/civicrm/civicrm-core/pull/33072))**

- **RiverLea: add fallback font-family and size for iframes
  ([33052](https://github.com/civicrm/civicrm-core/pull/33052))**

  Makes styling more consistent by adding a fallback font faimy and size for
  iframes for sites using RiverLea.

- **Redirect skip postprocess hook, replaced it with replaceUserContext
  ([33048](https://github.com/civicrm/civicrm-core/pull/33048))**

- **RiverLea: Make FormBuilder edit buttons the same across streams, and subtler
  ([33024](https://github.com/civicrm/civicrm-core/pull/33024))**

- **Add dot to end of sentence in just merged upgrade message
  ([33026](https://github.com/civicrm/civicrm-core/pull/33026))**

- **Rebuilder - Also, Angular
  ([33037](https://github.com/civicrm/civicrm-core/pull/33037))**

  Clear angular cache intentionally.

- **Do not modify the user message when printing the error message
  ([33034](https://github.com/civicrm/civicrm-core/pull/33034))**

- **Allow extra detail to be passed through to validate
  ([33015](https://github.com/civicrm/civicrm-core/pull/33015))**

- **Address standalone security & stability concerns
  ([33008](https://github.com/civicrm/civicrm-core/pull/33008))**

  Updates readme of the Standalone extension.

- **Upgrader - Ensure that doRebuild() runs in the expected way (by setting
   policy) ([32994](https://github.com/civicrm/civicrm-core/pull/32994))**

- **Afform.submit - better check for whether redirect/message is already set
  ([33006](https://github.com/civicrm/civicrm-core/pull/33006))**

- **CustomGroup - Ensure table exists before referencing it
  ([33017](https://github.com/civicrm/civicrm-core/pull/33017))**

- **JobManager - Fix reporting/classification of APIv3 errors
  ([32971](https://github.com/civicrm/civicrm-core/pull/32971))**

- **Api4 - Catch errors with pseudoconstant lookups
  ([32987](https://github.com/civicrm/civicrm-core/pull/32987))**

- **Fix `AbstractGetAction::_whereContains()`
  ([32974](https://github.com/civicrm/civicrm-core/pull/32974))**

- **Afform.submit - use instance property rather than local var for entityValues
  ([32962](https://github.com/civicrm/civicrm-core/pull/32962))**

- **i18n - Flush relevant caches after changing multilingual configuration
  ([33030](https://github.com/civicrm/civicrm-core/pull/33030))**

- **If a field is already an array then don't pass through string unserialize
  functions ([32981](https://github.com/civicrm/civicrm-core/pull/32981))**

- **SiteEmail - Remove redundant label from "Site Email Address" form
  ([32954](https://github.com/civicrm/civicrm-core/pull/32954))**

- **Fix Saving Of Free Tags During Case Activity Creation
  ([33013](https://github.com/civicrm/civicrm-core/pull/33013))**

- **Escape HML characters in parameters for `{help}` smarty tag
  ([33014](https://github.com/civicrm/civicrm-core/pull/33014))**

- **ContactSummary - Remove redundant disclosure wrapper on custom fields
  ([33191](https://github.com/civicrm/civicrm-core/pull/33191))**

- **ImportSubscriber - remove unused + buggy Import_Summary forms
  ([33171](https://github.com/civicrm/civicrm-core/pull/33171))**

- **fix warning in Setting::getFields when passed non-existent name filter
  ([32800](https://github.com/civicrm/civicrm-core/pull/32800))**

- **Fix fatal error
  ([32964](https://github.com/civicrm/civicrm-core/pull/32964))**

- **Don't show activity description when deleting
  ([32947](https://github.com/civicrm/civicrm-core/pull/32947))**

- **Remove extraneous ts
  ([32995](https://github.com/civicrm/civicrm-core/pull/32995))**

### CiviContribute

- **Use existing contribution currency when contributionPage is in invoice mode
  ([33001](https://github.com/civicrm/civicrm-core/pull/33001))**

- **Prevent soft credit amounts > contribution amount on edit
  ([33042](https://github.com/civicrm/civicrm-core/pull/33042))**

- **generate `invoice id` in Contribution BAO if not provided
  ([32967](https://github.com/civicrm/civicrm-core/pull/32967))**

- **Fix file custom fields on contribution pages
  ([32980](https://github.com/civicrm/civicrm-core/pull/32980))**

- **dont check Contribution permissions within Order BAO
  ([32961](https://github.com/civicrm/civicrm-core/pull/32961))**

- **Align Contribution Import header handling with other imports
  ([33199](https://github.com/civicrm/civicrm-core/pull/33199))**

### CiviEvent

- **"Import Participants" - Unable to use saved field mappings
  ([dev/core#5977](https://lab.civicrm.org/dev/core/-/issues/5977):
  [33163](https://github.com/civicrm/civicrm-core/pull/33163))**

- **Show cancelled participants in Also registered by
  ([32946](https://github.com/civicrm/civicrm-core/pull/32946))**

  Ensures cancelled participants are shown in the also registered by section.

### CiviMail

- **The 'Intended Recipients' field on Mailing Reports has an inconsistent
  meaning ([dev/core#5945](https://lab.civicrm.org/dev/core/-/issues/5945):
  [33007](https://github.com/civicrm/civicrm-core/pull/33007))**

### CiviMember

- **Fix duplicate Contact ID mapping option on membership import
  ([33110](https://github.com/civicrm/civicrm-core/pull/33110))**

- **Ensure Membership import contact_id field is correctly upgraded
  ([33160](https://github.com/civicrm/civicrm-core/pull/33160))**

### Drupal Integration

- **Correct form name for qfKey on delete file through drupal user civicrm
  profile. ([32668](https://github.com/civicrm/civicrm-core/pull/32668))**

- **satisfy phpcs - var declarations
  ([110](https://github.com/civicrm/civicrm-drupal-8/pull/110))**

### Joomla Integration

- **distmaker - Update build-report for Joomla 5
  ([33065](https://github.com/civicrm/civicrm-core/pull/33065))**

- **distmaker - Fix typo that prevents Joomla 5 builds
  ([33053](https://github.com/civicrm/civicrm-core/pull/33053))**

### WordPress Integration

- **add composer.json
  ([347](https://github.com/civicrm/civicrm-wordpress/pull/347))**

  Work towards a methodology to install CiviCRM into Wordpress with composer.

- **Only show deprecation notice when writing to file
  ([350](https://github.com/civicrm/civicrm-wordpress/pull/350))**

### Standalone Integration

- **Standalone - Respect include_disabled param in permission.getOptions
  ([32169](https://github.com/civicrm/civicrm-core/pull/32169))**

- **load settings defaults before Standalone session start
  ([32982](https://github.com/civicrm/civicrm-core/pull/32982))**

- **Update standalone install to be non-destructive
  ([32956](https://github.com/civicrm/civicrm-core/pull/32956))**

## <a name="misc"></a>Miscellany

- **RiverLea 6.5 metadata: changelog, version number & ReadMe
  ([33321](https://github.com/civicrm/civicrm-core/pull/33321))**

- **Drop unused table civicrm_import_template_field
  ([333128](https://github.com/civicrm/civicrm-core/pull/33312))**

- **Make code identical for identical API calls
  ([33084](https://github.com/civicrm/civicrm-core/pull/33084))**

- **CoreForm - Remove deprecated date functions
  ([32951](https://github.com/civicrm/civicrm-core/pull/32951))**

- **Delete two empty files
  ([33089](https://github.com/civicrm/civicrm-core/pull/33089))**

- **Removes two empty files
  ([33105](https://github.com/civicrm/civicrm-core/pull/33105))**

- **Replace getCRMDatabasePrefix() with simpler/more sensible functions
  getCMSDatabaseName()/getCRMDatabaseName()
  ([33000](https://github.com/civicrm/civicrm-core/pull/33000))**

- **Remove noisily deprecated date functions file
  ([32926](https://github.com/civicrm/civicrm-core/pull/32926))**

- **Remove deprecated DateRange.tpl
  ([32901](https://github.com/civicrm/civicrm-core/pull/32901))**

- **(REF) Swap-in calls to `Civi::rebuild()`
  ([33039](https://github.com/civicrm/civicrm-core/pull/33039))**

- **(REF) Simplify calls to `Civi::rebuild()`
  ([33038](https://github.com/civicrm/civicrm-core/pull/33038))**

- **(REF) JobManager - Extract log code. Abide PSR-3.
  ([32966](https://github.com/civicrm/civicrm-core/pull/32966))**

- **(REF) Swap rebuildMenuAndCaches() with Civi::rebuild()
  ([32993](https://github.com/civicrm/civicrm-core/pull/32993))**

- **[REF] For DB Query Exceptions when generating the Yellow Screen data use
  the getUserMessage function
  ([33035](https://github.com/civicrm/civicrm-core/pull/33035))**

- **Add rafe-murray as a contributor
  ([33099](https://github.com/civicrm/civicrm-core/pull/33099))**

- **[NFC] first pass at 6.5 release notes
  ([33281](https://github.com/civicrm/civicrm-core/pull/33281))**

- **[NFC] [PHPUNIT10] - dev/core#5944 - typo in test envbuilder
  ([32997](https://github.com/civicrm/civicrm-core/pull/32997))**

- **[NFC] correct setting override global in comment
  ([33113](https://github.com/civicrm/civicrm-core/pull/33113))**

- **[NFC] SearchKit - Remove unused dataType from unit tests
  ([33092](https://github.com/civicrm/civicrm-core/pull/33092))**

- **(NFC) MailingTest::testApiV4DoesNotSchedule() - Be less ornery
  ([33077](https://github.com/civicrm/civicrm-core/pull/33077))**

- **[NFC] Modify Test on tokens to test patch for PR 32200
  ([33067](https://github.com/civicrm/civicrm-core/pull/33067))**

- **(NFC) Riverlea - Fix linting issue in _form.css
  ([33055](https://github.com/civicrm/civicrm-core/pull/33055))**

- **[NFC] [PHPUNIT10] - Support phpunit 10
  (Work towards [dev/core#5944](https://lab.civicrm.org/dev/core/-/issues/5944):
  [32992](https://github.com/civicrm/civicrm-core/pull/32992),
  [32988](https://github.com/civicrm/civicrm-core/pull/32988),
  [32989](https://github.com/civicrm/civicrm-core/pull/32989),
  [32990](https://github.com/civicrm/civicrm-core/pull/32990) and
  [32991](https://github.com/civicrm/civicrm-core/pull/32991))**

- **[NFC} Afform - Correct comment
  ([32976](https://github.com/civicrm/civicrm-core/pull/32976))**

- **[NFC] Add void to test class declaration as per updated parent
  ([111](https://github.com/civicrm/civicrm-drupal-8/pull/111))**

- **NFC Fix comment to match type hint
  ([32948](https://github.com/civicrm/civicrm-core/pull/32948))**

- **Test fix - ensure civiimport enabled
  ([33132](https://github.com/civicrm/civicrm-core/pull/33132))**

- **HttpTestTrait - Set a concrete timeout
  ([33011](https://github.com/civicrm/civicrm-core/pull/33011))**

- **api_v3_SystemTest - Fix for newer MySQL and MariaDB versions
  ([33058](https://github.com/civicrm/civicrm-core/pull/33058))**

- **umm...
  ([33070](https://github.com/civicrm/civicrm-core/pull/33070))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; Benjamin W;
BrightMinded Ltd - Bradley Taylor; Christian Wach; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Nicolas Ganivet; Coop SymbioTIC - Mathieu Lutfy, Samuel
Vanhove; Dave D; Fuzion - Luke Stewart; Humanists UK - Andrew West; iXiam -
Albert Vall-Llovera; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee, Rafe
Murray; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew
Wire; Mosier Consulting - Justin Mosier; Nicol Wistreich; Richard Baugh;
Skvare - Mark Hanna, Sunil Pawar; Squiffle Consulting - Aidan Saunders;
Systopia - Dominic Tubach; Tadpole Collective - Kevin Cristiano; Wikimedia
Foundation - Eileen McNaughton, Wenjun Fan; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Coop SymbioTIC - Shane Bill; Daniel Strum;
Ezodesign - Jeremy Proffitt; Francesc Bassas i Bullich; Guydn; Lemniscus - Noah
Miller; New York State Senate - Nate Frank; Savion Lee; Skvare - Mark Hanna
