# CiviCRM 6.10.0

Released January 7, 2026;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  |   no    |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Security fix: Add verification of IPN messages received from PayPal
  ([33670](https://github.com/civicrm/civicrm-core/pull/33670))**

  PayPal IPN validation is now in effect. This should not have any impact on
  operations but admins are advised to check things are working normally.

- **Upgrader - Require CIVICRM_CRED_KEYS
  ([34241](https://github.com/civicrm/civicrm-core/pull/34241))**

  Makes CIVICRM_CRED_KEYS mandatory for all deployments. If its not defined in
  the civicrm.settings.php file, the web-upgrader blocks the upgrade.

- **New USPS REST API for address validation
  ([dev/core#5833](https://lab.civicrm.org/dev/core/-/issues/5833):
  [34346](https://github.com/civicrm/civicrm-core/pull/34346))**

  The USPS REST API is changing in January 2026. This change ensures CiviCRM
  will play nicely with the changes.

- **Admin UI ext: add Price Set admin
  ([34143](https://github.com/civicrm/civicrm-core/pull/34143))**

  Adds a SearchKit and FormBuilder to manage Price Set Options.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Api4 - Fix query error when option values contain special characters
  ([34350](https://github.com/civicrm/civicrm-core/pull/34350))**

- **Multivalued custom group of style tab crashes on Individual subtypes when
  group is for Contacts.
  ([dev/core#6122](https://lab.civicrm.org/dev/core/-/issues/6122):
  [34361](https://github.com/civicrm/civicrm-core/pull/34361))**

- **Required Custom File field triggers required message on edit when unchanged
  ([dev/core#6124](https://lab.civicrm.org/dev/core/-/issues/6124):
  [34279](https://github.com/civicrm/civicrm-core/pull/34279))**

- **error about managed entity every time clear cache
  ([dev/core#6228](https://lab.civicrm.org/dev/core/-/issues/6228):
  [34220](https://github.com/civicrm/civicrm-core/pull/34220))**

- **Multivalued custom fields crash on submit
  ([dev/core#6245](https://lab.civicrm.org/dev/core/-/issues/6245):
  [34282](https://github.com/civicrm/civicrm-core/pull/34282))**

- **Fatal Error on CiviCRM version 6.9.0 if using Smarty 2
  ([dev/core#6249](https://lab.civicrm.org/dev/core/-/issues/6249):
  [34288](https://github.com/civicrm/civicrm-core/pull/34288))**

- **Afform - Fix regression with rejected Autocomplete request via Authx
  ([34224](https://github.com/civicrm/civicrm-core/pull/34224))**

- **FormBuilder: Adding a public path does not update the menu item with
  is_public ([dev/core#6248](https://lab.civicrm.org/dev/core/-/issues/6248):
  [34285](https://github.com/civicrm/civicrm-core/pull/34285))**

- **SearchKit - Fix error in sortable columns
  ([34259](https://github.com/civicrm/civicrm-core/pull/34259))**

  Fixes console error in SearchKit.

- **PSR-7 - Normalize getPath(). Fix E2E test-failure.
  ([34247](https://github.com/civicrm/civicrm-core/pull/34247))**

- **Fix custom data type
  ([34256](https://github.com/civicrm/civicrm-core/pull/34256))**

- **Required radio button fields missing red asterisk
  ([34452](https://github.com/civicrm/civicrm-core/pull/34452))**

- **Errors/Exceptions - Fix misleading message. Add important details.
  ([34449](https://github.com/civicrm/civicrm-core/pull/34449))**

- **AdminUI - Fix deleting mailings
  ([34440](https://github.com/civicrm/civicrm-core/pull/34440))**

- **Outbound Email - Fix multiple bugs when handling mandatory settings
  ([dev/core#6251](https://github.com/civicrm/civicrm-core/pull/34443))**

- **Settings UI - Skip non-applicable validators. Fix color-overrides.
  ([dev/core#6251](https://github.com/civicrm/civicrm-core/pull/34442))**

- **Afform - Fix custom afform submission messages
  ([34430](https://github.com/civicrm/civicrm-core/pull/34430))**

- **Riverlea - Fix visibility of items set to .disabled in dropdown
  ([34421](https://github.com/civicrm/civicrm-core/pull/34421))**

- **Riverlea - Rename variable so it uses the correct component prefix
  ([34415](https://github.com/civicrm/civicrm-core/pull/34415))**

- **Make Drupal 10/11 installs not fail
  ([34391](https://github.com/civicrm/civicrm-core/pull/34391))**

### CiviContribute

- **When financial account is the same before and after, treat payment method
  changes the same as for financial type changes
  ([dev/financial#230](https://lab.civicrm.org/dev/financial/-/issues/230):
  [31928](https://github.com/civicrm/civicrm-core/pull/31928))**

- **Fix contribution page highlight
  ([34420](https://github.com/civicrm/civicrm-core/pull/34420))**

### CiviEvent

- **Event registration page lets you complete a registration even if event end
  has past ([dev/core#6232](https://lab.civicrm.org/dev/core/-/issues/6232):
  [34231](https://github.com/civicrm/civicrm-core/pull/34231))**

- **"Email Invoice" does not honor CC/BCC for event-related contributions
  ([dev/core#6209](https://lab.civicrm.org/dev/core/-/issues/6209):
  [34088](https://github.com/civicrm/civicrm-core/pull/34088))**

## <a name="misc"></a>Miscellany

- **[NFC] 6.10 release note late changes
  ([34389](https://github.com/civicrm/civicrm-core/pull/34389))**

- **[NFC] Backport 2025 back into 2025
  ([34392](https://github.com/civicrm/civicrm-core/pull/34392))**

- **Afform - Remove non-functional POC permission code
  ([34226](https://github.com/civicrm/civicrm-core/pull/34226))**

- **[REF] SearchKit - cleanup js with less lo-dash
  ([34217](https://github.com/civicrm/civicrm-core/pull/34217))**

- **[NFC] Mixin - Fix signature of alterSchemaField doc
  ([34286](https://github.com/civicrm/civicrm-core/pull/34286))**

- **[NFC] Fix flaky event registration test
  ([34229](https://github.com/civicrm/civicrm-core/pull/34229))**

- **(NFC) RouterTest - Fix false-negatives on WordPress
  ([34221](https://github.com/civicrm/civicrm-core/pull/34221))**

- **[NFC] 6.10 release notes first pass
  ([34349](https://github.com/civicrm/civicrm-core/pull/34349))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

Benjamin W; CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy;
Dave D; Joinery - Allen Shaw; Skvare - Sunil Pawar

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Coop SymbioTIC - Shane Bill; JMA Consulting - Seamus Lee
