# CiviCRM 5.82.0

Released February 5, 2025;

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Enable Riverlea extension (*not* theme) + dark mode on new Standalone
  installs ([31633](https://github.com/civicrm/civicrm-core/pull/31633),
  [31611](https://github.com/civicrm/civicrm-core/pull/31611),
  [31739](https://github.com/civicrm/civicrm-core/pull/31739) and
  [31619](https://github.com/civicrm/civicrm-core/pull/31619))**

  Enables RiverLea extension and dark mode on new Standalone installs and
  various RiverLea improvements.

- **Formbuilder: Add screen tip for URL filter to show format should be
  "#/?field=value"
  ([dev/core#5653](https://lab.civicrm.org/dev/core/-/issues/5653):
  [31656](https://github.com/civicrm/civicrm-core/pull/31656))**

  Adds a screen tip to form builder to show correct format to pass value to
  form in URL when URL filter is selected.

- **FormBuilder: Validate max characters
  ([dev/core#5649](https://lab.civicrm.org/dev/core/-/issues/5649):
  [31720](https://github.com/civicrm/civicrm-core/pull/31720) and
  [31668](https://github.com/civicrm/civicrm-core/pull/31668))**

  Ensures the max length for form builder text areas is enforced, and adds a
  live character counter below.

- **Formbuilder: it is not possible to download a file (in a field file) in FB
  like in a "profile/view"
  ([dev/core#5179](https://lab.civicrm.org/dev/core/-/issues/5179):
  [31459](https://github.com/civicrm/civicrm-core/pull/31459))**

  Makes it possible to download a file in a field file in FormBuilder.

- **Afform - Add (no placeholder) placeholder in FormBuilder
  ([dev/core#3070](https://lab.civicrm.org/dev/core/-/issues/3070):
  [31548](https://github.com/civicrm/civicrm-core/pull/31548))**

  Makes it more obvious that placeholders can be added to formbuilder fields
  by typing into the field.

- **SearchKit - Add 'whole row' and 'add row' editable features
  ([31583](https://github.com/civicrm/civicrm-core/pull/31583) and
  [31780](https://github.com/civicrm/civicrm-core/pull/31780))**

  Adds 2 useful modes to SearchKit editable settings:

    1. Edit whole row: enables all fields in row to be edited and saved at once
    2. Add new row: enables a new row to be added in-place

- **SearchKit - Add labels for joins
  ([31664](https://github.com/civicrm/civicrm-core/pull/31664))**

  Enables SearchKit joins to be labelled.

- **SearchKit - Enable rewrite in footer totals
  ([31649](https://github.com/civicrm/civicrm-core/pull/31649))**

  Allows the Footer Totals section to be rewritten, using tokens and/or smarty.

- **SearchKit - Editable refresh/performance/permission improvements
  ([31382](https://github.com/civicrm/civicrm-core/pull/31382))**

  Multiple improvements to Searchkit inline-edit, more details below:

    - Editable fields can skip permission checks when the searchDisplay is configured for acl_bypass
    - Option lists are pre-loaded and don't need to be fetched prior to editing a field
    - Data is saved & the entire row refreshed server-side in a single ajax request
    - Editable metadata is loaded once per column instead of once per row, improving performance
    - Save & refresh are non-blocking and another field can be edited simultaneously
    - Improve test coverage

- **SearchKit - Improve behavior of appending (copy) to cloned searches
  ([31618](https://github.com/civicrm/civicrm-core/pull/31618))**

  Smarter default labels when cloning or creating a search from a template.

- **SearchKit HAVING clause does not support relative dates.
  ([dev/core#4448](https://lab.civicrm.org/dev/core/-/issues/4448):
  [31622](https://github.com/civicrm/civicrm-core/pull/31622))**

  Makes it so one can use relative dates in searchkit HAVING clauses.

- **API v4 permissions: CustomField/get requires full admin access
  ([dev/core#5664](https://lab.civicrm.org/dev/core/-/issues/5664):
  [31695](https://github.com/civicrm/civicrm-core/pull/31695) and
  [31732](https://github.com/civicrm/civicrm-core/pull/31732))**

  Lowers permission requirements for accessing custom field metadata, so that
  higher permissions do not need to be granted to so many users.

- **Api4 - Generalise CustomGroup.get caching approach and use for CustomField
  also ([31569](https://github.com/civicrm/civicrm-core/pull/31569) and
  [31578](https://github.com/civicrm/civicrm-core/pull/31578))**

  Improves the APIv4 customfield api.

- **Send Email: rename HTML Format to Message Body, tweak help
  ([31602](https://github.com/civicrm/civicrm-core/pull/31602))**

  User experience tweaks to the Send Email form.

- **Support csv_importer import jobs in searchkit import report
  ([31586](https://github.com/civicrm/civicrm-core/pull/31586))**

  Provides more explicit error messages when an import job fails.

- **financialacls: it's OK to disable the extension
  ([31731](https://github.com/civicrm/civicrm-core/pull/31731))**

  Removes the scary message about disabling the financialacls extension.
  CiviCRM works fine without it (and sometimes better).

### CiviEvent

- **eventcart: on EventInfo, show checkout/viewcart buttons
  ([31625](https://github.com/civicrm/civicrm-core/pull/31625))**

  Improves user experience of Event Cart by adding checkout and view cart
  buttons to the event info page.

- **Misc thoughts on reducing log overload (Work towards
  [dev/core#5320](https://lab.civicrm.org/dev/core/-/issues/5320):
  [31036](https://github.com/civicrm/civicrm-core/pull/31036))**

  Respond with a 400 for Event Registration and Info pages to reduce log
  overload from bots.

### Drupal Integration

- **Performance on generating links in CiviCRM on Drupal 8/9/10
  ([dev/drupal#200](https://lab.civicrm.org/dev/drupal/-/issues/200):
  [31634](https://github.com/civicrm/civicrm-core/pull/31634))**

  Improves performance when generating links.

### WordPress Integration

- **Wordpress Access Control page hard to navigate
  ([dev/wordpress#147](https://lab.civicrm.org/dev/wordpress/-/issues/147):
  [30180](https://github.com/civicrm/civicrm-core/pull/30180))**

  Reworks the output of Wordpress Access control table.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Mailing system doesn't work with DigitalOcean managed databases
  ([dev/core#4782](https://lab.civicrm.org/dev/core/-/issues/4782):
  [31662](https://github.com/civicrm/civicrm-core/pull/31662))**

- **"Add contribution page" broken. Also "Add another profile" link on Manage
  Event online registration tab broken
  ([dev/core#5660](https://lab.civicrm.org/dev/core/-/issues/5660):
  [31663](https://github.com/civicrm/civicrm-core/pull/31663))**

  Fixes various recently introduced crashes.

- **Div ID "contact-summary" changed to "contact-0"
  ([dev/core#5688](https://lab.civicrm.org/dev/core/-/issues/5688):
  [31822](https://github.com/civicrm/civicrm-core/pull/31822))**

- **Subtype-specific tabs appear for everyone
  ([dev/core#5690](https://lab.civicrm.org/dev/core/-/issues/5690):
  [31830](https://github.com/civicrm/civicrm-core/pull/31830))**

- **Api4 - Fix dataType of IF functions
  ([31621](https://github.com/civicrm/civicrm-core/pull/31621))**

- **searchkit: activity contact role doesn't "stick", and neither does filter on
  activity type
  ([dev/core#5681](https://lab.civicrm.org/dev/core/-/issues/5681):
  [31756](https://github.com/civicrm/civicrm-core/pull/31756))**

- **SearchKit - Fix error when adding task-based link to field
  ([31861](https://github.com/civicrm/civicrm-core/pull/31861))**

- **SearchKit - Fix javascript error when adding links column
  ([31860](https://github.com/civicrm/civicrm-core/pull/31860))**

  When adding a links column to a table display, an uncaught exception showed up
  in the console. This fixes it.

- **Searchkit regression: totals are not displayed
  ([dev/core#5674](https://lab.civicrm.org/dev/core/-/issues/5674):
  [31719](https://github.com/civicrm/civicrm-core/pull/31719))**

- **SearchKit - Fix missing pseudofield label
  ([31670](https://github.com/civicrm/civicrm-core/pull/31670))**

  Fixes php warning and missing field label when using "Extra" fields like "Row
  Number" as columns.

- **FormBuilder: Using "Generic: Anyone with secret link" breaks admin screen
  ([dev/core#5704](https://lab.civicrm.org/dev/core/-/issues/5704):
  [31878](https://github.com/civicrm/civicrm-core/pull/31878))**

- **Afform Admin: allow multi-select default values on more input types
  ([30943](https://github.com/civicrm/civicrm-core/pull/30943))**

- **Afform - Fix default showing literal 'undefined'
  ([31666](https://github.com/civicrm/civicrm-core/pull/31666))**

  Fixes quirk when adding a default value to an Afform field

- **[FormBuilder] Multiple records custom field set data is truncated in Form
  Builder that has dedupe rules for contacts
  ([dev/core#5589](https://lab.civicrm.org/dev/core/-/issues/5589):
  [31480](https://github.com/civicrm/civicrm-core/pull/31480))**

- **Add openId icon
  ([31714](https://github.com/civicrm/civicrm-core/pull/31714))**

- **composer.json - Lighten up the load from bower_components/monaco-editor
  ([31563](https://github.com/civicrm/civicrm-core/pull/31563))**

- **revert accidental end date change on Deferred Revenue Report
  ([31696](https://github.com/civicrm/civicrm-core/pull/31696))**

- **restore alpha-selector to the top of search results
  ([31794](https://github.com/civicrm/civicrm-core/pull/31794))**

- **CRM Search - Fix disabled custom fields appearing on forms
  ([31862](https://github.com/civicrm/civicrm-core/pull/31862))**

- **Admin ACLs: remove report class on table
  ([31635](https://github.com/civicrm/civicrm-core/pull/31635))**

- **Update deleted files list to fix "old files" status check warning (master
  version) ([31648](https://github.com/civicrm/civicrm-core/pull/31648))**

- **"Domain not found" error (error code 450 - class 4.1.2) is not a temporary
  error ([31608](https://github.com/civicrm/civicrm-core/pull/31608))**

- **CRM_Utils_Cache - Use more consistent group names
  ([31403](https://github.com/civicrm/civicrm-core/pull/31403))**

- **CiviImport - Remove redundant function
  ([31673](https://github.com/civicrm/civicrm-core/pull/31673))**

- **Update info.xml for search_kit_reports and fix links in search_kit chart_kit
  ([31716](https://github.com/civicrm/civicrm-core/pull/31716))**

- **Removes contact_id condition around 'including yourself' text
  ([31449](https://github.com/civicrm/civicrm-core/pull/31449))**

- **Ensure null is not passed to htmlentities
  [31667](https://github.com/civicrm/civicrm-core/pull/31667))**

- **Cast null description to string
  ([31684](https://github.com/civicrm/civicrm-core/pull/31684))**

- **Move flushing of activityType static to OptionValue:create
  ([31687](https://github.com/civicrm/civicrm-core/pull/31687))**

- **Fix default property value: CRM_Contact_Form_Merge->criteria
  ([31682](https://github.com/civicrm/civicrm-core/pull/31682))**

- **ContactSummary - Fix missing tabs
  ([31823](https://github.com/civicrm/civicrm-core/pull/31823))**

- **Check if property is set before using
  ([31715](https://github.com/civicrm/civicrm-core/pull/31715))**

- **Revert "afform tabs - use CRM_Core_BAO_CustomGroup cache"
  ([31604](https://github.com/civicrm/civicrm-core/pull/31604))**

- **Fix Smarty notice - never assigned `$fieldHandle`
  ([31653](https://github.com/civicrm/civicrm-core/pull/31653))**

- **Smarty notice fix on campaign
  ([31654](https://github.com/civicrm/civicrm-core/pull/31654))**

- **Smarty Notice fix
  ([31639](https://github.com/civicrm/civicrm-core/pull/31639))**

- **Notice fix
  ([31641](https://github.com/civicrm/civicrm-core/pull/31641))**

- **Test slowness - double populate
  ([dev/core#5665](https://lab.civicrm.org/dev/core/-/issues/5665):
  [31680](https://github.com/civicrm/civicrm-core/pull/31680))**

- **Support null in api doc block comments
  ([dev/core#5567](https://lab.civicrm.org/dev/core/-/issues/5567):
  [31395](https://github.com/civicrm/civicrm-core/pull/31395))**

- **Generated hash can be numeric breaking is_numeric tests
  ([dev/core#5541](https://lab.civicrm.org/dev/core/-/issues/5541):
  [31576](https://github.com/civicrm/civicrm-core/pull/31576))**

### CiviCase

- **Case activity send copy has a blank details field in the email activity copy
  filed on the case
  ([dev/core#5629](https://lab.civicrm.org/dev/core/-/issues/5629):
  [31572](https://github.com/civicrm/civicrm-core/pull/31572))**

### CiviContribute

- **Fee Amount ignored on AdditionalPayment form
  ([dev/core#5655](https://lab.civicrm.org/dev/core/-/issues/5655):
  [31637](https://github.com/civicrm/civicrm-core/pull/31637))**

- **fix appendBreadCrumb calls when deleting PriceSet / PriceField  
  ([31730](https://github.com/civicrm/civicrm-core/pull/31730))**

- **Remove another use of api3 contribution.completetransaction
  ([31405](https://github.com/civicrm/civicrm-core/pull/31405))**

- **Fix unix timestamp bug in deferred revenue report
  ([31694](https://github.com/civicrm/civicrm-core/pull/31694))**

- **Minor improvements to existing batch data entry issue
  ([dev/core#5584](https://lab.civicrm.org/dev/core/-/issues/5584):
  [31446](https://github.com/civicrm/civicrm-core/pull/31446))**

  Fixes a couple of issues with the soft credit type field in the batch data
  entry screen

### CiviEvent

- **Fix mis-allocation of is_primary when Primary and Billing emails on profiles
  on an event ([30618](https://github.com/civicrm/civicrm-core/pull/30618))**

- **Custom Field Group not allowing multiple records for Participants or Events
  ([dev/core#5603](https://lab.civicrm.org/dev/core/-/issues/5603):
  [31606](https://github.com/civicrm/civicrm-core/pull/31606))**

- **Add value check in DisplayProfile.tpl
  ([31546](https://github.com/civicrm/civicrm-core/pull/31546))**

  Ensures labels for empty fields aren't displayed in Event registration
  confirmation pages.

### CiviMember

- **AdminUI: tweak TabMember markup and translation
  ([31605](https://github.com/civicrm/civicrm-core/pull/31605))**
  
- **Fix missing membershiplog entries and add tests following #30493
  ([31655](https://github.com/civicrm/civicrm-core/pull/31655))**

### Standalone Integration

- **standaloneusers - translate password reset page titles
  ([31557](https://github.com/civicrm/civicrm-core/pull/31557))**

- **standaloneusers - fix send password reset action on Administer Users
  ([31848](https://github.com/civicrm/civicrm-core/pull/31848))**

### WordPress Integration

- **WordPress Permissions: code cleanup, use cycle and odd-row css classes
  ([31628](https://github.com/civicrm/civicrm-core/pull/31628))**

## <a name="misc"></a>Miscellany

- **Update phpspreadsheet
  ([31879](https://github.com/civicrm/civicrm-core/pull/31879))**

- **SearchKit - Fix testTallyWithGroupBy intermittent test fail
  ([31762](https://github.com/civicrm/civicrm-core/pull/31762))**

- **Standardise setUp for CiviCase shared code
  ([31686](https://github.com/civicrm/civicrm-core/pull/31686))**

- **CommunicationPreferences form code cleanup
  ([31672](https://github.com/civicrm/civicrm-core/pull/31672))**

- **Remove deprecated code
  ([31691](https://github.com/civicrm/civicrm-core/pull/31691))**

- **Remove deprecated code
  ([31690](https://github.com/civicrm/civicrm-core/pull/31690))**

- **Remove a couple of cases of the old NULL array
  ([31703](https://github.com/civicrm/civicrm-core/pull/31703))**

- **Remove remaining calls to (deprecated) cache()->flush
  ([31411](https://github.com/civicrm/civicrm-core/pull/31411))**

- **Bump cookie and socket.io
  ([31792](https://github.com/civicrm/civicrm-core/pull/31792))**

- **Update searchTest to not call form class in legacy way
  ([31676](https://github.com/civicrm/civicrm-core/pull/31676))**

- **Remove some crud tests that are well covered elsewhere
  ([31704](https://github.com/civicrm/civicrm-core/pull/31704))**

- **Remove difficult test from earlier versions so php 7.4 runs don't complain
  ([31870](https://github.com/civicrm/civicrm-core/pull/31870))**

- **[REF] use common helper to set expected keys for tabs in Summary.tpl and
  TabHeader.tpl ([31636](https://github.com/civicrm/civicrm-core/pull/31636))**

- **[REF][PHP8.2]  Fix typo in property name
  ([31657](https://github.com/civicrm/civicrm-core/pull/31657))**

- **[REF][PHP8.2] Declare missing properties on CRM_PCP_Form_PCPAccount
  ([31683](https://github.com/civicrm/civicrm-core/pull/31683))**

- **REF: Simplify URL params for relationship form and don't require 'rtype'
  when updating a relationship
  ([31568](https://github.com/civicrm/civicrm-core/pull/31568))**

- **[REF] Set backOffice Parameter on Payment Processor when on the back office
  ([31566](https://github.com/civicrm/civicrm-core/pull/31566))**

- **[REF] Ensure that _fid property is updated following save so extensions can
  reliably call getEntityID in postProcess
  ([31001](https://github.com/civicrm/civicrm-core/pull/31001))**

- **[REF] Api4 - Custom field auto-cleanup improvements
  ([31729](https://github.com/civicrm/civicrm-core/pull/31729))**

- **[REF] Use shared TabHeader.tpl for contact summary tabs as well
  ([31697](https://github.com/civicrm/civicrm-core/pull/31697))**

- **[REF] Fix notice error if accepted credit cards field IS NULL
  ([31711](https://github.com/civicrm/civicrm-core/pull/31711))**

- **[REF][PHP8.2] Declare properties on CRM_Contribute_Page_PaymentInfo
  ([31710](https://github.com/civicrm/civicrm-core/pull/31710))**

- **[REF][PHP8.2] Decalare properties - CRM_Contact_Form_Merge
  ([31658](https://github.com/civicrm/civicrm-core/pull/31658))**

- **NFC - Simplify api4 docblock
  ([31623](https://github.com/civicrm/civicrm-core/pull/31623))**

- **(NFC) RegionTest, SmartyTest - Restore performance
  ([31614](https://github.com/civicrm/civicrm-core/pull/31614))**

- **[NFC] Remove override of CiviUnitTestCase::runTests
  ([31613](https://github.com/civicrm/civicrm-core/pull/31613))**

- **(NFC) tests/phpunit/api/v4 - Fix inconsistent namespace
  ([31612](https://github.com/civicrm/civicrm-core/pull/31612))**

- **(NFC) Test cases should cleanup HTTP_X_REQUESTED_WITH consistently.
  ([31597](https://github.com/civicrm/civicrm-core/pull/31597))**

- **(NFC) Cast null to string for explode
  ([31659](https://github.com/civicrm/civicrm-core/pull/31659))**

- **Fix test to remove option value in tearDown
  ([31702](https://github.com/civicrm/civicrm-core/pull/31702))**

- **Cleanups in MembershipTest
  ([31679](https://github.com/civicrm/civicrm-core/pull/31679))**

- **Sloppy Test Detector - Add option to complain about test junk
  ([31693](https://github.com/civicrm/civicrm-core/pull/31693))**

- **Civi\Test::execute() - Raise exception for SQL error
  ([31688](https://github.com/civicrm/civicrm-core/pull/31688))**

- **PHPUnit 10 - Various fixes for "E2E" suite
  ([31626](https://github.com/civicrm/civicrm-core/pull/31626))**

- **PHPUnit 10 - Various fix for scheduled-reminder tests (et al)
  ([31627](https://github.com/civicrm/civicrm-core/pull/31627))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; BrightMinded Ltd - Anwen Williams; Benjamin W;
Ben Mango; BrightMinded Ltd - Bradley Taylor; CiviCoop - Jaap Jansma;
CiviCRM - Coleman Watts, Tim Otten; Compuco - Olayiwola Odunsi;
Coop SymbioTIC - Mathieu Lutfy, Shane Bill; Dave D; DevApp - David Cativo;
JMA Consulting - Seamus Lee; Megaphone Technology Consulting - Jon Goldberg;
MJW Consulting - Matthew Wire; Nicol Wistreich; PERORA SRL - Samuele Masetto;
Tadpole Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

All In Appli.com - Guillaume Sorel; ALL IN APPLI admin; Angus Fretwell; Armin
Kathrein; Artful Robot - Rich Lott; Australian Greens - John Twyman;
chaplincircle; Christian Wach; Circle Interactive - Dave Jenkins;
civiservice.de - Detlev Sieber; Daniel Strum; Fuzion - Peter Davis; Guydn;
Humanists UK - Andrew West; JMA Consulting - Monish Deb; Jonny Toomey;
Lemniscus - Noah Miller; Mosier Consulting - Justin Mosier; Robert Garrigos;
Squiffle Consulting - Aidan Saunders; StefanoBrandimarte;
