# CiviCRM 5.81.0

Released January 8, 2025;

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add schema support for bigint
  ([31502](https://github.com/civicrm/civicrm-core/pull/31502))**

  Makes it possible to use the sql type `bigint` in the schema.

- **ContactSummary - Make notes tab hierarchical
  ([31432](https://github.com/civicrm/civicrm-core/pull/31432))**

  Makes the contact summary notes tab a collapsed hierarchical display.

- **allow read-only fields in FormBuilder
  ([30757](https://github.com/civicrm/civicrm-core/pull/30757))**

  Makes it possible to add read-only fields in FormBuilder.

- **Update SavedSearch_Administer_ProfileFields.mgd.php
  ([31509](https://github.com/civicrm/civicrm-core/pull/31509))**

  Makes Field Names inline editable on the Profile fields form for AdminUI
  users.

- **AdminUI - dynamically generate afform tabs for CustomGroups of style Tab
  with table ([31503](https://github.com/civicrm/civicrm-core/pull/31503))**

  Adds a SearchKit and tab for each CustomGroup where style = Tab with table for
  AdminUi users.

- **afform - provide useful console error for invalid fields
  ([31472](https://github.com/civicrm/civicrm-core/pull/31472))**

  It's easy to end up with an invalid field on an afform e.g. when you disable
  a custom field. This makes it easier to find and fix.

- **Update afsearchProfiles.aff.html
  ([31510](https://github.com/civicrm/civicrm-core/pull/31510))**

  Adds an afform search filter 'created by'.

- **Add SearchKit Reports extension
  ([31458](https://github.com/civicrm/civicrm-core/pull/31458))**

  Adds a placement tag to designate certain (search) afforms as "Afform
  Reports". Add a listing for end users to open these reports.

- **SearchKit - Add search templates feature
  ([31528](https://github.com/civicrm/civicrm-core/pull/31528))**

  Adds a new tab for searchkit templates, and a button allowing any existing
  search to be saved as a template.

- **Add APIv4 Contact.getMergedTo/getMergedFrom actions
  ([31336](https://github.com/civicrm/civicrm-core/pull/31336))**

  Adds the APIv4 Contact actions getMergedFrom and getMergedTo. These are the
  APIv4 equivalent of the existing v3 actions.

- **Api4 CustomGroup.get - use in-memory cache to answer simple calls
  ([31508](https://github.com/civicrm/civicrm-core/pull/31508))**

  Performance improvement for the APIv4 custom group entity get action.

### CiviContribute

- **Display Custom Fields on ContributionPage settings
  ([31487](https://github.com/civicrm/civicrm-core/pull/31487) and
  [31533](https://github.com/civicrm/civicrm-core/pull/31533))**

  Adds the display of Custom Fields on ContributionPages.

### Drupal Integration

- **ClassLoader - Fix loading when using composer `path` repository (symlink
  mode) with CLI ([31512](https://github.com/civicrm/civicrm-core/pull/31512))**

  Helps composer-style sites (D8/9/10/11) use composer's path repository option.
  The path option helps you incorporate a local working-copy of the source-code
  into a more complex composer site-build. composer often implements this option
  using symlinks.

### Standalone Integration

- **Standalone login improvements (message/theme/events)
  ([31149](https://github.com/civicrm/civicrm-core/pull/31149))**

  Improves login experience for standalone sites.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **When creating a group in multinlingual CiviCRM, the title is sometimes left
  empty causing a crash upon next insertion
  ([dev/translation#92](https://lab.civicrm.org/dev/translation/-/issues/92):
  [31410](https://github.com/civicrm/civicrm-core/pull/31410))**

- **Can't uncheck "display in table" for custom fields
  ([dev/core#4613](https://lab.civicrm.org/dev/core/-/issues/4613):
  [31493](https://github.com/civicrm/civicrm-core/pull/31493))**

- **System check for extension upgrades doesn't pick up pending upgrades from
  extensions using AutomaticUpgrader
  ([dev/core#5365](https://lab.civicrm.org/dev/core/-/issues/5365):
  [30740](https://github.com/civicrm/civicrm-core/pull/30740))**

- **Advanced Search searching in trash by Activity Type yields no results.
  ([dev/core#5384](https://lab.civicrm.org/dev/core/-/issues/5384):
  [30911](https://github.com/civicrm/civicrm-core/pull/30911))**

- **Generated hash can be numeric breaking is_numeric tests
  ([dev/core#5541](https://lab.civicrm.org/dev/core/-/issues/5541):
  [31330](https://github.com/civicrm/civicrm-core/pull/31330))**

- **Can no longer set image width to 100% in ckeditor
  ([dev/core#5591](https://lab.civicrm.org/dev/core/-/issues/5591):
  [31587](https://github.com/civicrm/civicrm-core/pull/31587))**

- **Core update after upgrade to version > 5.79 can't be proceeded
  ([dev/core#5606](https://lab.civicrm.org/dev/core/-/issues/5606):
  [31581](https://github.com/civicrm/civicrm-core/pull/31581))**

- **Please remove test file regarded as Malware
  ([dev/core#5611](https://lab.civicrm.org/dev/core/-/issues/5611):
  [31498](https://github.com/civicrm/civicrm-core/pull/31498) and
  [31560](https://github.com/civicrm/civicrm-core/pull/31560))**

  Exclude tests and tools directories from exports.

- **Searchkit: condition on row style does not work with date when "now" is
  used: before or after now
  ([dev/core#5172](https://lab.civicrm.org/dev/core/-/issues/5172):
  [30163](https://github.com/civicrm/civicrm-core/pull/30163))**

- **SearchKit - Add option to display linebreaks
  ([dev/core#5565](https://lab.civicrm.org/dev/core/-/issues/5565):
  [31427](https://github.com/civicrm/civicrm-core/pull/31427))**

- **SearchKit - Set acl_bypass=false when cloning a display
  ([31536](https://github.com/civicrm/civicrm-core/pull/31536))**

- **SearchKit: Fix regression rendering relationship custom fields with options
  ([31671](https://github.com/civicrm/civicrm-core/pull/31671))**

- **FormBuilder: conditional using "CONTAINS" fails when option values are
  integers ([dev/core#5622](https://lab.civicrm.org/dev/core/-/issues/5622):
  [31513](https://github.com/civicrm/civicrm-core/pull/31513))**

- **Formbuilder / Event: if the Event Type (or any custom field) is in Display
  only , and I update a field for the event then the event type/ custom field is
  set to void ([dev/core#5473](https://lab.civicrm.org/dev/core/-/issues/5473):
  [31463](https://github.com/civicrm/civicrm-core/pull/31463))**

- **Formbuilder/ Quick add: when quick add is used, the contact subtype (of the
  added contact) set on the contact (FB left panel) is not taken in account
  ([dev/core#5477](https://lab.civicrm.org/dev/core/-/issues/5477):
  [31467](https://github.com/civicrm/civicrm-core/pull/31467))**

- **Formbuilder: entity reference is not displayed as a label (name) when there
  is an initial value and the field setting is "display only"
  ([dev/core#5424](https://lab.civicrm.org/dev/core/-/issues/5424):
  [31462](https://github.com/civicrm/civicrm-core/pull/31462))**

- **[Afform] Process submission error because of empty "name"
  ([31461](https://github.com/civicrm/civicrm-core/pull/31461))**

- **afform - use smarty template to render dynamic custom group block
  ([31481](https://github.com/civicrm/civicrm-core/pull/31481) and
  [31501](https://github.com/civicrm/civicrm-core/pull/31501))**

- **Afform - More accurate check in GUI to see if a field is in-use.
  ([31394](https://github.com/civicrm/civicrm-core/pull/31394))**

  Fixes Afform GUI erroneously not allowing the user to drag fields onto the
  form if they are used by other entities.

- **Afform - Fix check for empty contact values
  ([31464](https://github.com/civicrm/civicrm-core/pull/31464))**

  Fixes a bug where affom was not properly validating a blank contact.

- **FormBuilder - Fix draggy cursor in dropdown menu
  ([31468](https://github.com/civicrm/civicrm-core/pull/31468))**

- **Api4 - Fix CustomField.delete to perform all postprocessing
  ([31570](https://github.com/civicrm/civicrm-core/pull/31570))**

- **Api4 - Case-insensitive matching for arrayQuery entities
  ([31514](https://github.com/civicrm/civicrm-core/pull/31514))**

  Normalizes case-sensitivity across Api4 entities. This also affects Afform
  conditionals, to make the = and != operators case-insensitive.

- **APIv4 - Fix filtering on Route API (etal) using LIKE operator
  ([31524](https://github.com/civicrm/civicrm-core/pull/31524))**

- **Api4 - Allow anonymous access to 'Contact::validateChecksum'
  ([31516](https://github.com/civicrm/civicrm-core/pull/31516))**

- **Add  `\DateTime` and `\Brick\Money\Money` to parameter type hint of
  `TokenRow::tokens()`
  ([31584](https://github.com/civicrm/civicrm-core/pull/31584))**

- **CRM_Utils_System::isSSL - support X_FORWARDED_PROTO to work behind reverse
  proxy ([31473](https://github.com/civicrm/civicrm-core/pull/31473))**

  Fixes incorrect SSL detection when running CiviCRM behind a reverse proxy,
  e.g. with Docker image behind Traefik.

- **Allow 'Expires' placeholder text to be translated
  ([30971](https://github.com/civicrm/civicrm-core/pull/30971))**

- **Perform custom field cascade deletion independent of user's permissions
  ([31519](https://github.com/civicrm/civicrm-core/pull/31519))**

- **delaying crm-ui-select init until the next tick
  ([31544](https://github.com/civicrm/civicrm-core/pull/31544))**

  Addresses a UI glitch when using crm-ui-select on an element with interpolated
  attributes e.g. title="{{inputTitle}}", where the non-interpolated string is
  cloned instead of the interpolated value

- **update deleted files list to fix "old files" status check warning
  ([31645](https://github.com/civicrm/civicrm-core/pull/31645))**

- **Regression: Did not find a valid instance to execute by cron
  ([dev/core#5635](https://lab.civicrm.org/dev/core/-/issues/5635):
  [31624](https://github.com/civicrm/civicrm-core/pull/31624))**

  Ensures Job params are not ignored when job.execute is called.

- **RiverLea 1.2.0-5.81: regression fixes, adds crm-designer.css
  [31598](https://github.com/civicrm/civicrm-core/pull/31598)**

### CiviContribute

- **Premium / thank-you gift choice display is broken
  ([dev/core#5585](https://lab.civicrm.org/dev/core/-/issues/5585):
  [31590](https://github.com/civicrm/civicrm-core/pull/31590) and
  [31594](https://github.com/civicrm/civicrm-core/pull/31594))**

- **IDS Detector is reporting "Impact" 37 for some (not all!) CiviCRM
  Contribution, Thank You pages causing Contributions to be left with Status,
  "Pending (Incomplete Transaction)" and PayPal Standard used for payment
  ([dev/core#2330](https://lab.civicrm.org/dev/core/-/issues/2330):
  [31573](https://github.com/civicrm/civicrm-core/pull/31573))**

  Sometimes PayPal sends data to the IPN endpoint that triggers the IDS. This
  ensures when this happens the payment status is updated correctly.

- **Include tax in total amount
  ([31540](https://github.com/civicrm/civicrm-core/pull/31540))**

- **Clarify completeOrder function status. Remove deprecated call to
  repeatTransaction
  ([31452](https://github.com/civicrm/civicrm-core/pull/31452))**

- **Fix Contribution Receipt empty Receipt From Name causes fallback to site
  default even if Receipt From Email set.
  ([31475](https://github.com/civicrm/civicrm-core/pull/31475))**

### CiviMail

- **SMS messages incorrectly contain header and footer
  ([dev/core#5626](https://lab.civicrm.org/dev/core/-/issues/5626):
  [31555](https://github.com/civicrm/civicrm-core/pull/31555))**

### Backdrop Integration

- **Move civicrmtheme module functionality into main module
  ([dev/backdrop#88](https://lab.civicrm.org/dev/backdrop/-/issues/88):
  [31470](https://github.com/civicrm/civicrm-core/pull/31470))**

## <a name="misc"></a>Miscellany

- **[backport] Riverlea dark mode default
  [31643](https://github.com/civicrm/civicrm-core/pull/31643)**

- **Standaloneusers - split the public and private bits of
  User.SendPasswordReset into separate actions
  ([31556](https://github.com/civicrm/civicrm-core/pull/31556))**

- **Navigation - Simplify form code, separate paths
  ([31521](https://github.com/civicrm/civicrm-core/pull/31521))**

- **Fix Mail settings form to use metadata
  ([31454](https://github.com/civicrm/civicrm-core/pull/31454))**

- **CustomValueTable - Simplify conditionals
  ([31448](https://github.com/civicrm/civicrm-core/pull/31448))**

- **Copy functions back to only caller, deprecate old versions, clean up & fix
  undefined property
  ([31385](https://github.com/civicrm/civicrm-core/pull/31385))**

- **Change contributor name
  ([31507](https://github.com/civicrm/civicrm-core/pull/31507))**

- **Normalize and sort SYSTOPIA contributor info
  ([31471](https://github.com/civicrm/civicrm-core/pull/31471))**

- **Remove unused .toxic.json
  ([31500](https://github.com/civicrm/civicrm-core/pull/31500))**

- **Remove generation of localized l10n files, not used by the new installer
  ([29308](https://github.com/civicrm/civicrm-core/pull/29308))**

- **Remove unreachable code in CRM_Report_Form_Mailing_Summary
  ([31554](https://github.com/civicrm/civicrm-core/pull/31554))**

- **Remove `buildPremiumBlock` function noisiy deprecated in 5.69, no universe
  callers ([31541](https://github.com/civicrm/civicrm-core/pull/31541))**

- **[REF] Remove redundant uf templates
  ([31109](https://github.com/civicrm/civicrm-core/pull/31109))**

- **[REF] Make datepicker element and actions accessible if label is defined but
  associated directly like in report filter
  ([30693](https://github.com/civicrm/civicrm-core/pull/30693))**

- **[REF][PHP8.2] Declare properies in CRM_Contact_Page_View_GroupContact
  ([31550](https://github.com/civicrm/civicrm-core/pull/31550))**

- **[REF][PHP8.2] Declare missing properties: CRM_Admin_Form_MessageTemplates
  ([31552](https://github.com/civicrm/civicrm-core/pull/31552))**

- **[REF][PHP8.2] Declare missing properties: CRM_Event_Form_Task_Batch
  ([31553](https://github.com/civicrm/civicrm-core/pull/31553))**

- **[REF][PHP8.2] Declare _mailingID property
  ([31551](https://github.com/civicrm/civicrm-core/pull/31551))**

- **(NFC) Improve comment on CIVICRM_CONTAINER_CACHE
  ([31549](https://github.com/civicrm/civicrm-core/pull/31549))**

- **(NFC) Test cases should cleanup HTTP_X_REQUESTED_WITH consistently.
  ([31609](https://github.com/civicrm/civicrm-core/pull/31609))**

- **[NFC] first pass at 5.81 release notes
  ([31615](https://github.com/civicrm/civicrm-core/pull/31615))**

- **FieldsCallbackTest - Behave more consistently
  ([31616](https://github.com/civicrm/civicrm-core/pull/31616))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; ALL IN APPLI admin; Artful Robot - Rich Lott;
Australian Greens - John Twyman; Benjamin W; BrightMinded Ltd - Bradley Taylor;
Christian Wach; CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu
Lutfy, Samuel Vanhove; Dave D; DevApp - David Cativo; forumZFD - Marc Michalsky;
Fuzion - Luke Stewart; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; Outlandish - Rasmus Winter; Squiffle Consulting - Aidan
Saunders; Stephen Palmstrom; Tadpole Collective - Kevin Cristiano; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

civiservice.de - Detlev Sieber; Daniel Strum; Guydn; Lemniscus - Noah Miller
