# CiviCRM 5.78.0

Released October 2, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Only display address custom fields when populated on contact summary view
  ([dev/core#5393](https://lab.civicrm.org/dev/core/-/issues/5393):
  [30981](https://github.com/civicrm/civicrm-core/pull/30981))**

  Adds support to view custom fields for email blocks on the contact summary in
  a way that should be easily extendable to other location blocks (phone seems
  worth doing, unsure about the others).

- **Add ability to edit email custom data to Email inline edit
  ([30843](https://github.com/civicrm/civicrm-core/pull/30843))**

  Adds the ability to edit email custom data to email inline edit.

- **SearchKit - Support joins from DB Entity Displays (using EntityRepository
  for metadata) ([30671](https://github.com/civicrm/civicrm-core/pull/30671))**

  Allows joins to be performed on Entity-type displays in SearchKit.

- **SearchKit - Add entity_permission setting for entity displays
  ([30816](https://github.com/civicrm/civicrm-core/pull/30816))**

  Makes the permission level for SearchKit entities configurable.

- **SearchKit - Refresh entity list after saving a DB entity display
  ([30880](https://github.com/civicrm/civicrm-core/pull/30880))**

  Adds a live-update feature so a newly saved db entity can be used immediately
  without a page refresh.

- **Formbuilder/ event tab: Add the possibility to create or select a location
  ([dev/core#5053](https://lab.civicrm.org/dev/core/-/issues/5053):
  [30140](https://github.com/civicrm/civicrm-core/pull/30140))**

  Adds the ability to create or select a location for an event to FormBuilder.

- **AfformScanner - Allow altering search paths with internal event
  ([30817](https://github.com/civicrm/civicrm-core/pull/30817))**

  Makes it possible to add/remove/prioritize Afform folders.

- **Make Afform available in SK
  ([30994](https://github.com/civicrm/civicrm-core/pull/30994))**

  Makes the Afform entity available in SearchKit.

- **Migrate installers to "setup" API
  ([dev/core#1615](https://lab.civicrm.org/dev/core/-/issues/1615):
  [182](https://github.com/civicrm/civicrm-backdrop/pull/182),
  [30946](https://github.com/civicrm/civicrm-core/pull/30946) and
  [29307](https://github.com/civicrm/civicrm-core/pull/29307))**

  Work Towards moving all installers use a PHP API for CiviCRM installation.

- **Call new 'civi.core.clearcache' event on CRM_Utils_System:flushCache()
  ([30595](https://github.com/civicrm/civicrm-core/pull/30595))**

  Adds an event when CiviCRM cache is cleared.

- **Move Contact Delete under the Actions menu
  ([dev/user-interface#54](https://lab.civicrm.org/dev/user-interface/-/issues/54):
  [30967](https://github.com/civicrm/civicrm-core/pull/30967))**

  Improves user experience on the contact summary by moving the delete contact
  action into the action menu.

- **Tell me which entity when silently ignoring it on form submission
  ([31047](https://github.com/civicrm/civicrm-core/pull/31047))**

  Slightly more helpful "silent" exception message when a parameter is missing
  on form submission.

- **Change the default font family to sans-serif in print.css
  ([dev/core#3769](https://lab.civicrm.org/dev/core/-/issues/3769):
  [30945](https://github.com/civicrm/civicrm-core/pull/30945))**

  Improves user experience by setting the default font-family in the print.css
  to sans-serif.

- **CiviCRM Dedupe Rules, default rules are incorrectly labelled as "and" when
  each rule is actually "or" eg. "Name and Email" should be "Name OR Email".
  Use of Name is ambiguous. Add "Nickname" to default Organisation dedupe rules
  ([dev/core#2357](https://lab.civicrm.org/dev/core/-/issues/2357):
  [30841](https://github.com/civicrm/civicrm-core/pull/30841),
  [31003](https://github.com/civicrm/civicrm-core/pull/31003) and
  [31019](https://github.com/civicrm/civicrm-core/pull/31019))**

  Improves clarity of Dedupe rule names.

- **Pseudoconstant - Improve location type option lookups
  ([31023](https://github.com/civicrm/civicrm-core/pull/31023))**

  Adds richer metadata, and switches to preferred method of retrieving it.

- **Use Smarty5 by default on new installs
  ([30921](https://github.com/civicrm/civicrm-core/pull/30921))**

  Sets new installs to use Smarty5 by default.

- **Api4 Explorer - Document new 2nd param to column() function
  ([30814](https://github.com/civicrm/civicrm-core/pull/30814))**

  Documents new function param in the Api Explorer.

- **Update SavedSearch_Manage_Mail_Accounts.mgd.php
  ([30669](https://github.com/civicrm/civicrm-core/pull/30669))**

  Adds the option 'editable' => TRUE, to most fields to offer inline editing
  when needing to update mail accounts.

- **Installation UI: Aligns header block, matches h1 colour.
  ([30845](https://github.com/civicrm/civicrm-core/pull/30845))**

  Improves installation user interface styling.

- **Add chart_kit to core extensions directory
  ([30797](https://github.com/civicrm/civicrm-core/pull/30797))**

  Adds the chart_kit extension (as developed at
  https://lab.civicrm.org/ufundo/chart_kit/ ) to the core extensions directory.

- **civimix-schema: Define backportable DAO class
  ([30558](https://github.com/civicrm/civicrm-core/pull/30558))**

  Defines a variation on CRM_Core_DAO_Base which is suitable for backports.

- **Use usage to determine which contact fields can be imported for contribution
  import ([31004](https://github.com/civicrm/civicrm-core/pull/31004) and
  [30930](https://github.com/civicrm/civicrm-core/pull/30930))**

  Starts using `usage` to determine which contact fields can be
  used in a contribution import and which fields should be available when
  creating dedupe rules.

- **EntityRepository - The new canonical source for metadata & CRUD
  (Work towards [dev/core#5410](https://lab.civicrm.org/dev/core/-/issues/5410):
  [30964](https://github.com/civicrm/civicrm-core/pull/30964))**

  Adds a new core entity function & moves some Api4 logic a layer down into the
  EntityRepository.

- **PHP 8.4 compatibility (Work towards
  [dev/core#5409](https://lab.civicrm.org/dev/core/-/issues/5409):
  [30939](https://github.com/civicrm/civicrm-core/pull/30939) and
  [412](https://github.com/civicrm/civicrm-packages/pull/412))**

  Updates Brick Money/Math and Smarty to be compatible with php8.4.


- **Increment min recommended & recommended php versions
  ([30885](https://github.com/civicrm/civicrm-core/pull/30885))**

  Messages to php 8.0 users, recommending php 8.3.

### CiviEvent

- **Add option to enable payment on confirmation for all multi-participant
  events ([30759](https://github.com/civicrm/civicrm-core/pull/30759))**

  Adds an additional option "all multi-participant" to the "Show Event Payment
  on Confirm?" setting that moves the payment to the confirmation page on event
  registration.

- **Improve UX for "Print Name Badges" and "PDF letter - print for participant"
  ([30625](https://github.com/civicrm/civicrm-core/pull/30625))**

  Adds actions to "Print Name Badges" and "PDF letter - print for participant"
  to the Contact Summary Event tab and View Participant.

### Standalone Integration

- **UI to configure auto logout for Standalone
  ([dev/core#5390](https://lab.civicrm.org/dev/core/-/issues/5390):
  [30900](https://github.com/civicrm/civicrm-core/pull/30900) and
  [30951](https://github.com/civicrm/civicrm-core/pull/30951))**

  Enables a UI setting for admins to configure auto logout.

- **Standalone installation UI: matches confirmation page fonts & panel with
  pre-install page ([30844](https://github.com/civicrm/civicrm-core/pull/30844))**

  Improves styling during the installation process for standalone sites.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **The dreaded afform scanner not found
  ([dev/core#4267](https://lab.civicrm.org/dev/core/-/issues/4267):
  [31045](https://github.com/civicrm/civicrm-core/pull/31045))**

  Simplifies registration of afform scanner service.

- **Formbuilder: It is not possible to modify a location in the Existing
  location field for an event (creation or update)
  ([dev/core#5465](https://lab.civicrm.org/dev/core/-/issues/5465):
  [31167](https://github.com/civicrm/civicrm-core/pull/31167) and
  [31186](https://github.com/civicrm/civicrm-core/pull/31186))**

- **Formbuilder: Not possible to set an autocomplete search on contacts
  (organisation, individual), regression
  ([dev/core#5492](https://lab.civicrm.org/dev/core/-/issues/5492):
  [31196](https://github.com/civicrm/civicrm-core/pull/31196))**

- **Formbuilder: Breaks if brackets are present
  ([dev/core#5234](https://lab.civicrm.org/dev/core/-/issues/5234):
  [30918](https://github.com/civicrm/civicrm-core/pull/30918))**

  Fixes a bug where the afform editor breaks when the title starts with a
  bracket.

- **SearchKit - Fix creating smart group from Individual/Organization/Household
  base entity ([31208](https://github.com/civicrm/civicrm-core/pull/31208))**

- **Standardize Reply-To between singleEmail and flexmailer for
  `alterMailParams` hook
  ([dev/core#5301](https://lab.civicrm.org/dev/core/-/issues/5301):
  [30491](https://github.com/civicrm/civicrm-core/pull/30491))**

   Standardizes the `alterMailParams` reply-to to allow Reply-To and From to be
   set directly.

- **Remove logging on DB Entity tables
  ([dev/core#5388](https://lab.civicrm.org/dev/core/-/issues/5388):
  [30868](https://github.com/civicrm/civicrm-core/pull/30868))**

- **Configuration Checklist - Organisation Contact Record crashes with error
  ([dev/core#5405](https://lab.civicrm.org/dev/core/-/issues/5405):
  [30952](https://github.com/civicrm/civicrm-core/pull/30952))**

- **Dedupe help bubble broken on contact import
  ([dev/core#5438](https://lab.civicrm.org/dev/core/-/issues/5438):
  [31057](https://github.com/civicrm/civicrm-core/pull/31057))**

- **Can't update an import mapping when the import file has more columns than
  the saved mapping
  ([dev/core#5443](https://lab.civicrm.org/dev/core/-/issues/5443):
  [31065](https://github.com/civicrm/civicrm-core/pull/31065))**

- **Job log not showing the date column anymore
  ([dev/core#5459](https://lab.civicrm.org/dev/core/-/issues/5459):
  [31104](https://github.com/civicrm/civicrm-core/pull/31104))**

- **FormBuilder: afform date field required attribute
  ([31028](https://github.com/civicrm/civicrm-core/pull/31028))**

- **SearchKit - Include unconditional style rules in table header
  ([31016](https://github.com/civicrm/civicrm-core/pull/31016))**

- **Remove blank place holders for text versions of messages
  ([31037](https://github.com/civicrm/civicrm-core/pull/31037))**

- **Use old, unused, code on advanced setting form (Profiles)
  ([31022](https://github.com/civicrm/civicrm-core/pull/31022))**

  Fixes dynamic property deprecation notices (PHP 8.2+) on the Profiles ->
  advanced settings form.

- **dompdf - Abide by configurable path to "upload" dir
  ([31015](https://github.com/civicrm/civicrm-core/pull/31015))**

- **enable quick search using nickname if configured
  ([30972](https://github.com/civicrm/civicrm-core/pull/30972))**

- **Less opinionated nav menu editor styling => dark mode compatible
  ([30956](https://github.com/civicrm/civicrm-core/pull/30956))**

- **Follow up to #30415 - restrict permissions on Price Set Editing page
  ([30741](https://github.com/civicrm/civicrm-core/pull/30741))**

- **Change button type to upload to upload files
  ([30948](https://github.com/civicrm/civicrm-core/pull/30948))**

- **Update CRM_Core_Resources::isAjaxMode to handle more ajax paths
  ([30910](https://github.com/civicrm/civicrm-core/pull/30910))**

- **APIv4 - Ensure custom fields are always correctly serialized (with cleanup)
  ([30728](https://github.com/civicrm/civicrm-core/pull/30728))**  

- **provide correct collation to SK entities
  ([30850](https://github.com/civicrm/civicrm-core/pull/30850))**

- **Add nofilter to templates for avoiding default escaping
  ([30567](https://github.com/civicrm/civicrm-core/pull/30567))**

- **Remove default escaping for Smarty2
  ([30832](https://github.com/civicrm/civicrm-core/pull/30832))**

- **Update CRM_Core_Smarty::escape not to call smarty function
  ([30566](https://github.com/civicrm/civicrm-core/pull/30566))**

- **Switch contribution search to use Smarty5 nofilter not older`
  smarty:nodefaults`
  ([30982](https://github.com/civicrm/civicrm-core/pull/30982))**

- **Fix a few more smarty:nodefaults to use nofilter
  ([31014](https://github.com/civicrm/civicrm-core/pull/31014))**

- **Ensure CKEditor config screen loads with Smarty 5
  ([31018](https://github.com/civicrm/civicrm-core/pull/31018))**

- **Accesskey help does not work on Smarty5
  ([dev/core#5439](https://lab.civicrm.org/dev/core/-/issues/5439):
  [31146](https://github.com/civicrm/civicrm-core/pull/31146))**

- **smarty5 - implode is deprecated
  ([30934](https://github.com/civicrm/civicrm-core/pull/30934))**

- **Allow enabling smarty escape by default with Smarty5
  ([409](https://github.com/civicrm/civicrm-packages/pull/409))**

- **Fix smarty notice in tpl
  ([30983](https://github.com/civicrm/civicrm-core/pull/30983))**

- **Load Smarty4 instead of Smarty3 where upgraded off Smarty2, Remove Smarty3
  ([30923](https://github.com/civicrm/civicrm-core/pull/30923) and
  [414](https://github.com/civicrm/civicrm-packages/pull/414))**

- **Fix saving entity display with money calculated field
  ([30879](https://github.com/civicrm/civicrm-core/pull/30879))**

- **avoid openlayers error: string literal contains an unescaped line break
  ([30754](https://github.com/civicrm/civicrm-core/pull/30754))**

- **distmaker - Stop trying to bundle SQL files
  ([30925](https://github.com/civicrm/civicrm-core/pull/30925))**

- **distmaker - My eyes! My eyes are bleeding! Make it stop!
  ([30905](https://github.com/civicrm/civicrm-core/pull/30905))**

  Reduces the amount of content generated by distmaker.

- **Revert "Add deprecation notice to hook_civicrm_links used by search forms"
  ([30941](https://github.com/civicrm/civicrm-core/pull/30941))**

- **Afform - hacky fix for select2 failing to update chainselect value
  ([31031](https://github.com/civicrm/civicrm-core/pull/31031))**

- **Afform - Fix autofill-current-user
  ([31030](https://github.com/civicrm/civicrm-core/pull/31030))**

- **Only run buildSubTypes ajax call if contact type is set
  ([30963](https://github.com/civicrm/civicrm-core/pull/30963))**

- **Can't save an empty Contact Reference
  ([30985](https://github.com/civicrm/civicrm-core/pull/30985))**

- **[PHP8.x] Ensure value is a string (not NULL) before passing to trim
  ([30858](https://github.com/civicrm/civicrm-core/pull/30858))**

- **[PHP8.4] Don't implicitly mark params as null
  ([30960](https://github.com/civicrm/civicrm-core/pull/30960))**

- **Remove unpassed variables for function with 1 universe caller
  ([31013](https://github.com/civicrm/civicrm-core/pull/31013))**

- **Notice fixes
  ([30859](https://github.com/civicrm/civicrm-core/pull/30859))**

- **Always restore error handler when extension download glitches, a.k.a. avoid
  intermittent test fails
  ([31068](https://github.com/civicrm/civicrm-core/pull/31068))**

- **Settings form tidy-ups (apiv3-v4,  `CRM_Utils_Array::value()`, save integers
  as integers) ([30820](https://github.com/civicrm/civicrm-core/pull/30820))**

- **Stop returning unused array, remove unused function
  ([30863](https://github.com/civicrm/civicrm-core/pull/30863))**

- **Fix typo.
  ([181](https://github.com/civicrm/civicrm-backdrop/pull/181))**

- **Extra bracket showing in custom field label on search screen
  ([31131](https://github.com/civicrm/civicrm-core/pull/31131))**

- **Job log not showing the date column anymore
  ([dev/core#5459](https://lab.civicrm.org/dev/core/-/issues/5459):
  [31158](https://github.com/civicrm/civicrm-core/pull/31158) and
  [31171](https://github.com/civicrm/civicrm-core/pull/31171))**

### CiviContribute

- **Admin-only price fields displayed to all users
  ([dev/core#5440](https://lab.civicrm.org/dev/core/-/issues/5440):
  [31087](https://github.com/civicrm/civicrm-core/pull/31087))**

- **Incorrect Currency format in receipts
  ([dev/core#5332](https://lab.civicrm.org/dev/core/-/issues/5332):
  [30622](https://github.com/civicrm/civicrm-core/pull/30622))**

- **Financial ACLs broken in 5.75+ when a line item with no contribution ID
  exists ([31176](https://github.com/civicrm/civicrm-core/pull/31176))**

- **Online contribution receipt when there's a soft credit always shows
  pcp/honor roll section even when no pcp pages or blocks exist
  ([dev/core#5335](https://lab.civicrm.org/dev/core/-/issues/5335):
  [30628](https://github.com/civicrm/civicrm-core/pull/30628))**

- **Empty tax term on front end donation form
  ([dev/financial#224](https://lab.civicrm.org/dev/financial/-/issues/224):
  [31055](https://github.com/civicrm/civicrm-core/pull/31055))**

- **Fix incorrect CSS in contribution invoice template
  ([30944](https://github.com/civicrm/civicrm-core/pull/30944))**

- **Add update link for pcp
  ([30894](https://github.com/civicrm/civicrm-core/pull/30894))**

### CiviEvent

- **Event Info: copy the checksum to the registerURL
  ([30998](https://github.com/civicrm/civicrm-core/pull/30998))**

- **Backend event registration crashes. Also on contact's events tab and on
  view/edit participant.
  ([dev/core#5447](https://lab.civicrm.org/dev/core/-/issues/5447):
  [31069](https://github.com/civicrm/civicrm-core/pull/31069))**

- **EventCart - Remove setting, unhide extension, uninstall if unused
  ([31033](https://github.com/civicrm/civicrm-core/pull/31033))**

  Completely decouples the eventcart extension from core.

- **EventCart - Move 'Pending in cart' status to extension
  ([31007](https://github.com/civicrm/civicrm-core/pull/31007))**

  Moves a participant status type out of core and into the event cart
  extension where it belongs.

### CiviGrant

- **prevent grant dashboard URLs leading to data loss
  ([30830](https://github.com/civicrm/civicrm-core/pull/30830))**

### CiviMail

- **Mailings are (unvisibly) sent to deactivated groups
  ([dev/core#5336](https://lab.civicrm.org/dev/core/-/issues/5336):
  [30798](https://github.com/civicrm/civicrm-core/pull/30798))**

- **Unwind legacy flexmailer hack of specifying functions in a define
  ([30889](https://github.com/civicrm/civicrm-core/pull/30889))**

### CiviMember

- **Fix translation for relationship types on Membership View page
  ([dev/core#5386](https://lab.civicrm.org/dev/core/-/issues/5386):
  [30838](https://github.com/civicrm/civicrm-core/pull/30838))**

### Backdrop Integration

- **ensure we get correct resourceurl in backdrop
  ([30735](https://github.com/civicrm/civicrm-core/pull/30735))**

### Drupal Integration

- **Remove event_cart link from Drupal7 Views
  ([684](https://github.com/civicrm/civicrm-drupal/pull/684))**

- **Setup UI - Restore icons (FontAwesome 6 support)
  ([685](https://github.com/civicrm/civicrm-drupal/pull/685))**

- **Update font awesome URL for installer page to V6
  ([683](https://github.com/civicrm/civicrm-drupal/pull/683))**

- **civicrm.drush.inc - Drop "civicrm-install" (based on old installer)
  ([99](https://github.com/civicrm/civicrm-drupal-8/pull/99))**

### Standalone Integration

- **Standalone installer fails with "unknown entity UserRole"
  ([dev/core#5403](https://lab.civicrm.org/dev/core/-/issues/5403):
  [30913](https://github.com/civicrm/civicrm-core/pull/30913))**

- **Standalone: When adding contributions & activities, time is set to UTC but
  should be BST (British Summer Time) which is UTC+1
  ([dev/core#5392](https://lab.civicrm.org/dev/core/-/issues/5392):
  [30887](https://github.com/civicrm/civicrm-core/pull/30887))**

### WordPress Integration

- **Formbuilder: Event Dates (start, end) are not recognized as "dates"
  (regression) on wpmaster
  ([dev/core#5416](https://lab.civicrm.org/dev/core/-/issues/5416):
  [31111](https://github.com/civicrm/civicrm-core/pull/31111))**

- **Shortcodes outside content are never pre-rendered
  ([329](https://github.com/civicrm/civicrm-wordpress/pull/329))**

## <a name="misc"></a>Miscellany

- **Use latest `civicrm/*` composer packages - ie the ones @totten wrote
  ([30975](https://github.com/civicrm/civicrm-core/pull/30975))**

- **Update guzzle (7.6.1 => 7.9.2)
  ([30929](https://github.com/civicrm/civicrm-core/pull/30929))**

- **Update symfony from 4.x to 5.x
  ([30999](https://github.com/civicrm/civicrm-core/pull/30999))**

- **php 8.4 Update phpword  0.18.3 to 1.2.0
  ([30959](https://github.com/civicrm/civicrm-core/pull/30959))**

- **Symfony update 5.4.43 (from recent update to 5.4.42 but now .43 is out)
  ([31034](https://github.com/civicrm/civicrm-core/pull/31034))**

- **Update distmaker for flat standalone tarball
  ([30835](https://github.com/civicrm/civicrm-core/pull/30835))**

- **Update zeta-components/mail (1.9.4->1.9.6) & zeta-components/base
  (19.3->1.9.4) ([30931](https://github.com/civicrm/civicrm-core/pull/30931))**

- **Update zeta components/mail to 1.9.7
  ([30933](https://github.com/civicrm/civicrm-core/pull/30933))**

- **Update Select2 library to latest tagged version
  ([31009](https://github.com/civicrm/civicrm-core/pull/31009))**

- **Update php spreadsheet to latest 1.x version (1.18.0 => 1.29.0)
  ([31010](https://github.com/civicrm/civicrm-core/pull/31010))**

- **Pseudoconstant - Use preferred lookup function
  ([31024](https://github.com/civicrm/civicrm-core/pull/31024))**

- **Pseudoconstant - Switch to buildOptions
  ([31021](https://github.com/civicrm/civicrm-core/pull/31021))**

- **APIv3 - Move legacy Api3 code out of the BAO and into Api3
  ([30987](https://github.com/civicrm/civicrm-core/pull/30987))**

- **Fix object type in comment
  ([30853](https://github.com/civicrm/civicrm-core/pull/30853))**

- **Extract the custom data template part for the address
  ([30848](https://github.com/civicrm/civicrm-core/pull/30848))**

- **Extract lines to add Address custom data to view
  ([30849](https://github.com/civicrm/civicrm-core/pull/30849))**

- **DAO - Deprecate unused getOptionLabels function
  ([30988](https://github.com/civicrm/civicrm-core/pull/30988))**

- **Add deprecation notices to a couple more token functions with no
  undeprecated core callers
  ([30888](https://github.com/civicrm/civicrm-core/pull/30888))**

- **Stop trying to read undefined oplock_ts in templates
  ([30966](https://github.com/civicrm/civicrm-core/pull/30966))**

- **Deprecate tokenIsFound check
  ([30891](https://github.com/civicrm/civicrm-core/pull/30891))**

- **Deprecate unused token function
  ([30908](https://github.com/civicrm/civicrm-core/pull/30908))**

- **Comment fix ([30937](https://github.com/civicrm/civicrm-core/pull/30937))**

- **Add some noise to legacy callers of tokenValues, tokens
  ([30940](https://github.com/civicrm/civicrm-core/pull/30940))**

- **Extract code to get the relevant mailing_id
  ([30870](https://github.com/civicrm/civicrm-core/pull/30870))**

- **Add type hints, comment fix to `createIndexes()`
  ([30936](https://github.com/civicrm/civicrm-core/pull/30936))**

- **sweep away an old TODO
  ([30955](https://github.com/civicrm/civicrm-core/pull/30955))**

- **Update deleted files list
  ([30942](https://github.com/civicrm/civicrm-core/pull/30942))**

- **Stop calculating unused variable
  ([30916](https://github.com/civicrm/civicrm-core/pull/30916))**

- **Determine instance more transparently
  ([30812](https://github.com/civicrm/civicrm-core/pull/30812))**

- **EntityTag - Remove unneeded legacy formatting of entity_table options
  ([30996](https://github.com/civicrm/civicrm-core/pull/30996))**

- **standalone: remove unused css vars, tweak standalone-specific css to use
  Riverlea vars ([30958](https://github.com/civicrm/civicrm-core/pull/30958))**

- **Remove unused private function
  ([30855](https://github.com/civicrm/civicrm-core/pull/30855))**

- **Remove function with noisy deprecation since 2022: replaceCaseTokens
  ([30864](https://github.com/civicrm/civicrm-core/pull/30864))**

- **Remove legacy handling for Joomla not supporting permissions
  ([30893](https://github.com/civicrm/civicrm-core/pull/30893))**

- **Remove deprecated hook_civicrm_customFieldOptions
  ([30970](https://github.com/civicrm/civicrm-core/pull/30970))**

- **Tidy: removes an empty css file and six unreferenced images from the css
  directory ([30786](https://github.com/civicrm/civicrm-core/pull/30786))**

- **Remove unused deprecated token function
  ([30909](https://github.com/civicrm/civicrm-core/pull/30909))**

- **Remove unreachable code.
  ([30890](https://github.com/civicrm/civicrm-core/pull/30890))**

- **Remove unreachable copy & paste code
  ([30871](https://github.com/civicrm/civicrm-core/pull/30871))**

- **Stop passing unused variables not in the function signature
  ([30851](https://github.com/civicrm/civicrm-core/pull/30851))**

- **Remove unreachable code
  ([30861](https://github.com/civicrm/civicrm-core/pull/30861))**

- **Remove use of createAPIError (gets swallowed in php8.x
  ([30978](https://github.com/civicrm/civicrm-core/pull/30978))**

- **Remove unused pass-by-ref
  ([30980](https://github.com/civicrm/civicrm-core/pull/30980))**

- **Remove unused functions
  ([30886](https://github.com/civicrm/civicrm-core/pull/30886))**

- **Remove function whose only remaining caller is itself
  ([30892](https://github.com/civicrm/civicrm-core/pull/30892))**

- **Update contributor-key.yml
  ([30822](https://github.com/civicrm/civicrm-core/pull/30822))**

- **Switch to less-deprecated buildOptions function
  ([686](https://github.com/civicrm/civicrm-drupal/pull/686))**

- **regen + deleted files update (should go into 5.78)
  ([31041](https://github.com/civicrm/civicrm-core/pull/31041))**

- **Refactor Standalone-specific steps in CRM_Core_Config into a userSystem
  function ([30901](https://github.com/civicrm/civicrm-core/pull/30901))**

- **REF: Membership renewal form: Simplify pending check
  ([30775](https://github.com/civicrm/civicrm-core/pull/30775))**

- **[REF] Extract the chunk of code that gets the custom data to disply for each
  field ([30979](https://github.com/civicrm/civicrm-core/pull/30979))**

- **[REF] Ensure that if original id is passed to hook::copy it is dispatched to
  hook invocation / listeners
  ([31038](https://github.com/civicrm/civicrm-core/pull/31038))**

- **[REF] Standardise is_bulk_mail select
  ([30813](https://github.com/civicrm/civicrm-core/pull/30813))**

- **[REF] Fix empty headers in schedule reminders and dedupe rules page
  ([30729](https://github.com/civicrm/civicrm-core/pull/30729))**

- **(REF) distmaker - Generate live list of core extensions
  ([30876](https://github.com/civicrm/civicrm-core/pull/30876))**

- **[REF] Fix Screen reader accessibility of attachment fields
  ([30690](https://github.com/civicrm/civicrm-core/pull/30690))**

- **[REF] Allow System Admins to override the file permissions set by Pear Log
  package for ConfigAndLog Files
  ([30927](https://github.com/civicrm/civicrm-core/pull/30927))**

- **[REF] Assign values to variables before the loop, prepare extraction
  ([30977](https://github.com/civicrm/civicrm-core/pull/30977))**

- **[REF] Output of running npm audit fix
  ([31185](https://github.com/civicrm/civicrm-core/pull/31185))**

- **[REF] Add in standalone urls for restore from trash and delete permanently
  tasks and modify class as needed to allow the actions in search kit
  ([30874](https://github.com/civicrm/civicrm-core/pull/30874))**

- **[REF][PHP8.2] Fix deprecated property on CRM_Contact_Page_View_Log
  ([30961](https://github.com/civicrm/civicrm-core/pull/30961))**

- **[REF][PHP8.2] Declare parentID property
  ([30965](https://github.com/civicrm/civicrm-core/pull/30965))**

- **(NFC) testHttpUnsubscribe - Add more comments
  ([31054](https://github.com/civicrm/civicrm-core/pull/31054))**

- **(NFC) Drop old comments about old installer
  ([30997](https://github.com/civicrm/civicrm-core/pull/30997))**

- **[NFC] CRM_Contact_Page_View: Remove unused dashboardURL variable
  ([30968](https://github.com/civicrm/civicrm-core/pull/30968))**

- **[NFC] Fix typo in function description
  ([30914](https://github.com/civicrm/civicrm-core/pull/30914))**

- **[NFC] Add test to demonstrate error passing in empty array for checkbox and
  select custom fields
  ([30743](https://github.com/civicrm/civicrm-core/pull/30743))**

- **[NFC] Label test update to allow more tests to be added
  ([30854](https://github.com/civicrm/civicrm-core/pull/30854))**

- **[NFC] 5.77 release notes late changes
  ([31039](https://github.com/civicrm/civicrm-core/pull/31039))**

- **[NFC] first pass at 5.78 release notes
  ([31195](https://github.com/civicrm/civicrm-core/pull/31195))**

- **Fix LabelTest to use full form flow
  ([30852](https://github.com/civicrm/civicrm-core/pull/30852))**

- **Add test for groups assigned to unsubscribe, minor clean up
  ([30869](https://github.com/civicrm/civicrm-core/pull/30869))**

- **ActivityTest - Update to pass on Standalone
  ([31002](https://github.com/civicrm/civicrm-core/pull/31002))**

- **Add tests for tokens & address merge in label test
  ([30860](https://github.com/civicrm/civicrm-core/pull/30860))**

- **Add unit test for token rendering in Labels
  ([30857](https://github.com/civicrm/civicrm-core/pull/30857))**

- **Stop passing value to unused function within tests
  ([30865](https://github.com/civicrm/civicrm-core/pull/30865))**

- **Backdrop - Fix MockPublicFormTest.  Ensure session is committed during
  redirect. ([30831](https://github.com/civicrm/civicrm-core/pull/30831))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; ALL IN APPLI admin;
Artful Robot - Rich Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor; CEDC -
Laryn Kragt Bakker; Christian Wach; Circle Interactive - Pradeep Nayak;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; civiservice.de -
Gerhard Weber; Coop SymbioTIC - Mathieu Lutfy; Dave D; DevApp - David Cativo;
Francesc Bassas i Bullich; Freeform Solutions - Herb van den Dool; Fuzion -
Jitendra Purohit, Luke Stewart; iXiam - Luciano Spiegel; JMA Consulting - Monish
Deb, Seamus Lee; Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich; Progressive Technology
Project - Jamie McClelland; Third Sector Design - William Mortada; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Andy Clark;  Guydn; Jade Gaunt; JMA Consulting - Joe Murray; Mosier Consulting -
Justin Mosier; Richard Baugh; Skvare - Mark Hanna; Tadpole Collective - Kevin
Cristiano; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
