# CiviCRM 5.77.0

Released September 4, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **SearchKit - Set column autosize for spreadsheet downloads
  ([30712](https://github.com/civicrm/civicrm-core/pull/30712))**

  When a spreadsheet is downloaded from a searchkit interface, sets the column
  to autosize to make it easier to read.

- **SearchKit - Selectable date formats
  ([30703](https://github.com/civicrm/civicrm-core/pull/30703))**

  Allows the date format to be selected on a search display.

- **Afform: Date field - Allow to hide time
  ([dev/core#5246](https://lab.civicrm.org/dev/core/-/issues/5246):
  [30700](https://github.com/civicrm/civicrm-core/pull/30700))**

  Allow hiding of time on for date fields on Afforms.

- **FormBuilder - group subscription support
  ([30778](https://github.com/civicrm/civicrm-core/pull/30778) and
  [30706](https://github.com/civicrm/civicrm-core/pull/30706))**

  Add groups support for Form Builder.

- **Add missing provinces for Moldova
  ([30782](https://github.com/civicrm/civicrm-core/pull/30782) and
  [30799](https://github.com/civicrm/civicrm-core/pull/30799))**

  Updates Moldova Province options.

### CiviContribute

- **Expose fields in soft credit report
  ([dev/core#5339](https://lab.civicrm.org/dev/core/-/issues/5339):
  [30653](https://github.com/civicrm/civicrm-core/pull/30653))**

  Exposes the filter for soft creditor contact id in soft credit report.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Payment Processor shows Machine Name instead of Backend Title in Configure
  Event Fee ([dev/core#5063](https://lab.civicrm.org/dev/core/-/issues/5063):
  [30783](https://github.com/civicrm/civicrm-core/pull/30783))**

- **Quick Config Event Fees are saved rounded to 2 decimal places after first
  save, causing rounding errors
  ([dev/core#5373](https://lab.civicrm.org/dev/core/-/issues/5373):
  [30800](https://github.com/civicrm/civicrm-core/pull/30800))**

- **Trigger search kit refresh for non-popup form submits
  ([30787](https://github.com/civicrm/civicrm-core/pull/30787))**

- **Make `civicrm_queue.name` & `civicrm_queue.name` field longer
  ([30781](https://github.com/civicrm/civicrm-core/pull/30781))**

- **set label for autocomplete on financial account
  ([30642](https://github.com/civicrm/civicrm-core/pull/30642))**

- **Afform: Date field: Selecting and unselecting "Pick Date" causes the time
  field to disappear
  ([dev/core#5245](https://lab.civicrm.org/dev/core/-/issues/5245):
  [30689](https://github.com/civicrm/civicrm-core/pull/30689))**

- **FormBuilder: allow multiple email/phone/address blocks with pre-set location
  types ([dev/core#3433](https://lab.civicrm.org/dev/core/-/issues/3433):
  [30705](https://github.com/civicrm/civicrm-core/pull/30705))**

- **FB: Silent error when required field is hidden by conditional
  ([dev/core#5182](https://lab.civicrm.org/dev/core/-/issues/5182):
  [30524](https://github.com/civicrm/civicrm-core/pull/30524))**

- **SearchKit - Fix current date in search displays
  ([30702](https://github.com/civicrm/civicrm-core/pull/30702))**

- **fix scheduled reminders changed from relative to absolute dates
  ([30717](https://github.com/civicrm/civicrm-core/pull/30717))**

- **APIv4 - Ensure dataType of option id matches dataType of field
  ([30727](https://github.com/civicrm/civicrm-core/pull/30727))**

- **fixes for group subscription confirmation
  ([30758](https://github.com/civicrm/civicrm-core/pull/30758))**

- **Don't crash if we are recording a contribution, outbound email is disabled
  and we try to send a receipt
  ([30656](https://github.com/civicrm/civicrm-core/pull/30656))**

- **Fix Cache Issue In Schema Difference Calculation For Log Tables
  ([30697](https://github.com/civicrm/civicrm-core/pull/30697))**

- **Adding custom multi-value record leads to fatal "no valid value for tableId"
  ([30790](https://github.com/civicrm/civicrm-core/pull/30790))**

- **Add crm-i icon namespace class to font picker icon display
  ([30773](https://github.com/civicrm/civicrm-core/pull/30773))**

- **Remove support for legacy browser file uploads
  ([30658](https://github.com/civicrm/civicrm-core/pull/30658))**

- **Pass our query array rather than the Rule entity to the query creator
  ([30666](https://github.com/civicrm/civicrm-core/pull/30666))**

- **Deprecate `$ids` parameter on Note::create (noisily)
  ([30752](https://github.com/civicrm/civicrm-core/pull/30752))**

- **Eliminate unnecessary calculations and conversions when setting the minDate
  and maxDate ([30664](https://github.com/civicrm/civicrm-core/pull/30664))**

- **Update participantFeeSelection to use non-deprecated function
  ([30470](https://github.com/civicrm/civicrm-core/pull/30470))**

- **DAO - Avoid using deprecated function isComponentEnabled
  ([30641](https://github.com/civicrm/civicrm-core/pull/30641))**

- **Escape contact IDs when first received, do not pass around
  ([30663](https://github.com/civicrm/civicrm-core/pull/30663))**

- **Fix duplicate key so all SearchTest cases run correctly
  ([30652](https://github.com/civicrm/civicrm-core/pull/30652))**

- **avoid dynamic property deprecated errors
  ([30739](https://github.com/civicrm/civicrm-core/pull/30739))**

- **fixes incorrect display of tag field label in profiles
  ([30789](https://github.com/civicrm/civicrm-core/pull/30789))**

- **Uncaught SyntaxError: missing ) after argument list with Catalan
  localization ([30624](https://github.com/civicrm/civicrm-core/pull/30624))**

- **Stop passing variable that is not in function signature
  ([30808](https://github.com/civicrm/civicrm-core/pull/30808))**

- **Remove parameter noisily deprecated > a year ago
  ([30704](https://github.com/civicrm/civicrm-core/pull/30704))**

- **Stop passing class property
  ([30684](https://github.com/civicrm/civicrm-core/pull/30684))**

- **PHP 8.4 - Fix warnings about NULL-able parameters
  ([30806](https://github.com/civicrm/civicrm-core/pull/30806))**

- **Javascript error when I choose membership price set
  ([dev/core#5395](https://lab.civicrm.org/dev/core/-/issues/5395):
  [30883](https://github.com/civicrm/civicrm-core/pull/30883))**

- **Number fields in multi-value fieldsets display with comma separator, but
  cannot be saved in the same format
  ([dev/core#5408](https://lab.civicrm.org/dev/core/-/issues/5408):
  [30947](https://github.com/civicrm/civicrm-core/pull/30947))**

- **Smarty - Don't hard-code reference to Smarty version
  ([30922](https://github.com/civicrm/civicrm-core/pull/30922))**

### CiviCampaign

- **DB error message when creating new campaign with existing "External ID"
  ([dev/core#4224](https://lab.civicrm.org/dev/core/-/issues/4224):
  [30731](https://github.com/civicrm/civicrm-core/pull/30731))**

### CiviCase

- **CiviCase: Fix group type assignment of the "Case Resources" as "Mailing
  List" ([dev/core#5359](https://lab.civicrm.org/dev/core/-/issues/5359):
  [30724](https://github.com/civicrm/civicrm-core/pull/30724))**

- **CaseActivity: Ignore case activity assignee contact id when activity type
  should not be notified.
  ([30722](https://github.com/civicrm/civicrm-core/pull/30722))**

### CiviContribute

- **Quick Config Contributions Fees are saved rounded to 2 decimal places after
  first save, causing rounding errors
  ([dev/core#5381](https://lab.civicrm.org/dev/core/-/issues/5381):
  [30804](https://github.com/civicrm/civicrm-core/pull/30804))**

- **Update Fiscal Year Label on Contribution Totals
  ([29154](https://github.com/civicrm/civicrm-core/pull/29154))**

- **Fix notice error when previewing profile from contribution page
  ([30632](https://github.com/civicrm/civicrm-core/pull/30632))**

- **Copy payment_instrument_id when creating template contribution
  ([30761](https://github.com/civicrm/civicrm-core/pull/30761))**

### CiviEvent
- **Tell-a-friend fixes to Manage event
  ([30896](https://github.com/civicrm/civicrm-core/pull/30896))**

### CiviMail

- **Upgrade crash on mailing backfill
  ([30825](https://github.com/civicrm/civicrm-core/pull/30825))**

### CiviMember

- **Fix crash on membership view for related memberships
  ([30839](https://github.com/civicrm/civicrm-core/pull/30839))**

- **Fix reversed membership status change in activity following #30493  
  ([30834](https://github.com/civicrm/civicrm-core/pull/30834))**

### Backdrop Integration

- **Backdrop's Bee commands fail with cmrs.root.path error
  ([dev/core#5363](https://lab.civicrm.org/dev/core/-/issues/5363):
  [30734](https://github.com/civicrm/civicrm-core/pull/30734))**

### Standalone Integration

- **KCFinder - look for civicrm.standalone.php as well as civicrm.config.php
  ([410](https://github.com/civicrm/civicrm-packages/pull/410))**

  Makes sure KCFinder works with Standalone.

### WordPress Integration

- **Tellafriend extension missing from WP tarball
  ([dev/core#5398](https://lab.civicrm.org/dev/core/-/issues/5398):
  [30872](https://github.com/civicrm/civicrm-core/pull/30872))**

## <a name="misc"></a>Miscellany

- **ext/ - Update civix templates for newer entities
  ([30760](https://github.com/civicrm/civicrm-core/pull/30760))**

- **Bump select2 version
  ([30657](https://github.com/civicrm/civicrm-core/pull/30657))**

- **Api4 - More efficient array_column function
  ([30736](https://github.com/civicrm/civicrm-core/pull/30736))**

- **Fully switch unit tests over to Smarty5
  ([30644](https://github.com/civicrm/civicrm-core/pull/30644))**

- **Upgrade Font Awesome v4 => v6
  ([30779](https://github.com/civicrm/civicrm-core/pull/30779))**

- **Bring hash in composer.lock up to date
  ([30791](https://github.com/civicrm/civicrm-core/pull/30791))**

- **Move add function on ContributionRecur to hook
  ([30634](https://github.com/civicrm/civicrm-core/pull/30634))**

- **Keep baby, ditch bathwater
  ([30720](https://github.com/civicrm/civicrm-core/pull/30720))**

- **Stop passing contactType around
  ([30645](https://github.com/civicrm/civicrm-core/pull/30645))**

- **Update Smarty5 to latest released version
  ([411](https://github.com/civicrm/civicrm-packages/pull/411))**

- **I am Dave (A bit more obvious deprecation)
  ([30805](https://github.com/civicrm/civicrm-core/pull/30805))**

- **Fix for a comment
  ([30742](https://github.com/civicrm/civicrm-core/pull/30742))**

- **Add Ken Zalewski to list of CiviCRM contributors
  ([30670](https://github.com/civicrm/civicrm-core/pull/30670))**

- **Update contributor-key.yml
  ([30810](https://github.com/civicrm/civicrm-core/pull/30810) and
  [30732](https://github.com/civicrm/civicrm-core/pull/30732))**

- **[REF] Add in Screen reader labels for Saved Search Label and drop down
  button for displays on Search Kit Admin
  ([30746](https://github.com/civicrm/civicrm-core/pull/30746))**

- **[REF] Fix link when copying a mass SMS to not create a new mailing and fix
  some strings to be clearer your dealing with SMS when looking at the List of
  Sent Mass SMSes
  ([30802](https://github.com/civicrm/civicrm-core/pull/30802))**

- **[REF] Accessiblity fix - empty form label on new organization form
  ([30723](https://github.com/civicrm/civicrm-core/pull/30723))**

- **[REF] Fix empty headers in option group, custom field, group and profile
  pages ([30696](https://github.com/civicrm/civicrm-core/pull/30696))**

- **[REF] Fix Empty Button accessibility issue in Afform Admin Injector
  ([30770](https://github.com/civicrm/civicrm-core/pull/30770))**

- **[REF] Fix empty form label error on Groups Tab on Contact Summary
  ([30771](https://github.com/civicrm/civicrm-core/pull/30771))**

- **[REF] Fix accessibilty issues on activty tab on contact summary for missing
  labels for selects
  ([30769](https://github.com/civicrm/civicrm-core/pull/30769))**

- **[REF] Fix undefined constant on closed batches
  ([30954](https://github.com/civicrm/civicrm-core/pull/30954))**

- **[REF] Fix accessiblity issue on drupal menu toggle button
  ([30695](https://github.com/civicrm/civicrm-core/pull/30695))**

- **[REF] Add title to quicksearch
  ([30683](https://github.com/civicrm/civicrm-core/pull/30683))**

- **[REF] Participant import Fold weird legacy function back into only caller
  ([30607](https://github.com/civicrm/civicrm-core/pull/30607))**

- **[REF] Dedupe Calculate 'query' in the construct
  ([30615](https://github.com/civicrm/civicrm-core/pull/30615))**

- **[REF] [Dedupe Finder] Fold the tableQueries back to the caller
  ([30604](https://github.com/civicrm/civicrm-core/pull/30604))**

- **REF - Remove unnecessary uses of CRM_Utils_Array::value
  ([682](https://github.com/civicrm/civicrm-drupal/pull/682))**

- **[REF] Ensure that Select2 widgets rendered by Afform have labels for
  accessibilty ([30764](https://github.com/civicrm/civicrm-core/pull/30764))**

- **[REF] Fix empty table header on extra first column in table display
  ([30763](https://github.com/civicrm/civicrm-core/pull/30763))**

- **[REF] Fix empty buttons in Search Kit DIsplay table task header
  ([30762](https://github.com/civicrm/civicrm-core/pull/30762))**

- **[REF] Ensure that icon Picker in search kit admin has a title for screen
  readers ([30744](https://github.com/civicrm/civicrm-core/pull/30744))**

- **[NFC] SettingsStyleTest - better warnings when missing keys
  ([30542](https://github.com/civicrm/civicrm-core/pull/30542))**

- **[NFC] Clean up comments in civicrm.settings.php
  ([30777](https://github.com/civicrm/civicrm-core/pull/30777))**

- **(NFC) Update docblock comments to be more accurate
  ([30651](https://github.com/civicrm/civicrm-core/pull/30651))**

- **Afform - Add a unit test for creating event from a template
  ([30795](https://github.com/civicrm/civicrm-core/pull/30795))**

- **Afform - Fix new test-failures on php74
  ([30920](https://github.com/civicrm/civicrm-core/pull/30920))**

- **Add unit test for dev/core#5358
  ([dev/core#5358](https://lab.civicrm.org/dev/core/-/issues/5358):
  [30755](https://github.com/civicrm/civicrm-core/pull/30755))**

- **Test for clean up of ContributionRecur.add function
  ([30635](https://github.com/civicrm/civicrm-core/pull/30635))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Iris; Alexy
Mikhailichenko; Benjamin W; BrightMinded Ltd - Bradley Taylor; Business &
Code - Alain Benbassat; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; civiservice.de - Martin Correll;
Coop SymbioTIC - Samuel Vanhove; Dave D; David Cativo; Francesc Bassas i
Bullich; Future Processing - Joanna Suchogórska; Fuzion - Jitendra Purohit,
Luke Stewart; Giant Rabbit - Anthony Nemirovsky; Jens Schuppe; JMA Consulting -
Monish Deb, Seamus Lee; Joinery - Allen Shaw; Megaphone Technology Consulting -
Jon Goldberg; MJW Consulting - Matthew Wire; Mosier Consulting - Justin Mosier;
New York State Senate - Ken Zalewski; Progressive Technology Project - Jamie
McClelland; Third Sector Design - Kurund Jalmi; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; ALL IN APPLI admin; Australian Greens - John Twyman;
Freeform Solutions - Herb van den Dool; Guydn; iXiam - Albert Vall-Llovera;
Jade Gaunt; JMA Consulting - Joe Murray; Lemniscus - Noah Miller; Nicol
Wistreich; Squiffle Consulting - Aidan Saunders;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
