# CiviCRM 5.76.0

Released August 7, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add diff view to Message Admin
  ([30488](https://github.com/civicrm/civicrm-core/pull/30488))**

  Adds diff view to System Workflow Message templates for those using the
  "Message Administrator" extension.

- **MessageTemplate - Add Api4.revert action
  ([30498](https://github.com/civicrm/civicrm-core/pull/30498))**

  Adds a new APIv4 action for the MessageTemplate entity: revert.

- **Add revert option to the UI for MessageAdmin
  ([30500](https://github.com/civicrm/civicrm-core/pull/30500))**

  Adds a revert option to the user interface for Message Templates for those
  using the "Message Administrator" extension.

- **Enable message admin by default on new installs
  ([30503](https://github.com/civicrm/civicrm-core/pull/30503))**

  Enables the "Message Administrator" extension by default on new installs.

- **Provide Grant tokens & by extension tokens for any entity by declaring some
  metadata ([30461](https://github.com/civicrm/civicrm-core/pull/30461))**

  This specifically adds tokens for CiviGrant but more generally adds a
  mechanism to allow any entity to add generic tokens by inserting some values
  in the entity definition and is part of an effort to lower the bar to have
  entity features for custom & core entities.

- **Swap out CiviCRM logos
  ([dev/user-interface#48](https://lab.civicrm.org/dev/user-interface/-/issues/48):
  [30486](https://github.com/civicrm/civicrm-core/pull/30486))**

  Updates CiviCRM logo to new version & SVG.

- **Update pear/log to 1.14.4
  ([30484](https://github.com/civicrm/civicrm-core/pull/30484),
  [30521](https://github.com/civicrm/civicrm-core/pull/30521),
  [30520](https://github.com/civicrm/civicrm-core/pull/30520) and
  [30519](https://github.com/civicrm/civicrm-core/pull/30519))**

  Updates pear/log to 1.14.1 and subsequent tweaks to make it play nicely.

- **5.68.1 Bundled non-embeddable font in "ext/greenwich"?
  ([dev/release#22](https://lab.civicrm.org/dev/release/-/issues/22):
  [28912](https://github.com/civicrm/civicrm-core/pull/28912))**

  Phase-out/off-load Glyphicons.

- **Deprecate Tell a Friend
  ([dev/core#1036](https://lab.civicrm.org/dev/core/-/issues/1036):
  [30222](https://github.com/civicrm/civicrm-core/pull/30222))**

  Moves code from Tell-a-friend to a core extension.

- **SearchKit Feature Request: Show Group By Field with Function as a Select
  Field ([dev/core#5195](https://lab.civicrm.org/dev/core/-/issues/5195):
  [30153](https://github.com/civicrm/civicrm-core/pull/30153))**

  Allows function used in GROUP BY to be in SELECT in SearchKit.

- **Feature request -{site.message_header} (was {domain.logo})
  (Work Towards [dev/core#3682](https://lab.civicrm.org/dev/core/-/issues/3682):
  [30529](https://github.com/civicrm/civicrm-core/pull/30529),
  [30518](https://github.com/civicrm/civicrm-core/pull/30518),
  [30530](https://github.com/civicrm/civicrm-core/pull/30530),
  [30451](https://github.com/civicrm/civicrm-core/pull/30451) and
  [30539](https://github.com/civicrm/civicrm-core/pull/30539))**

  Adds support for site wide tokens such as "logo/header" in message templates,
  and mechanism to support others. Enforces unique label+domain_id for site
  tokens.

- **APIv4 Order API (Work Towards
  [dev/core#4367](https://lab.civicrm.org/dev/core/-/issues/4367):
  [28403](https://github.com/civicrm/civicrm-core/pull/28403) and
  [30366](https://github.com/civicrm/civicrm-core/pull/30366))**

  APIv4 Order api create action (basic implementation, apiv3 parity) including
  updating related memberships.

- **Extension Upgrades - More distinction between default task titles
  ([civicrm/cv#200](https://github.com/civicrm/cv/pull/200):
  [30557](https://github.com/civicrm/civicrm-core/pull/30557))**

  Makes verbose output about the progress of extension database-upgrades
  (slightly) less confusing.

- **ScheduledCommunications - Add 'schedule communications' permission
  ([30587](https://github.com/civicrm/civicrm-core/pull/30587))**

  Creates permission that allows users to schedule communications based off a
  SavedSearch.

- **ScheduledCommunications - Enable alternate or copied recipients
  ([30424](https://github.com/civicrm/civicrm-core/pull/30424))**

  Introduces 2 new modes for SearchKit based scheduled communications: "Copy to
  additional recipients" and "Reroute to alternate recipients".

- **Make string nullable on civicrm_translation
  ([30516](https://github.com/civicrm/civicrm-core/pull/30516))**

  Makes it possible to save an empty translation string.

- **Add ability to define a pseudo row in imports
  ([30420](https://github.com/civicrm/civicrm-core/pull/30420))**

  Adds the ability to add an additional row to the mapping that will allow a
  default value to be set, which will then apply to all imported rows.

- **Theming - Allow manipulation of Angular CSS
  ([30397](https://github.com/civicrm/civicrm-core/pull/30397))**

  Ensures Overrides and exclusions for Angular CSS work.

- **Extend FormBuilder conditional logic
  (Work towards [dev/core#5105](https://lab.civicrm.org/dev/core/-/issues/5105):
  [30450](https://github.com/civicrm/civicrm-core/pull/30450))**

  Adds support for more operators in conditional rules in Afform.

- **add source field to returned fields in Contact.get
  ([30240](https://github.com/civicrm/civicrm-core/pull/30240))**

  Adds "Source" field to returned fields in APIv3 Contact.get.

- **Add mailSettingId parameter to emailProcessor hook
  ([30334](https://github.com/civicrm/civicrm-core/pull/30334))**

  Makes `mailSettingId` available to any hook listeners.

- **API4 - Trigger civi.api.exception event in API4
  ([29043](https://github.com/civicrm/civicrm-core/pull/29043))**

  Improves logging when something goes wrong in APIv4.

- **Support for E2E testing with Mink for Afform
  ([29599](https://github.com/civicrm/civicrm-core/pull/29599))**

  Adds support for E2E testing for Afform using Mink, along with a test class in
  Admin UI for the Manage Groups page.

- **Rename the Find and Merge Duplicates Contacts menu item
  ([30387](https://github.com/civicrm/civicrm-core/pull/30387))**

  Simplifies menu item name from "Find and Merge Duplicates Contacts" to "Merge
  Duplicates".

### CiviContribute

- **Fee Amount not being added to financial trxn its also not showing when
  editing a payment (financial trx)
  ([dev/core#5228](https://lab.civicrm.org/dev/core/-/issues/5228):
  [30430](https://github.com/civicrm/civicrm-core/pull/30430))**

  Adds support for Payment custom fields.

- **'All financial ACLs' permissions
  ([30388](https://github.com/civicrm/civicrm-core/pull/30388))**

  Adds "View/Add/Edit/Delete contributions of all types" permissions.

- **Payment Get APIv4
  ([30353](https://github.com/civicrm/civicrm-core/pull/30353))**

  Adds a Payment.Get APIv4 action.

- **Fix contribution import to consider address fields for dedupe sufficiency
  ([29979](https://github.com/civicrm/civicrm-core/pull/29979))**

  Fixes contribution import to consider address fields for dedupe sufficiency

### CiviEvent

- **Fix event management performance when there are lots of events.
  ([29618](https://github.com/civicrm/civicrm-core/pull/29618))**

  Improves Event Management performance.

### CiviMail

- **Address CiviCRM Mailing table complexity - make queries easier & data more
  prunable ([dev/core#4567](https://lab.civicrm.org/dev/core/-/issues/4567):
  [27559](https://github.com/civicrm/civicrm-core/pull/27559) and
  [30458](https://github.com/civicrm/civicrm-core/pull/30458))**

  Adds `status`, `start_date` & `end_date` columns to `civicrm_mailing` table.

### Drupal Integration

- **drush: use \Civi\Setup instead of custom installer
  ([dev/drupal#193](https://lab.civicrm.org/dev/drupal/-/issues/193):
  [679](https://github.com/civicrm/civicrm-drupal/pull/679))**

  Replaces custom installer with Civi\Setup.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Contact Import will not accept State/Province outside the Default Country
  ([dev/core#4231](https://lab.civicrm.org/dev/core/-/issues/4231):
  [28557](https://github.com/civicrm/civicrm-core/pull/28557))**

- **Crash when disabling an extension that provides an entity that is referenced
  in a custom field
  ([dev/core#4900](https://lab.civicrm.org/dev/core/-/issues/4900):
  [30093](https://github.com/civicrm/civicrm-core/pull/30093))**

- **Custom radio/checkbox fields - maximum options per line - alignment lost  
  ([dev/core#4985](https://lab.civicrm.org/dev/core/-/issues/4985):
  [30294](https://github.com/civicrm/civicrm-core/pull/30294))**

  Modernizes checkbox/radio CSS, markup on backend forms.

- **Form Builder: Conditional logic not working for multi-select fields
  ([dev/core#5163](https://lab.civicrm.org/dev/core/-/issues/5163):
  [30442](https://github.com/civicrm/civicrm-core/pull/30442))**

- **DB Error: when exporting with "Additional Group to Export"
  ([dev/core#5219](https://lab.civicrm.org/dev/core/-/issues/5219):
  [30372](https://github.com/civicrm/civicrm-core/pull/30372))**

  Removes "Additional Group for Export" option from export screen.

- **Unable to save membership when switch from a price set with required field
  to "Choose price set" (a membership type without price set)
  ([dev/core#5280](https://lab.civicrm.org/dev/core/-/issues/5280):
  [30447](https://github.com/civicrm/civicrm-core/pull/30447))**

- **Submitting backend Credit Card Membership form without filling num terms
  lead to a fatal error
  ([dev/core#5333](https://lab.civicrm.org/dev/core/-/issues/5333):
  [30623](https://github.com/civicrm/civicrm-core/pull/30623))**

- **Add descriptions to schema entities which were set to 'FIXME'
  ([30555](https://github.com/civicrm/civicrm-core/pull/30555))**

- **Revert "make smarty 5 noisier in debug mode"
  ([30563](https://github.com/civicrm/civicrm-core/pull/30563))**

- **In debug mode or on dev builds, make smarty annoying again
  ([30545](https://github.com/civicrm/civicrm-core/pull/30545))**

- **smtp outbound fails with mysterious message if message body is blank
  ([30172](https://github.com/civicrm/civicrm-core/pull/30172))**

- **Enable CiviImport by default
  ([30346](https://github.com/civicrm/civicrm-core/pull/30346))**

- **Move the switch to variable rather than array key up a little higher
  ([30499](https://github.com/civicrm/civicrm-core/pull/30499))**

- **Only add table if not exists
  ([30517](https://github.com/civicrm/civicrm-core/pull/30517))**

- **CRM_Utils_File::runSqlQuery() - Throw exception instead of calling die
  ([29318](https://github.com/civicrm/civicrm-core/pull/29318))**

- **Imagine a world without CodeGen (Work towards
  [dev/core#4999](https://lab.civicrm.org/dev/core/-/issues/4999):
  [30022](https://github.com/civicrm/civicrm-core/pull/30022))**

  Deletes schema/xml files.

- **"DB Error: syntax error" on membership reminder when contribution statuses
  are translated ([30522](https://github.com/civicrm/civicrm-core/pull/30522))**

- **Fix access to undeclared property on PEAR
  ([30495](https://github.com/civicrm/civicrm-core/pull/30495))**

- **Afform - Fix console error in conditional rule
  ([30438](https://github.com/civicrm/civicrm-core/pull/30438))**

- **Fix field length error while searching in Include / Exclude Search
  ([30402](https://github.com/civicrm/civicrm-core/pull/30402))**

- **Return early if no greetings found
  ([30460](https://github.com/civicrm/civicrm-core/pull/30460))**

- **always treat saved groups as an array
  ([30391](https://github.com/civicrm/civicrm-core/pull/30391))**

- **Remove broken code from DedupeFinder
  ([30600](https://github.com/civicrm/civicrm-core/pull/30600))**

- **Add noisy deprecation to now-unused function
  ([30352](https://github.com/civicrm/civicrm-core/pull/30352))**

- **DAO - Fix isComponentEnabled function, mark deprecated
  ([30636](https://github.com/civicrm/civicrm-core/pull/30636))**

### CiviContribute

- **Code was setting invoice number to a predicted next ContributionID instead
  of waiting for the Contribution ID to be set.  
  ([dev/core#5004](https://lab.civicrm.org/dev/core/-/issues/5004):
  [29450](https://github.com/civicrm/civicrm-core/pull/29450))**

  Wait until contribution saved to calculate invoice number.

- **Pass Source and Account ID to PayPal when processing Additional Payments
  ([29495](https://github.com/civicrm/civicrm-core/pull/29495))**

- **PayPalIPN: check the `custom` parameter of HTTP request is a valid JSON
  ([30594](https://github.com/civicrm/civicrm-core/pull/30594))**

- **Fix php8.x notices on Contribution Recur form
  ([30411](https://github.com/civicrm/civicrm-core/pull/30411))**

- **Stop setting relatedObjects['pledge_payment'] as it is not used
  ([30480](https://github.com/civicrm/civicrm-core/pull/30480))**

- **Allow deletion of orphan payment activities
  ([29784](https://github.com/civicrm/civicrm-core/pull/29784))**

- **Sending a receipt from the "more" menu on contribution selectors always
  gives
  CRM16923AnUnreliableMethodHasBeenUserToDeterminePaymentProcessorFromContributionPage  
  ([dev/core#5251](https://lab.civicrm.org/dev/core/-/issues/5251):
  [30474](https://github.com/civicrm/civicrm-core/pull/30474) and
  [30497](https://github.com/civicrm/civicrm-core/pull/30497))**

- **[php8] undeclared vars on new contribution
  ([30546](https://github.com/civicrm/civicrm-core/pull/30546))**

### CiviEvent

- **Fix a couple of smarty notices when viewing the big map on events by always
  assigning variables to smarty
  ([30554](https://github.com/civicrm/civicrm-core/pull/30554))**

- **Regression - Billing email set to primary email when registering for event
  that uses profiles with multiple email location types
  ([dev/core#5330](https://lab.civicrm.org/dev/core/-/issues/5330):
  [30619](https://github.com/civicrm/civicrm-core/pull/30619) and
  [30629](https://github.com/civicrm/civicrm-core/pull/30629))**

- **Fix event set up to set profile weight correctly
  ([30393](https://github.com/civicrm/civicrm-core/pull/30393))**

- **Participant: Store custom field values before post hook
  ([28379](https://github.com/civicrm/civicrm-core/pull/28379))**

- **Remove cart_id from civicrm_participant, create new table in event cart
  ([30578](https://github.com/civicrm/civicrm-core/pull/30578))**

- **Remove event cart message_template, tables from core
  ([30525](https://github.com/civicrm/civicrm-core/pull/30525))**

- **Do not import multiple participants per line
  ([29638](https://github.com/civicrm/civicrm-core/pull/29638))**

### CiviMember

- **Fix issue with permissions on membership creation activity
  ([30527](https://github.com/civicrm/civicrm-core/pull/30527))**

- **Call writeRecord directly from process membership status job
  ([30493](https://github.com/civicrm/civicrm-core/pull/30493))**

### Drupal Integration

- **Path wildcards are too wild (on D9/D10)
  ([dev/drupal#197](https://lab.civicrm.org/dev/drupal/-/issues/197):
  [97](https://github.com/civicrm/civicrm-drupal-8/pull/97))**

  Router - Fix mismatched routes and "AfformRoutingTest".

### Standalone Integration

- **kcfinder - Add support for Standalone permission check
  ([408](https://github.com/civicrm/civicrm-packages/pull/408))**

  Ensures kcfinder works for standalone integrations.

- **Standalone - factor out boot steps from index.php  
  ([29960](https://github.com/civicrm/civicrm-core/pull/29960))**

### WordPress Integration

- **Can't edit Membership price sets when CiviEvent is deactivated
  ([dev/wordpress#150](https://lab.civicrm.org/dev/wordpress/-/issues/150):
  [30415](https://github.com/civicrm/civicrm-core/pull/30415))**

## <a name="misc"></a>Miscellany

- **Switch last usage of transitionComponents to use v4 Payment.create
  ([30376](https://github.com/civicrm/civicrm-core/pull/30376))**

- **Upgrader - Add createEntityTable function
  ([30453](https://github.com/civicrm/civicrm-core/pull/30453))**

- **Further clarify dedupe custom field handling
  ([29063](https://github.com/civicrm/civicrm-core/pull/29063))**

- **Handle all the DataSource templates using the same template at the php
  layer ([30537](https://github.com/civicrm/civicrm-core/pull/30537))**

- **Bump ws and socket.io
  ([30485](https://github.com/civicrm/civicrm-core/pull/30485))**

- **Dedupe Use local variable rather than (undefined) class property
  ([30601](https://github.com/civicrm/civicrm-core/pull/30601))**

- **Fold weird old civi function back into only caller
  ([30589](https://github.com/civicrm/civicrm-core/pull/30589))**

- **Extract `getProfileDisplay()`
  ([30378](https://github.com/civicrm/civicrm-core/pull/30378))**

- **Clean up handling around PaymentProcessor in composeMessageArray
  ([30422](https://github.com/civicrm/civicrm-core/pull/30422))**

- **Fold 2 more functions back into only remaining caller
  ([30409](https://github.com/civicrm/civicrm-core/pull/30409))**

- **Fold loadRelatedObjects back into only caller
  ([30401](https://github.com/civicrm/civicrm-core/pull/30401))**

- **Copy deprecated function back to event_cart
  ([30577](https://github.com/civicrm/civicrm-core/pull/30577))**

- **Re-rerun regen.sh (pick up site_token, message_admin)
  ([30568](https://github.com/civicrm/civicrm-core/pull/30568))**

- **Remove unused variable
  ([30416](https://github.com/civicrm/civicrm-core/pull/30416))**

- **Remove do-nothing call to old function
  ([30588](https://github.com/civicrm/civicrm-core/pull/30588))**

- **Remove unused variable
  ([30396](https://github.com/civicrm/civicrm-core/pull/30396))**

- **Remove extraneous variables from main loop
  ([30375](https://github.com/civicrm/civicrm-core/pull/30375))**

- **Remove wrangling of unused variable
  ([30573](https://github.com/civicrm/civicrm-core/pull/30573))**

- **remove unused variable
  ([30571](https://github.com/civicrm/civicrm-core/pull/30571))**

- **Add self to contributor list
  ([30481](https://github.com/civicrm/civicrm-core/pull/30481))**

- **adding name to contributor list
  ([30602](https://github.com/civicrm/civicrm-core/pull/30602))**

- **[ref] Clarify job object
  ([30454](https://github.com/civicrm/civicrm-core/pull/30454))**

- **[REF] Return Frontend title of the group instead of a title when
  successfully confirming a subscription request
  ([29703](https://github.com/civicrm/civicrm-core/pull/29703))**

- **[REF] Remove purify calls for labelfrom quickform which are not needed
  ([29772](https://github.com/civicrm/civicrm-core/pull/29772))**

- **[REF] move relatedContactID determination to where it is used
  ([30473](https://github.com/civicrm/civicrm-core/pull/30473))**

- **[REF] Remove a few unused variables
  ([30457](https://github.com/civicrm/civicrm-core/pull/30457))**

- **[Ref] Unpack the ids array into variables
  ([30414](https://github.com/civicrm/civicrm-core/pull/30414))**

- **[REF] Fix some smarty notices on Event Pages
  ([30540](https://github.com/civicrm/civicrm-core/pull/30540))**

- **[REF] Fix schema version number to be correct one
  ([30541](https://github.com/civicrm/civicrm-core/pull/30541))**

- **[REF] This adds mink packages pulled out from Jon G's PR
  ([30547](https://github.com/civicrm/civicrm-core/pull/30547))**

- **[REF] Fix potential smarty notice if location is empty
  ([30553](https://github.com/civicrm/civicrm-core/pull/30553))**

- **[REF] Dedupe Pass Optimizer into tableQuery()
  ([30610](https://github.com/civicrm/civicrm-core/pull/30610))**

- **[REF] Dedupe finder - further code moves
  ([30599](https://github.com/civicrm/civicrm-core/pull/30599))**

- **[REF] Move Dedupe isUseReservedQuery to the optimiser class
  ([30598](https://github.com/civicrm/civicrm-core/pull/30598))**

- **[REF] Minor code simplification
  ([30597](https://github.com/civicrm/civicrm-core/pull/30597))**

- **[REF] Start to move query optimisation to a new class, use apiv4
  ([30596](https://github.com/civicrm/civicrm-core/pull/30596))**

- **[REF] participant import Use standardised parent function to check contact
  ID ([30586](https://github.com/civicrm/civicrm-core/pull/30586))**

- **[REF] Move participant create out of if-else
  ([30580](https://github.com/civicrm/civicrm-core/pull/30580))**

- **[REF] Only load map if we have a geocoded address in the event
  ([30565](https://github.com/civicrm/civicrm-core/pull/30565))**

- **[REF] unpack params into variables for transparency
  ([30469](https://github.com/civicrm/civicrm-core/pull/30469))**

- **[REF] Make lineItem field optional in processAmount
  ([30468](https://github.com/civicrm/civicrm-core/pull/30468))**

- **REF: Replace deprecate getMembershipTypeDetails with API4
  ([30092](https://github.com/civicrm/civicrm-core/pull/30092))**

- **[REF] ContributionPage - Code readability cleanup
  ([30194](https://github.com/civicrm/civicrm-core/pull/30194))**

- **[REF] After editing schedule job it should redirect back to job list page
  ([30381](https://github.com/civicrm/civicrm-core/pull/30381))**

- **(NFC) Reduce size of array in test
  ([30449](https://github.com/civicrm/civicrm-core/pull/30449))**

- **(NFC) Add order by to test for more consistency
  ([30448](https://github.com/civicrm/civicrm-core/pull/30448))**

- **(NFC) afform_mock - Updates for PHPUnit 9.x
  ([30581](https://github.com/civicrm/civicrm-core/pull/30581))**

- **[NFC] Add hint to error message as to why test might fail
  ([30536](https://github.com/civicrm/civicrm-core/pull/30536))**

- **Update Membership Batch test to use full form flow
  ([30377](https://github.com/civicrm/civicrm-core/pull/30377))**

- **Clean up in test
  ([30369](https://github.com/civicrm/civicrm-core/pull/30369))**

- **Superficial clean up in test class
  ([30459](https://github.com/civicrm/civicrm-core/pull/30459))**

- **Minor test standardisation
  ([30365](https://github.com/civicrm/civicrm-core/pull/30365))**

- **Clean up test to use full form flow
  ([30437](https://github.com/civicrm/civicrm-core/pull/30437))**

- **Minor improvements in test - full form flow, apiv4
  ([30421](https://github.com/civicrm/civicrm-core/pull/30421))**

- **Suppress php 8.3 test fail on upgrade code not supporting php 8.3
  ([30483](https://github.com/civicrm/civicrm-core/pull/30483))**

- **Fix test helper to apiv4, make clean up generic
  ([30606](https://github.com/civicrm/civicrm-core/pull/30606))**

- **Civi\Test\MinkBase - Skip execution on D9
  ([30582](https://github.com/civicrm/civicrm-core/pull/30582))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Artur Śmigielski; Benjamin W;
Christian Wach; Circle Interactive - Angela Jackson; CiviCRM - Coleman Watts,
Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; Fuzion -
Jitendra Purohit; Giant Rabbit - Anthony Nemirovsky; Ginkgo Street Labs -
Michael Z Daryabeygi; Greenpeace Central and Eastern Europe - Patrick Figel;
JMA Consulting - Monish Deb, Seamus Lee; Joinery - Allen Shaw; Jonny Toomey;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; PERORA SRL - Samuele Masetto; Skvare - Mark Hanna; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; ALL IN APPLI admin; Artful Robot - Rich Lott;
Circle Interactive - Pradeep Nayak; CiviDesk - Yashodha Chaku; forumZFD - Marc
Michalsky; Freeform Solutions - Herb van den Dool; Fuzion - Luke Stewart;
Greenleaf Advancement - Guy Iaccarino; JMA Consulting - Joe Murray;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
