# CiviCRM 5.73.0

Released May 2, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Afform - Enable updating relationship by id
  ([29693](https://github.com/civicrm/civicrm-core/pull/29693))**

  Previously relationships could only be updated if required fields were
  present. Now if there is an id it can be updated without any other fields on
  the form.

- **Warn when disabling/deleting groups which feature in smart group criteria  
  ([29732](https://github.com/civicrm/civicrm-core/pull/29732))**

  Adds a warning when disabling/deleting a group will have repercussions
  for other groups.

- **SearchKit - Enable predefined link conditionals
  ([29735](https://github.com/civicrm/civicrm-core/pull/29735))**

  Improves links in SearchKit by pre-defining conditional rules.

- **Imagine a world without CodeGen (Work Towards
  [dev/core#4999](https://lab.civicrm.org/dev/core/-/issues/4999):
  [29771](https://github.com/civicrm/civicrm-core/pull/29771))**

  Adds a new mixin for use by non-xml-based entities.

- **Api4 - Add 'usage' to getFields output
  ([29634](https://github.com/civicrm/civicrm-core/pull/29634))**

  Adds metadata to APIv4 getFields.

- **Allow access to API params from Api4Query
  (Work Towards [dev/core#5102](https://lab.civicrm.org/dev/core/-/issues/5102):
  [29774](https://github.com/civicrm/civicrm-core/pull/29774))**

  Get any API param from the Api4Query class.

### CiviMail

- **(dev/core#5118) Tokens - Expand support for symbol-tokens ([30100](https://github.com/civicrm/civicrm-core/pull/30100), [30102](https://github.com/civicrm/civicrm-core/pull/30102), [30101](https://github.com/civicrm/civicrm-core/pull/30101))**

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **(dev/core#5183) Search Tasks - Actions incorrectly apply to all records in database ([30111](https://github.com/civicrm/civicrm-core/pull/30111))**

- **Cannot create proper `Group`s on multilingual with MySQL 5.6 and Civi
  5.31-rc
  ([dev/translation#85](https://lab.civicrm.org/dev/translation/-/issues/58):
  [29891](https://github.com/civicrm/civicrm-core/pull/29891))**

- **Searching by phone in Advanced Search with a non-default Search Profile
  returns DB Error: no such field
  ([dev/core#3836](https://lab.civicrm.org/dev/core/-/issues/3836):
  [24450](https://github.com/civicrm/civicrm-core/pull/24450))**

- **Formbuilder: updates not saved when a populated field of type "file" is
  present in the form
  ([dev/core#5078](https://lab.civicrm.org/dev/core/-/issues/5078):
  [29884](https://github.com/civicrm/civicrm-core/pull/29884))**

- **Saving checkbox custom fields via APIv4 fails for custom/dynamic entities
  ([dev/core#5103](https://lab.civicrm.org/dev/core/-/issues/5103):
  [29786](https://github.com/civicrm/civicrm-core/pull/29786))**

- **Inconsistent handling of tag name and tag label  
  ([dev/core#5108](https://lab.civicrm.org/dev/core/-/issues/5108):
  [29875](https://github.com/civicrm/civicrm-core/pull/29875))**

- **smarty 3/4 still calling smarty2 plugins, which errors for e.g. date_format
  ([dev/core#5130](https://lab.civicrm.org/dev/core/-/issues/5130):
  [29911](https://github.com/civicrm/civicrm-core/pull/29911))**

- **Failure when .hlp files contain php functions like array_key_exists
  ([dev/core#5136](https://lab.civicrm.org/dev/core/-/issues/5136):
  [29923](https://github.com/civicrm/civicrm-core/pull/29923))**

- **Register some more functions for Smarty
  ([29856](https://github.com/civicrm/civicrm-core/pull/29856))**

- **Add check for whether SMARTY_DIR is defined
  ([29853](https://github.com/civicrm/civicrm-core/pull/29853))**

- **asofDate gets used as constructor to DateTime which wants a string
  ([29858](https://github.com/civicrm/civicrm-core/pull/29858))**

- **`hook_civicrm_links` - don't pass `objectId` by-reference
  ([29764](https://github.com/civicrm/civicrm-core/pull/29764))**

- **Set error response code before starting error response
  ([29809](https://github.com/civicrm/civicrm-core/pull/29809))**

- **Don't clear the smarty debugging var
  ([29754](https://github.com/civicrm/civicrm-core/pull/29754))**

- **Allow `0.0` as value for a required float APIv4 action parameter
  ([29766](https://github.com/civicrm/civicrm-core/pull/29766))**

- **Add deprecation notice to hook_civicrm_links used by search forms
  ([29765](https://github.com/civicrm/civicrm-core/pull/29765))**

- **AngularJS - Fix multi-select fields when value contains a comma
  ([29645](https://github.com/civicrm/civicrm-core/pull/29645))**

- **php8.2 Update Case form to handle both Activity & Case custom data with
  standard ajax methods
  ([29799](https://github.com/civicrm/civicrm-core/pull/29799))**

- **call buildamount hook
  ([29829](https://github.com/civicrm/civicrm-core/pull/29829))**

  Fixes CiviDiscount.

- **Look up using phone_numeric
  ([29740](https://github.com/civicrm/civicrm-core/pull/29740))**

- **Ensure confirm hooks are called if confirmation page is disabled
  ([29710](https://github.com/civicrm/civicrm-core/pull/29710))**

- **Smarty4 -  updates to latest versions Smarty 4.51
  ([393](https://github.com/civicrm/civicrm-packages/pull/393))**

- **Update Smarty5 from rc to 5.0.1 & add loading helper class
  ([394](https://github.com/civicrm/civicrm-packages/pull/394))**

- **Smarty4 & Smarty 5 - update to latest
  ([392](https://github.com/civicrm/civicrm-packages/pull/392))**

- **xml/schema - Fix erroneous description tag
  ([29711](https://github.com/civicrm/civicrm-core/pull/29711))**

- **Move logic from tpl to php layer (extension page)
  ([29898](https://github.com/civicrm/civicrm-core/pull/29898))**

- **Exclude Cancelled & Failed recurring from Autorenew membership reminders
  ([26563](https://github.com/civicrm/civicrm-core/pull/26563))**

- **Fix bug where fields is not present
  ([29681](https://github.com/civicrm/civicrm-core/pull/29681))**

- **Follow up fix on setDefaultValues fix
  ([29685](https://github.com/civicrm/civicrm-core/pull/29685))**

- **Add missing alias trxn_id to transactionID
  ([29683](https://github.com/civicrm/civicrm-core/pull/29683))**

- **Use getters & setters to interact with Smarty properties, where possible
  ([29852](https://github.com/civicrm/civicrm-core/pull/29852))**

- **Update Smarty3 check to refer to Smarty4
  ([29874](https://github.com/civicrm/civicrm-core/pull/29874))**

- **Fix Smarty help function to not call fetchWith
  ([29851](https://github.com/civicrm/civicrm-core/pull/29851))**

- **Extract code to determine rule filter
  ([29877](https://github.com/civicrm/civicrm-core/pull/29877))**

- **Extract code to build table-level filter
  ([29876](https://github.com/civicrm/civicrm-core/pull/29876))**

- **Notice fixes on Contact Edit screen (with multiple contact fields & address
  fields - ie testData extension installed)
  ([29706](https://github.com/civicrm/civicrm-core/pull/29706))**

- **Pass contact Type into sql lookup
  ([29866](https://github.com/civicrm/civicrm-core/pull/29866))**

- **Clarify join type
  ([29865](https://github.com/civicrm/civicrm-core/pull/29865))**

- **Make function private on only caller
  ([29867](https://github.com/civicrm/civicrm-core/pull/29867))**

- **Remove a handling for CRM_Core_Error returned
  ([29797](https://github.com/civicrm/civicrm-core/pull/29797))**

- **Fix deprecation notice
  ([29827](https://github.com/civicrm/civicrm-core/pull/29827))**

- **Fix for `TypeError: array_key_exists(): Argument #2 ($array) must be of type
  array, null given a CRM_Core_DAO->copyValues()
  ([29868](https://github.com/civicrm/civicrm-core/pull/29868))**

- **Stop calling complex function to just add a field
  ([29795](https://github.com/civicrm/civicrm-core/pull/29795))**

- **Simplify a ts
  ([29861](https://github.com/civicrm/civicrm-core/pull/29861))**

- **Deleting profile photo produces error ([dev/core#5145](https://lab.civicrm.org/dev/core/-/issues/5145): [30119](https://github.com/civicrm/civicrm-core/pull/30119))**

- **Deleting an individual contact gives confusing message ([dev/core#5165](https://lab.civicrm.org/dev/core/-/issues/5165), [dev/core#5181](https://lab.civicrm.org/dev/core/-/issues/5181): [30107](https://github.com/civicrm/civicrm-core/pull/30107))**

- **Fix customDataBlock to convert false to 'false' ([dev/core#5152](https://lab.civicrm.org/dev/core/-/issues/5152)): ([30103](https://github.com/civicrm/civicrm-core/pull/30103))**

- **Fix customGroup function overwriting extends data ([dev/core#5149](https://lab.civicrm.org/dev/core/-/issues/5149)): ([29983](https://github.com/civicrm/civicrm-core/pull/29983))**

### CiviCampaign

- **Custom Fields on Campaign are hidden on validation
  ([dev/core#4803](https://lab.civicrm.org/dev/core/-/issues/4803):
  [29751](https://github.com/civicrm/civicrm-core/pull/29751))**

- **show distinct contacts when reserving for a survey
  ([29617](https://github.com/civicrm/civicrm-core/pull/29617))**

### CiviCase

- **accept array of case_type_ids when finding available case statuses
  ([29663](https://github.com/civicrm/civicrm-core/pull/29663))**

### CiviContribute

- **Fix Smarty noticed when contribution tab opened outside of ajax
  ([29672](https://github.com/civicrm/civicrm-core/pull/29672))**

- **Additional Payments form: Use submitted trxn_id if payment result doesn't
  exist ([29869](https://github.com/civicrm/civicrm-core/pull/29869))**

- **Premium Products: allow key=val format for product options
  ([29691](https://github.com/civicrm/civicrm-core/pull/29691))**

- **ContributionProduct - Add serialize metadata
  ([29767](https://github.com/civicrm/civicrm-core/pull/29767))**

### CiviEvent

- **Fix Event register form to call buildAmount exactly once
  ([29900](https://github.com/civicrm/civicrm-core/pull/29900))**

### CiviMail

- **(dev/core#5176) Message Templates - Prevent malformed content, loss of customizations ([30081](https://github.com/civicrm/civicrm-core/pull/30081))**

- **MailSettings - Fix typo in metadata
  ([29769](https://github.com/civicrm/civicrm-core/pull/29769))**

### CiviMember

- **Membership dashboard is not shown
  ([dev/core#5123](https://lab.civicrm.org/dev/core/-/issues/5123):
  [29882](https://github.com/civicrm/civicrm-core/pull/29882) and
  [29883](https://github.com/civicrm/civicrm-core/pull/29883))**

- **Membership terms present in price set not get used in the offline form
  signup. ([dev/core#3752 ](https://lab.civicrm.org/dev/core/-/issues/3752):
  [29730](https://github.com/civicrm/civicrm-core/pull/29730))**

- **Fix override on pending memberships
  ([29661](https://github.com/civicrm/civicrm-core/pull/29661))**

- **E-notice fix on Membership from in edit mode
  ([29744](https://github.com/civicrm/civicrm-core/pull/29744))**

### CiviSMS

- **CiviSMS - Ensure activities are attached to correct contact ([30096](https://github.com/civicrm/civicrm-core/pull/30096))**

### CiviCRM Admin UI

- **Admin UI - Sort by `register_date` Contact Summary Events tab ([30097](https://github.com/civicrm/civicrm-core/pull/30097))**

- **Admin UI - Fix missing translation ([30012](https://github.com/civicrm/civicrm-core/pull/30012))**

- **Admin UI - Fix display of related memberships ([29994](https://github.com/civicrm/civicrm-core/pull/29994))**

### Drupal Integration

- **Check route object exists in processes that do not have routes
  ([90](https://github.com/civicrm/civicrm-drupal-8/pull/90))**

- **Update CiviCRM on Drupal 10: Deprecation Notices regarding TOGoS
  ([dev/core#4919](https://lab.civicrm.org/dev/core/-/issues/4919):
  [29926](https://github.com/civicrm/civicrm-core/pull/29926))**

### Joomla Integration

- **Joomla: fixes broken mobile menu and a small regression.
  ([29939](https://github.com/civicrm/civicrm-core/pull/29939))**

- **CSS: Adds styling resets to Joomla4 for new accordions
  ([29712](https://github.com/civicrm/civicrm-core/pull/29712))**

- **Removes ~90% of joomla.css - much pre-dates Civi 2.x  
  ([27834](https://github.com/civicrm/civicrm-core/pull/27834))**

- **Fixes Joomla regression in #27834 that hides select2 dropdown options when
  used in modal ([29821](https://github.com/civicrm/civicrm-core/pull/29821))**

### Search Kit

- **(dev/core#5126) Fix crash involving Smarty rewrite ([30004](https://github.com/civicrm/civicrm-core/pull/30004))**

- **Fix display of email bounces ([30043](https://github.com/civicrm/civicrm-core/pull/30043))**

- **Fix saving search displays with 'Bypass Permissions' ([30054](https://github.com/civicrm/civicrm-core/pull/30054))**

- **(dev/core#5159) Fix broken NOT CONTAINS operator ([30018](https://github.com/civicrm/civicrm-core/pull/30018))**

### Standalone Integration

- **reenable status messages in standalone page template
  ([29699](https://github.com/civicrm/civicrm-core/pull/29699))**

- **standalone: permanent "session already active" errors
 ([dev/core#5069](https://lab.civicrm.org/dev/core/-/issues/5069):
 [29808](https://github.com/civicrm/civicrm-core/pull/29808))**

- **standalone: rebase @pfigel's JWT password reset PR 28505
  ([29642](https://github.com/civicrm/civicrm-core/pull/29642))**

- **standalone: prevent installer using secret admin pass. Fixes 5038
  ([29641](https://github.com/civicrm/civicrm-core/pull/29641))**

### WordPress Integration

- **Possible WordPress regression - event that fails validation or has code
  submitted redirects to back office page
  ([dev/core#5127](https://lab.civicrm.org/dev/core/-/issues/5127):
  [321](https://github.com/civicrm/civicrm-wordpress/pull/321))**

## <a name="misc"></a>Miscellany

- **Switch getPreviousFinancialItem() to use API4 internally
  ([29761](https://github.com/civicrm/civicrm-core/pull/29761))**

- **Deprecate formatPhone, use new cut down private function
  ([29742](https://github.com/civicrm/civicrm-core/pull/29742))**

- **APIv4 - Move MembershipLinksProvider to correct directory
  ([29746](https://github.com/civicrm/civicrm-core/pull/29746))**

- **Add validate.tpl to customDataBlock, minor cleanup
  ([29812](https://github.com/civicrm/civicrm-core/pull/29812))**

- **Register trim as a smarty plugin
  ([29759](https://github.com/civicrm/civicrm-core/pull/29759))**

- **Updating php-weasyprint to latest version
  ([29697](https://github.com/civicrm/civicrm-core/pull/29697))**

- **Add deprecation tag at class level
  ([29696](https://github.com/civicrm/civicrm-core/pull/29696))**

- **Improve visibility of what functions are called on backoffice Contact form
  ([29674](https://github.com/civicrm/civicrm-core/pull/29674))**

- **Deprecated smarty modifier
  ([29755](https://github.com/civicrm/civicrm-core/pull/29755))**

- **Make everyone share my pain
  ([29479](https://github.com/civicrm/civicrm-core/pull/29479))**

- **Add deprecation to class comment
  ([29839](https://github.com/civicrm/civicrm-core/pull/29839))**

- **Panacea for brain pain
  ([29838](https://github.com/civicrm/civicrm-core/pull/29838))**

- **Port one more function to Smarty2
  ([395](https://github.com/civicrm/civicrm-packages/pull/395))**

- **distmaker - Add `iframe` and `oembed` (5.73-rc)
  ([29917](https://github.com/civicrm/civicrm-core/pull/29917))**

- **Remove smarty function ported (hacked) to Smarty2
  ([29846](https://github.com/civicrm/civicrm-core/pull/29846))**

- **Remove ornery from now-compliant tests
  ([29816](https://github.com/civicrm/civicrm-core/pull/29816))**

- **Fold private function back into only caller
  ([29762](https://github.com/civicrm/civicrm-core/pull/29762))**

- **Use smarty capitalize instead of ucfirst
  ([29815](https://github.com/civicrm/civicrm-core/pull/29815))**

- **Remove deprecated misspelled event
  ([29757](https://github.com/civicrm/civicrm-core/pull/29757))**

- **Remove unused variable
  ([29727](https://github.com/civicrm/civicrm-core/pull/29727))**

- **Remove a couple on handlings for no-longer returned CRM_Core_Error
  ([29136](https://github.com/civicrm/civicrm-core/pull/29136))**

- **Copy small functions back to callers
  ([29758](https://github.com/civicrm/civicrm-core/pull/29758))**

- **Make code clearer
  ([29836](https://github.com/civicrm/civicrm-core/pull/29836))**

- **Replace CRM_Utils_Array::value
  ([29684](https://github.com/civicrm/civicrm-core/pull/29684))**

- **Post split clean up - stop calling this form
  ([29811](https://github.com/civicrm/civicrm-core/pull/29811))**

- **Post split code cleanup
  ([29810](https://github.com/civicrm/civicrm-core/pull/29810))**

- **Copy function back to one of the few remaining callers
  ([29802](https://github.com/civicrm/civicrm-core/pull/29802))**

- **Post split tidy up - remove extraneous subType handling
  ([29819](https://github.com/civicrm/civicrm-core/pull/29819))**

- **Post split tidy up - remove multiple setting of Group Count
  ([29818](https://github.com/civicrm/civicrm-core/pull/29818))**

- **Post split tidy up - consistent treatment of contactID
  ([29814](https://github.com/civicrm/civicrm-core/pull/29814))**

- **Post split cleanup - fold private function back into caller
  ([29820](https://github.com/civicrm/civicrm-core/pull/29820))**

- **Some post split cleanup
  ([29804](https://github.com/civicrm/civicrm-core/pull/29804))**

- **Remove unreachable code
  ([29794](https://github.com/civicrm/civicrm-core/pull/29794))**

- **Fold preProcess function from Custom data form back to only caller
  ([29687](https://github.com/civicrm/civicrm-core/pull/29687))**

- **Copy complex function back to calling class for simplifying
  ([29689](https://github.com/civicrm/civicrm-core/pull/29689))**

- **Minor cleanup
  ([29678](https://github.com/civicrm/civicrm-core/pull/29678))**

- **Copy function back to only calling class
  ([29686](https://github.com/civicrm/civicrm-core/pull/29686))**

- **Post copy back clean up
  ([29690](https://github.com/civicrm/civicrm-core/pull/29690))**

- **standaloneusers tests - error message assertions are too strict
  ([29824](https://github.com/civicrm/civicrm-core/pull/29824))**

- **allow standalone's alternative access denied wording in afform test
  ([29849](https://github.com/civicrm/civicrm-core/pull/29849))**

- **Minor test clean up
  ([29801](https://github.com/civicrm/civicrm-core/pull/29801))**

- **Add test check on imported multple fields
  ([29737](https://github.com/civicrm/civicrm-core/pull/29737))**

- **Schema - Update autoincrement to reflect what it actually is
  ([29709](https://github.com/civicrm/civicrm-core/pull/29709))**

- **Update contributor-key.yml
  ([29731](https://github.com/civicrm/civicrm-core/pull/29731))**

- **Copy shared function back to form as private function
  ([29803](https://github.com/civicrm/civicrm-core/pull/29803))**

- **Add tests for unsubscribing from mail groups
  ([29790](https://github.com/civicrm/civicrm-core/pull/29790))**

- **Reworking of unsubscribe tests in #29790, add grandparent and smart groups
  ([29830](https://github.com/civicrm/civicrm-core/pull/29830))**

- **Minor clean up in test class
  ([29729](https://github.com/civicrm/civicrm-core/pull/29729))**

- **Make private function non static
  ([29728](https://github.com/civicrm/civicrm-core/pull/29728))**

- **Suppress last php8.2 test fail for PR tests  
  ([29680](https://github.com/civicrm/civicrm-core/pull/29680))**

- **PHP8.2 Fix Financial Account form to load custom data via ajax
  ([29241](https://github.com/civicrm/civicrm-core/pull/29241))**

- **[php8.2] Fix MembershipType + other entityFormTrait uses for php8.2
  ([29671](https://github.com/civicrm/civicrm-core/pull/29671))**

- **[php8.2], [bug-fix] Fix default value loading for multiple custom fields
  ([29708](https://github.com/civicrm/civicrm-core/pull/29708))**

- **[php8.2] Finish consolidating customData code on the Contact form
  ([29792](https://github.com/civicrm/civicrm-core/pull/29792))**

- **php8.2 Remove non-compliant code replaced by jquery validation
  ([29793](https://github.com/civicrm/civicrm-core/pull/29793))**

- **[php8.2] Fix Campaign form custom data for php8,2
  ([29657](https://github.com/civicrm/civicrm-core/pull/29657))**

- **[Php8.2] Fix relationship form to use preferred php8.2 compliant methods
  ([29652](https://github.com/civicrm/civicrm-core/pull/29652))**

- **[php8.2] Share Custom data fixes from Membership form to renewal
  ([29592](https://github.com/civicrm/civicrm-core/pull/29592))**

- **[php8.2] Apply custom data handling improvements to grant form  
  ([29651](https://github.com/civicrm/civicrm-core/pull/29651))**

- **[php8.2]  compliant ajax method for custom data on pledge form
  ([29228](https://github.com/civicrm/civicrm-core/pull/29228))**

- **[php8.2] apply php8.2 clean up to contribution form custom data
  ([29655](https://github.com/civicrm/civicrm-core/pull/29655))**

- **[php8.2] apply php8.2 clean up to activity form custom data
  ([29656](https://github.com/civicrm/civicrm-core/pull/29656))**

- **[php8.2] Fix Survey configuration forms for  custom data for php8.2
  ([29660](https://github.com/civicrm/civicrm-core/pull/29660))**

- **(php83) UnitTests - Fix warning
  ([29785](https://github.com/civicrm/civicrm-core/pull/29785))**

- **Possible fix for export test on php8.3
  ([29688](https://github.com/civicrm/civicrm-core/pull/29688))**

- **Extract isUseReservedQuery
  ([29864](https://github.com/civicrm/civicrm-core/pull/29864))**

- **[REF] Extract function to get the ContactIDFieldName
  ([29873](https://github.com/civicrm/civicrm-core/pull/29873))**

- **[REF] Pass IP address to Elavon when submitting credit card payment
  ([29791](https://github.com/civicrm/civicrm-core/pull/29791))**

- **Refactor template assignments off deprecated CRM_Utils_Array::value
  ([29780](https://github.com/civicrm/civicrm-core/pull/29780))**

- **Refactor out calls to deprecated CRM_Utils_Array::value()
  ([29779](https://github.com/civicrm/civicrm-core/pull/29779))**

- **(NFC) gitignore - Don't care about .composer-downloads
  ([29826](https://github.com/civicrm/civicrm-core/pull/29826))**

- **(NFC) Contribute/Product.xml - No newline in comment
  ([29825](https://github.com/civicrm/civicrm-core/pull/29825))**

- **Update TCPDF ([29969](https://github.com/civicrm/civicrm-core/pull/29969), [30027](https://github.com/civicrm/civicrm-core/pull/30027))**

- **Fix regen.sh ([29997](https://github.com/civicrm/civicrm-core/pull/29997), [29998](https://github.com/civicrm/civicrm-core/pull/29998))**

- **[php8] Update compile-plugin to v0.20 ([29972](https://github.com/civicrm/civicrm-core/pull/29972))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Agileware Team, Francis Whittle; Artful
Robot - Rich Lott; Benjamin W; Christian Wach; Circle Interactive - Pradeep
Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk -
Yashodha Chaku; civiservice.de - Detlev Sieber; Coop SymbioTIC - Mathieu Lutfy;
Dave D; Francesc Bassas i Bullich; Fuzion - Jitendra Purohit, Luke Stewart;
Gokhalemethod - Sadashiv; Greenpeace Central and Eastern Europe - Patrick Figel;
iXiam - Albert Vall-Llovera; JMA Consulting - Seamus Lee; MJW Consulting -
Matthew Wire; Nicol Wistreich; MetaDrop - Omar Mohamad; Progressive Technology
Project - Jamie McClelland; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

CiviCoop - Erik Hommel; devappsoftware; gibsonoliver; MC3 - Graham Mitchell;
Megaphone Technology Consulting - Brienne Kordis, Jon Goldberg; Systopia -
Johannes Franz; Wildsight - Lars Sander-Green

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
