# CiviCRM 5.70.0

Released February 8, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)** 

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |         |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     | **yes** |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Work towards replacing Contact Summary Activities tab 
  ([27717](https://github.com/civicrm/civicrm-core/pull/27717), disabled for 
  now via [29209](https://github.com/civicrm/civicrm-core/pull/29209))**

  This work was disabled for now, but there is ongoing effort to replace the 
  Activities tab on the contact record with one generated from FormBuilder.

- **Add system check to warn if CiviReport disabled & logging enabled 
  ([28863](https://github.com/civicrm/civicrm-core/pull/28863))**

  If a site admin enables logging & disables CiviReport this warns admins that the logging tab becomes at least partially unavailable.

- **Dashboard Fullscreen dashlet improvements 
  ([28641](https://github.com/civicrm/civicrm-core/pull/28641))**

  This improves the styling of full-screen dashlets.

- **APIv4 - Add fk_column to getFields metadata 
  ([28850](https://github.com/civicrm/civicrm-core/pull/28850))**

  Improves APIv4 getFields metadata to include the name of the FK column in addition to the FK entity.

### CiviContribute

- **Support creating payment methods that can be hidden from user 
  ([28876](https://github.com/civicrm/civicrm-core/pull/28876))**

  A new `filter` property of payment instruments allows an extension to mark
  payment instruments that should not appear in the UI for contributions and
  payments.

- **Add "Manage Premiums" to AdminUI, toward  dev/core#3912 
  ([28540](https://github.com/civicrm/civicrm-core/pull/28540))**

  The Manage Premiums screen is now produced by FormBuilder.

- **Move implementation of financial type acl out of core (leverage existing 
  extension hooks) 
  ([28647](https://github.com/civicrm/civicrm-core/pull/28647))**

### CiviEvent

- **Consolidate participant creation into 1 place 
  ([28778](https://github.com/civicrm/civicrm-core/pull/28778))**

  This refactors the code for participant creation to be simpler and more 
  consistent.

- **Remove text version on online event receipt 
  ([28732](https://github.com/civicrm/civicrm-core/pull/28732))**

  Similar to other recent changes, the plain-text version of the default online event registration receipt is removed, so the email system simply
  reverts to a plain-text extraction of the HTML version.

### CiviMail

- **CiviMail - Add support for `List-Unsubscribe=One-Click` 
  ([dev/core#4641](https://lab.civicrm.org/dev/core/-/issues/4641): 
  [28964](https://github.com/civicrm/civicrm-core/pull/28964) and 
  [29086](https://github.com/civicrm/civicrm-core/pull/29086))**

  This now submits a list unsubscription header for CiviMail messages with a
  URL to record unsubscription rather than the unsubscribe email address (which
  may not be handled in many configurations).

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Angular manager module caching issue (TypeError in_array) 
  ([dev/core#4969](https://lab.civicrm.org/dev/core/-/issues/4969): 
  [29260](https://github.com/civicrm/civicrm-core/pull/29260))**

- **Php 8.x notice fix on tags & groups fields 
  ([29226](https://github.com/civicrm/civicrm-core/pull/29226))**

- **SearchKit - Remove irrelevant links from default display 
  ([29208](https://github.com/civicrm/civicrm-core/pull/29208))**

- **SearchKit/API4: 'getFieldValue failed' error for group contacts 
  ([dev/core#4961](https://lab.civicrm.org/dev/core/-/issues/4961): 
  [29206](https://github.com/civicrm/civicrm-core/pull/29206))**

- **SearchKit - Fix switching to nonexistent tab 
  ([29180](https://github.com/civicrm/civicrm-core/pull/29180))**

- **Resource URLs page doesn't load with Smarty3 
  ([dev/core#4962](https://lab.civicrm.org/dev/core/-/issues/4962): 
  [29203](https://github.com/civicrm/civicrm-core/pull/29203))**

- **SearchKit - Fix missing transformations in UI 
  ([29025](https://github.com/civicrm/civicrm-core/pull/29025))**

- **Fix fatal error when firebase/php-jwt library is 'replaced' in composer 
  ([28971](https://github.com/civicrm/civicrm-core/pull/28971), [29345](https://github.com/civicrm/civicrm-core/pull/29345))**

- **Remove attempt to use wizard on manage ACLs 
  ([29107](https://github.com/civicrm/civicrm-core/pull/29107))**

- **FormBuilder forms with yes/no and autocomplete fail in Firefox 
  ([dev/core#4937](https://lab.civicrm.org/dev/core/-/issues/4937): 
  [29092](https://github.com/civicrm/civicrm-core/pull/29092))**

- **crmDashboard - Fix deleting item from 2nd column 
  ([29155](https://github.com/civicrm/civicrm-core/pull/29155))**

- **Saving a civireport causes the report to crash with `TypeError: Cannot 
  access offset of type string on string in HTML_QuickForm_advmultiselect->toHtml` 
  ([dev/core#4938](https://lab.civicrm.org/dev/core/-/issues/4938): 
  [29097](https://github.com/civicrm/civicrm-core/pull/29097))**

- **Invert logic for collapsing contact dashboard accordion 
  ([29091](https://github.com/civicrm/civicrm-core/pull/29091))**

- **Activity count is incorrect if contact is source and target 
  ([dev/core#4930](https://lab.civicrm.org/dev/core/-/issues/4930): 
  [29073](https://github.com/civicrm/civicrm-core/pull/29073))**

- **dev/core#4932 - Bring back missing actions when viewing contact summary 
  ([29079](https://github.com/civicrm/civicrm-core/pull/29079))**

- **Contact Relationships: alter markup for help texts 
  ([29058](https://github.com/civicrm/civicrm-core/pull/29058))**

- **Fix missing links on contact summary relationships tab 
  ([29049](https://github.com/civicrm/civicrm-core/pull/29049))**

- **ContactSummary - Don't open new tab for links 
  ([29039](https://github.com/civicrm/civicrm-core/pull/29039))**
  
  This fixes new tabs opening when clicking links from the relationships tab

- **Create New Contact with Sub-Type Brings Up Wrong Custom Field Sets 
  ([dev/core#4910](https://lab.civicrm.org/dev/core/-/issues/4910): 
  [29003](https://github.com/civicrm/civicrm-core/pull/29003))**

- **CiviCRM 5.67.0 - PHP Fatal error: Uncaught `TypeError: 
  CRM_Import_Parser::getFieldMetadata` when using a Import Mappings 
  ([dev/core#4781](https://lab.civicrm.org/dev/core/-/issues/4781): 
  [28933](https://github.com/civicrm/civicrm-core/pull/28933))**

- **Regression: fix CMS creation issue from profile 
  ([28970](https://github.com/civicrm/civicrm-core/pull/28970))**

- **New Individual on-the-fly popup has `Undefined variable $cancelURL` 
  ([dev/core#4903](https://lab.civicrm.org/dev/core/-/issues/4903): 
  [28962](https://github.com/civicrm/civicrm-core/pull/28962))**

- **Regression - missing getLinks fails too hard 
  ([dev/core#4898](https://lab.civicrm.org/dev/core/-/issues/4898): 
  [28952](https://github.com/civicrm/civicrm-core/pull/28952))**

- **Search Kit row links with comparison conditions broken 
  ([dev/core#4897](https://lab.civicrm.org/dev/core/-/issues/4897): 
  [28944](https://github.com/civicrm/civicrm-core/pull/28944))**

- **[PHP 8.1] Weight notices 
  ([dev/core#4892](https://lab.civicrm.org/dev/core/-/issues/4892) and 
  [dev/core#4891](https://lab.civicrm.org/dev/core/-/issues/4891): 
  ([28931](https://github.com/civicrm/civicrm-core/pull/28931))**

  This resolves notices at the trash contact folder and the import-export 
  mappings

- **deleted-files-list needs some fine-tuning 
  ([dev/core#4889](https://lab.civicrm.org/dev/core/-/issues/4889): 
  [28922](https://github.com/civicrm/civicrm-core/pull/28922))**

- **"Done" buttons are misaligned 
  ([dev/user-interface#64](https://lab.civicrm.org/dev/user-interface/-/issues/64): 
  [28907](https://github.com/civicrm/civicrm-core/pull/28907))**

- **(alternate 2) Fix bad smarty3 compile filenames 
  ([28909](https://github.com/civicrm/civicrm-core/pull/28909))**

- **Smarty Syntax fix - UFGroup help file 
  ([28901](https://github.com/civicrm/civicrm-core/pull/28901))**

- **Add report instance permission check & test 
  ([28873](https://github.com/civicrm/civicrm-core/pull/28873))**

- **Fix month date string format support in imports 
  ([28716](https://github.com/civicrm/civicrm-core/pull/28716))**

- **faster activity counting 
  ([28529](https://github.com/civicrm/civicrm-core/pull/28529))**

  Activity counts now use API v4 rather than API v3.

- **Minor cleanup in ReportInstance BAO 
  ([28866](https://github.com/civicrm/civicrm-core/pull/28866))**

- **Fix notice in workflow message examples when no price set present 
  ([28848](https://github.com/civicrm/civicrm-core/pull/28848))**

- **Fix time handling for dd_mon_yy format date strings 
  ([28847](https://github.com/civicrm/civicrm-core/pull/28847))**

- **Fix notice on civi-report display 
  ([28859](https://github.com/civicrm/civicrm-core/pull/28859))**

- **unable to install social_auth_google 4.0 
  ([dev/core#3581](https://lab.civicrm.org/dev/core/-/issues/4851): 
  [28757](https://github.com/civicrm/civicrm-core/pull/28757))**

- **Fix handling of non-padded day in import date in dd/mm/yyy format 
  ([28844](https://github.com/civicrm/civicrm-core/pull/28844))**

- **Fix time validation for iso date format (
  [28828](https://github.com/civicrm/civicrm-core/pull/28828))**

- **Fix e-notice on contact create for low-permissioned user ([28837](https://github.com/civicrm/civicrm-core/pull/28837))**

- **dev/core#4674 - Add Oauth links for AdminUi MailSettings ([28786](https://github.com/civicrm/civicrm-core/pull/28786))**

- **Issue 4879 second attempt ([28838](https://github.com/civicrm/civicrm-core/pull/28838))**

- **Remove smarty2 functions from sample code ([28831](https://github.com/civicrm/civicrm-core/pull/28831))**

- **Use getTemplateVars in smarty help function ([28829](https://github.com/civicrm/civicrm-core/pull/28829))**

- **Replace getTemplateVars() in test, assignTemplateVariables ([28830](https://github.com/civicrm/civicrm-core/pull/28830))**

- **standalone: implement cms-prefixed permissions as concrete ones ([28621](https://github.com/civicrm/civicrm-core/pull/28621))**

- **Remove missingStandaloneExtension() checks which were pre-alpha scaffold ([28833](https://github.com/civicrm/civicrm-core/pull/28833))**

- **Merging as no objections ([28784](https://github.com/civicrm/civicrm-core/pull/28784))**

- **Use distinct test workflow message for workflow message tests ([28826](https://github.com/civicrm/civicrm-core/pull/28826))**

- **SearchKit - New getLinks API action for advanced link handling ([27973](https://github.com/civicrm/civicrm-core/pull/27973))**

- **Update `MessageTemplates` generation to work with Smarty3 ([28789](https://github.com/civicrm/civicrm-core/pull/28789))**

- **Remove function use of reference ([28825](https://github.com/civicrm/civicrm-core/pull/28825))**

- **Extend date formats being tested ([28822](https://github.com/civicrm/civicrm-core/pull/28822))**

- **Use constants for date formats ([28823](https://github.com/civicrm/civicrm-core/pull/28823))**

- **Fully deprecate MetadataTrait ([28556](https://github.com/civicrm/civicrm-core/pull/28556))**

- **Fix error due to merges co-inciding ([28821](https://github.com/civicrm/civicrm-core/pull/28821))**

- **SearchKit - Allow aggregate functions to be used without GroupBy ([28808](https://github.com/civicrm/civicrm-core/pull/28808))**

- **Merge forward (5.69-rc to master) ([28818](https://github.com/civicrm/civicrm-core/pull/28818))**

- **SearchKit - Fix wrong column being removed from displays ([28811](https://github.com/civicrm/civicrm-core/pull/28811))**

- **APIv4 - Hide 'contact_type' from Individual,Organization,Household getFields ([28812](https://github.com/civicrm/civicrm-core/pull/28812))**

- **[REF][PHP8.2] Declare _lastParticipant property ([28783](https://github.com/civicrm/civicrm-core/pull/28783))**

- **[REF][PHP8.2] Declare missing properties on CRM_Event_Form_Registration_AdditionalParticipant ([28815](https://github.com/civicrm/civicrm-core/pull/28815))**

- **dev/core#4841 Ensure that APIv4 have same default values which ensure… ([28775](https://github.com/civicrm/civicrm-core/pull/28775))**

- **[REF][PHP8.2] Cleanup discounts property in eventcart ext ([28816](https://github.com/civicrm/civicrm-core/pull/28816))**

- **Stop bypassing hooks on ContributionRecur.cancel ([28730](https://github.com/civicrm/civicrm-core/pull/28730))**

- **Consolidate import date handling ([28799](https://github.com/civicrm/civicrm-core/pull/28799))**

- **Clean up search settings page, update group cache text ([28753](https://github.com/civicrm/civicrm-core/pull/28753))**

- **Bubble up deprecation if getVar used to get a deprecated property ([28748](https://github.com/civicrm/civicrm-core/pull/28748))**

- **Don't try to insert 0 as a user_id to ACL contact cache ([28814](https://github.com/civicrm/civicrm-core/pull/28814))**

- **Remove unused phantomjs-polyfill package ([28813](https://github.com/civicrm/civicrm-core/pull/28813))**

- **Remove api annotation from getSubmittableFields() ([28776](https://github.com/civicrm/civicrm-core/pull/28776))**

- **5.69 to master ([28809](https://github.com/civicrm/civicrm-core/pull/28809))**

- **Update regen for event message template ([28804](https://github.com/civicrm/civicrm-core/pull/28804))**

- **E-notice fix in membership workflow examples ([28803](https://github.com/civicrm/civicrm-core/pull/28803))**

- **NFC Superficial cleanup in test class ([28798](https://github.com/civicrm/civicrm-core/pull/28798))**

- **[NFC] Add todos to the invoice code ([28805](https://github.com/civicrm/civicrm-core/pull/28805))**

- **Fix edit button for 'Import/Export Mapping' ([28801](https://github.com/civicrm/civicrm-core/pull/28801))**

- **[NFC] Superficial cleanup ([28797](https://github.com/civicrm/civicrm-core/pull/28797))**

- **Fix codeGen assign to do what it says on the box ([28788](https://github.com/civicrm/civicrm-core/pull/28788))**

- **menubar spin: stop after 10 seconds ([28738](https://github.com/civicrm/civicrm-core/pull/28738))**

- **update deleted files list ([28794](https://github.com/civicrm/civicrm-core/pull/28794))**

- **5.69 ([28793](https://github.com/civicrm/civicrm-core/pull/28793))**

- **Migrate Snappy to composer ([28673](https://github.com/civicrm/civicrm-core/pull/28673))**

- **5.69 to master ([28792](https://github.com/civicrm/civicrm-core/pull/28792))**

- **Manage Extensions: hide the type/module column ([28782](https://github.com/civicrm/civicrm-core/pull/28782))**

- **Remove str_contains from civicrm.settings template ([28790](https://github.com/civicrm/civicrm-core/pull/28790))**

- **Standardise `getTemplateVars()` ([28787](https://github.com/civicrm/civicrm-core/pull/28787))**

- **remove incorrect message that grant could not be deleted ([28785](https://github.com/civicrm/civicrm-core/pull/28785))**

- **Compiance with php8 & Marvel9 ([28780](https://github.com/civicrm/civicrm-core/pull/28780))**

- **Remove checks to bltID in cms classes ([28771](https://github.com/civicrm/civicrm-core/pull/28771))**

- **Stop referring to `_bltID` in AbstractEditPayment ([28770](https://github.com/civicrm/civicrm-core/pull/28770))**

- **Declare caseId, caseIds as public properties ([28760](https://github.com/civicrm/civicrm-core/pull/28760))**

- **[PHP8.2] Fix test fails on event cart ([28773](https://github.com/civicrm/civicrm-core/pull/28773))**

- **[REF][PHP8.2] Use correct form object to ensure properties exist ([28758](https://github.com/civicrm/civicrm-core/pull/28758))**

- **Remove deprecated test-only function ([28768](https://github.com/civicrm/civicrm-core/pull/28768))**

- **Use local variables for the billing location type ID in event cart code ([28764](https://github.com/civicrm/civicrm-core/pull/28764))**

- **[REF] Tidy up use of _cancelURL property ([28759](https://github.com/civicrm/civicrm-core/pull/28759))**

- **Remove bltID as a parameter from getPaymentProcessorReadyAddressParams ([28767](https://github.com/civicrm/civicrm-core/pull/28767))**

- **[REF][PHP8.2] Resolve dynamic property usage in CRM_Price_Form_Option ([28456](https://github.com/civicrm/civicrm-core/pull/28456))**

- **Unit test for fix to illegal offset error when grouping by contact in SK ([28739](https://github.com/civicrm/civicrm-core/pull/28739))**

- **Fix a few more places that pass bltID to mapParams ([28765](https://github.com/civicrm/civicrm-core/pull/28765))**

- **Stop setting `_bltID` on the `UpdateBilling` form ([28761](https://github.com/civicrm/civicrm-core/pull/28761))**

- **Use lookup not form property for BillingID in payment form class ([28763](https://github.com/civicrm/civicrm-core/pull/28763))**

- **[REF][PHP8.2] Local variable for tagGroup ([28755](https://github.com/civicrm/civicrm-core/pull/28755))**

- **dev/user-interface#49 - Improve SearchKit admin display presentation ([28740](https://github.com/civicrm/civicrm-core/pull/28740))**

- **Add weasyprint pdf generation as alternative to wkhtmltopdf ([28273](https://github.com/civicrm/civicrm-core/pull/28273))**

- **[REF][PHP8.2] Declare properties in advanced search form ([28754](https://github.com/civicrm/civicrm-core/pull/28754))**

- **tests/events/*.php - Allow optional runtime enforcement ([28723](https://github.com/civicrm/civicrm-core/pull/28723))**

- **Standardise some more event template tokens ([27685](https://github.com/civicrm/civicrm-core/pull/27685))**

- **[REF][PHP8.2] Replace dynamic property with local var - mailing browse page ([28756](https://github.com/civicrm/civicrm-core/pull/28756))**

- **Update regen online script to use php 8.1 since this doesn't have polyfills available and now str_contains makes it fail ([28751](https://github.com/civicrm/civicrm-core/pull/28751))**

- **regen after 28704 ([28752](https://github.com/civicrm/civicrm-core/pull/28752))**

- **Alternate to alternate packages path for smarty3 ([28749](https://github.com/civicrm/civicrm-core/pull/28749))**

- **Remove some more text template versions ([28704](https://github.com/civicrm/civicrm-core/pull/28704))**

- **Merge 5.69 to master ([28747](https://github.com/civicrm/civicrm-core/pull/28747))**

- **Fix admin forms to not call deprecated functions ([28746](https://github.com/civicrm/civicrm-core/pull/28746))**

- **Fix acls in demo data ([28743](https://github.com/civicrm/civicrm-core/pull/28743))**

- **False positive in status check ([28736](https://github.com/civicrm/civicrm-core/pull/28736))**

- **Allow searchkit joins via EntityRef fields in multivalue custom data ([28721](https://github.com/civicrm/civicrm-core/pull/28721))**

- **Fix PHP warning: trying to use null as array ([28734](https://github.com/civicrm/civicrm-core/pull/28734))**

- **Extract chunk of code to function ([28731](https://github.com/civicrm/civicrm-core/pull/28731))**

- **Fix notice, undefined property on Pcp page ([28728](https://github.com/civicrm/civicrm-core/pull/28728))**

- **Enable Smarty3, smarty notices  by default for all localhost or demo builds ([28725](https://github.com/civicrm/civicrm-core/pull/28725))**

- **Deprecate less reliable contributionPage api functions ([28729](https://github.com/civicrm/civicrm-core/pull/28729))**

- **WIP: Fix dev/core#4813: CRM_Report_Form_Activity: Add Employer fields, and… ([28708](https://github.com/civicrm/civicrm-core/pull/28708))**

- **dev/user-interface#49  - SearchKit: improve tabbed interface ([28688](https://github.com/civicrm/civicrm-core/pull/28688))**

- **Revert changes that I strongly oppose that were forced through whilst I was asleep ([28719](https://github.com/civicrm/civicrm-core/pull/28719))**

- **Standalone session management ([28537](https://github.com/civicrm/civicrm-core/pull/28537))**

- **Fix notice on rendering examples when no contribution pages exist ([28714](https://github.com/civicrm/civicrm-core/pull/28714))**

- **5.69 to master ([28717](https://github.com/civicrm/civicrm-core/pull/28717))**

- **regen after 28705 ([28715](https://github.com/civicrm/civicrm-core/pull/28715))**

- **Add test cover for Dummy warnings ([28713](https://github.com/civicrm/civicrm-core/pull/28713))**

- **Fix notice in participant_cancelled email ([28705](https://github.com/civicrm/civicrm-core/pull/28705))**

- **Replace deprecated invoice settings ([28710](https://github.com/civicrm/civicrm-core/pull/28710))**

- **ReportInstance - Cleanup BAO::add function and DAO metadata ([28707](https://github.com/civicrm/civicrm-core/pull/28707))**

- **[php8.x] Remove unused undeclared property `_params`, provide __get for transitional support ([28701](https://github.com/civicrm/civicrm-core/pull/28701))**

- **Revert "Remove parent-declared properties" ([28706](https://github.com/civicrm/civicrm-core/pull/28706))**

- **dev/core#2607 - Maintain list of deleted files ([28653](https://github.com/civicrm/civicrm-core/pull/28653))**

- **Remove parent-declared properties ([28703](https://github.com/civicrm/civicrm-core/pull/28703))**

- **Stop ignoring tests when apiv4 function does not exist ([28697](https://github.com/civicrm/civicrm-core/pull/28697))**

- **DAO - Remove fieldKeys(), getLog() and getTableName() ([28666](https://github.com/civicrm/civicrm-core/pull/28666))**

- **5.69 ([28698](https://github.com/civicrm/civicrm-core/pull/28698))**

- **Remove deprecated function `initSet` ([28676](https://github.com/civicrm/civicrm-core/pull/28676))**

- **Stop setting front-end values in back office form ([28678](https://github.com/civicrm/civicrm-core/pull/28678))**

- **Standardise fetching of variables on recur management screens ([28652](https://github.com/civicrm/civicrm-core/pull/28652))**

- **Stop comparing status_id with membership type in test ([28687](https://github.com/civicrm/civicrm-core/pull/28687))**

- **Update package lock for newer npm versions ([28691](https://github.com/civicrm/civicrm-core/pull/28691))**

- **5.69 ([28690](https://github.com/civicrm/civicrm-core/pull/28690))**

- **Test update - use apiv4 to set up for test ([28674](https://github.com/civicrm/civicrm-core/pull/28674))**

- **dev/core#4866 tag search fix ([28681](https://github.com/civicrm/civicrm-core/pull/28681))**

- **5.69 ([28685](https://github.com/civicrm/civicrm-core/pull/28685))**

- **Set formBuilt to TRUE when, erm, it is built ([28682](https://github.com/civicrm/civicrm-core/pull/28682))**

- **Replace undeclared property with local variable ([28679](https://github.com/civicrm/civicrm-core/pull/28679))**

- **5.69 ([28683](https://github.com/civicrm/civicrm-core/pull/28683))**

- **Minor variable standardisation in test ([28675](https://github.com/civicrm/civicrm-core/pull/28675))**

- **[REF] Change LineItem.qty to be CRM type of FLOAT rather than Money a… ([28464](https://github.com/civicrm/civicrm-core/pull/28464))**

- **Cleanup membership Types in test ([28671](https://github.com/civicrm/civicrm-core/pull/28671))**

- **[PHP8] Remove unneeded $this->_context in Case_Page_Tab ([28669](https://github.com/civicrm/civicrm-core/pull/28669))**

- **5.69 ([28667](https://github.com/civicrm/civicrm-core/pull/28667))**

- **regen after 28633 ([28664](https://github.com/civicrm/civicrm-core/pull/28664))**

- **5.69 ([28663](https://github.com/civicrm/civicrm-core/pull/28663))**

- **Remove the text versions of a few more template ([28633](https://github.com/civicrm/civicrm-core/pull/28633))**

- **Metadata - Refresh clientside resources when clearing cache 
  ([28442](https://github.com/civicrm/civicrm-core/pull/28442) and 
  [29072](https://github.com/civicrm/civicrm-core/pull/29072))**

- **dev/core#4835 Standalone Permissions user interface ([28523](https://github.com/civicrm/civicrm-core/pull/28523))**

- **Remove front-end-only optionFullIds handling from back office form ([28654](https://github.com/civicrm/civicrm-core/pull/28654))**

- **Update updateSubscriptionTest to use`FormTestTrait` ([28651](https://github.com/civicrm/civicrm-core/pull/28651))**

- **adds Manage Events ([28476](https://github.com/civicrm/civicrm-core/pull/28476))**

- **Fix missing blank href attr on <a> links in searchkit angular ([28466](https://github.com/civicrm/civicrm-core/pull/28466))**

- **RelationshipCache - Add status check to ensure cache table is up-to-date ([28660](https://github.com/civicrm/civicrm-core/pull/28660))**

- **Add standardised form get traits ([28656](https://github.com/civicrm/civicrm-core/pull/28656))**

- **Unshare init event fee ([28657](https://github.com/civicrm/civicrm-core/pull/28657))**

- **Remove extraneous call to check financial acl ([28649](https://github.com/civicrm/civicrm-core/pull/28649))**

- **5.69 to master ([28655](https://github.com/civicrm/civicrm-core/pull/28655))**

- **APIv4 - Super-admins don't always have access to everything ([28445](https://github.com/civicrm/civicrm-core/pull/28445))**

- **ConfigTaskList: a few language tweaks and add reference to CiviCRM themes ([28588](https://github.com/civicrm/civicrm-core/pull/28588))**

- **Unshare `buildAmount` block functions from front_end form ([28646](https://github.com/civicrm/civicrm-core/pull/28646))**

- **Fix notices on tasks for less permissioned user ([28648](https://github.com/civicrm/civicrm-core/pull/28648))**

- **[php8.x] Fully remove interaction with `_params` from backoffice participant form ([28645](https://github.com/civicrm/civicrm-core/pull/28645))**

- **Use local array for tax_amount  ([28640](https://github.com/civicrm/civicrm-core/pull/28640))**

- **5.69 ([28644](https://github.com/civicrm/civicrm-core/pull/28644))**

- **Remove unused function variable ([28639](https://github.com/civicrm/civicrm-core/pull/28639))**

- **[REF][PHP8.2] Add PHP8.2 support to CRM_Contact_Page_View_Summary ([28589](https://github.com/civicrm/civicrm-core/pull/28589))**

- **PHP 7.4 - Simplify expressions with null coalescing assignment operator ([28631](https://github.com/civicrm/civicrm-core/pull/28631))**

- **Use standard order class to get amounts on backoffice participant form (card flow) ([28627](https://github.com/civicrm/civicrm-core/pull/28627))**

- **dev/user-interface#49 SearchKit default label ([28624](https://github.com/civicrm/civicrm-core/pull/28624))**

- **dev/drupal#133 - Remove bad and unnecessary breadcrumb on Domain Contact info form ([28635](https://github.com/civicrm/civicrm-core/pull/28635))**

- **MailingSystemTest - Fix string concatenation ([28637](https://github.com/civicrm/civicrm-core/pull/28637))**

- **Add classes to searchkit compose screen to facilitate easier theming ([28620](https://github.com/civicrm/civicrm-core/pull/28620))**

- **Handle NULL in table name check ([28634](https://github.com/civicrm/civicrm-core/pull/28634))**

- **PHP - Remove unneeded polyfills for php 7.3 & 7.4 ([28619](https://github.com/civicrm/civicrm-core/pull/28619))**

- **5.69 ([28629](https://github.com/civicrm/civicrm-core/pull/28629))**

- **expose User Contact in standaloneusers UI ([28501](https://github.com/civicrm/civicrm-core/pull/28501))**

- **5.69 ([28625](https://github.com/civicrm/civicrm-core/pull/28625))**

- **Standalone - consistent naming for user/role admin forms/searches ([28502](https://github.com/civicrm/civicrm-core/pull/28502))**

- **ContactType - Ensure stable order ([28623](https://github.com/civicrm/civicrm-core/pull/28623))**

- **5.69 ([28615](https://github.com/civicrm/civicrm-core/pull/28615))**

- **standalone: workaround/fix for core issue 4853 ([28616](https://github.com/civicrm/civicrm-core/pull/28616))**

- **standalone: fix double <h1> and padding on select2 drops dev/core#4831 ([28560](https://github.com/civicrm/civicrm-core/pull/28560))**

- **Add token {membership.membership_status_id.is_new} ([28580](https://github.com/civicrm/civicrm-core/pull/28580))**

- **Fix MailingLabels to use token processor ([28574](https://github.com/civicrm/civicrm-core/pull/28574))**

- **Fix additional payment form to create billing address ([28609](https://github.com/civicrm/civicrm-core/pull/28609))**

- **Ang - Change crmUiAccordion to use summary/details markup ([28467](https://github.com/civicrm/civicrm-core/pull/28467))**

- **[REF][PHP8.2] Declare properties in CRM_Contribute_Form_ContributionPage_Widget ([28587](https://github.com/civicrm/civicrm-core/pull/28587))**

- **[REF][PHP8.2] Tidy up use of properties in CRM_Campaign_Form_Task_Release ([28594](https://github.com/civicrm/civicrm-core/pull/28594))**

- **Joomla - Remove old link format ([28603](https://github.com/civicrm/civicrm-core/pull/28603))**

- **5.69 ([28610](https://github.com/civicrm/civicrm-core/pull/28610))**

- **[REF][PHP8.2] Survey details report - dynamic properties ([28584](https://github.com/civicrm/civicrm-core/pull/28584))**

- **Clarify handling of is_email_receipt ([28608](https://github.com/civicrm/civicrm-core/pull/28608))**

- **[REF][PHP8.2] Change from dynamic property to local variable ([28596](https://github.com/civicrm/civicrm-core/pull/28596))**

- **Allow API4 Job to be a ManagedEntity ([28601](https://github.com/civicrm/civicrm-core/pull/28601))**

- **Standalone - Add UserRole table ([28595](https://github.com/civicrm/civicrm-core/pull/28595))**

- **Standalone - Fix favicon ([28602](https://github.com/civicrm/civicrm-core/pull/28602))**

- **Standalone - anonymous user access denied handling ([28565](https://github.com/civicrm/civicrm-core/pull/28565))**

- **Standalone - Remove unused reference to nonexistent file ([28604](https://github.com/civicrm/civicrm-core/pull/28604))**

- **5.69 ([28597](https://github.com/civicrm/civicrm-core/pull/28597))**

- **[NFC] Remove unused variable ([28593](https://github.com/civicrm/civicrm-core/pull/28593))**

- **[REF][PHP8.2] Switch dynamic property to local variable ([28599](https://github.com/civicrm/civicrm-core/pull/28599))**

- **[REF][PHP8.2] address dynamic properties in CRM_Event_Form_SearchEvent ([28600](https://github.com/civicrm/civicrm-core/pull/28600))**

- **Standalone - user edit pop-up and entity link ([28503](https://github.com/civicrm/civicrm-core/pull/28503))**

- **Remove unused function deprecated a year ago ([28598](https://github.com/civicrm/civicrm-core/pull/28598))**

- **AdminUI: Migrate LabelFormat from SearchUI to AdminUI ([28550](https://github.com/civicrm/civicrm-core/pull/28550))**

- **fix json version file ([28591](https://github.com/civicrm/civicrm-core/pull/28591))**

- **path changes for PDFFormat ([28564](https://github.com/civicrm/civicrm-core/pull/28564))**

- **[php8] dev/core#4807 - Move $_entityTagValues to where it's used ([28586](https://github.com/civicrm/civicrm-core/pull/28586))**

- **E-notice fix when no template exists ([28567](https://github.com/civicrm/civicrm-core/pull/28567))**

- **Change URL for edit/create/delete SMS provider to support Searchkit admin ui over-ride ([28530](https://github.com/civicrm/civicrm-core/pull/28530))**

- **Simplify setDefaults function on contact import mapfields ([28553](https://github.com/civicrm/civicrm-core/pull/28553))**

- **Split  `CRM_Utils_Address::format()` into 2 functions ([28578](https://github.com/civicrm/civicrm-core/pull/28578))**

- **Fix support for DB logging with multilingual ([28338](https://github.com/civicrm/civicrm-core/pull/28338))**

- **Bump min PHP version to 7.4.0 ([28583](https://github.com/civicrm/civicrm-core/pull/28583))**

- **Improve 3 way fallback of name,title, frontend_title ([28568](https://github.com/civicrm/civicrm-core/pull/28568))**

- **Applies accessible accordion to extension table  ([28473](https://github.com/civicrm/civicrm-core/pull/28473))**

- **APIv4 - Delete unused Entity::getLinks action ([28577](https://github.com/civicrm/civicrm-core/pull/28577))**

- **Bump minimum PHP version ([677](https://github.com/civicrm/civicrm-drupal/pull/677))**

- **Bump Minimum PPH version to 7.4 to match core ([314](https://github.com/civicrm/civicrm-wordpress/pull/314))**

- **Bump minimum php version to 7.4 ([71](https://github.com/civicrm/civicrm-joomla/pull/71))**

- **Bump Minimum PHP to match core ([170](https://github.com/civicrm/civicrm-backdrop/pull/170))**

- **5.69 ([377](https://github.com/civicrm/civicrm-packages/pull/377))**

- **Migrate Snappy to composer ([375](https://github.com/civicrm/civicrm-packages/pull/375))**

### CiviCase

- **5.70 active relationships not loading when Civi Case not 
  enabled ([dev/core#4960](https://lab.civicrm.org/dev/core/-/issues/4960): 
  [29200](https://github.com/civicrm/civicrm-core/pull/29200))**

- **Activity count on contact tab is always including case activities 
  ([dev/core#4943](https://lab.civicrm.org/dev/core/-/issues/4943): 
  [29143](https://github.com/civicrm/civicrm-core/pull/29143))**

- **CiviCase - Fix crash when fetching status_id pseudoconstant 
  ([28957](https://github.com/civicrm/civicrm-core/pull/28957))**

### CiviContribute

- **Fix wonkyness if contribution page includes a profile with both groups & 
  tags ([29193](https://github.com/civicrm/civicrm-core/pull/29193))**

- **Extra receipt is sent when marking a contribution complete. 
  ([dev/core#4970](https://lab.civicrm.org/dev/core/-/issues/4970): 
  [29264](https://github.com/civicrm/civicrm-core/pull/29264))**

- **Fix 5.67 regression on loading custom data defaults on contribution page 
  ([29192](https://github.com/civicrm/civicrm-core/pull/29192))**
  
- **Button row overlaps the table on view contribution 
  ([dev/user-interface#65](https://lab.civicrm.org/dev/user-interface/-/issues/65): 
  [29189](https://github.com/civicrm/civicrm-core/pull/29189), 
  [28994](https://github.com/civicrm/civicrm-core/pull/28994), and 
  [29000](https://github.com/civicrm/civicrm-core/pull/29000))**

- **Contribution Radio Buttons Incorrectly add other Amount 
  ([dev/core#4917](https://lab.civicrm.org/dev/core/-/issues/4917): 
  [29115](https://github.com/civicrm/civicrm-core/pull/29115))**

- **Fix JS error and allow focus of Other Amount field 
  ([29113](https://github.com/civicrm/civicrm-core/pull/29113))**

- **Since civicrm 5.69, "Other amount" field cannot be filled on many themes.
  ([dev/core#4912](https://lab.civicrm.org/dev/core/-/issues/4912): 
  [29016](https://github.com/civicrm/civicrm-core/pull/29016))**

- **Remove references to contribution_invoice_settings 
  ([dev/core#2719](https://lab.civicrm.org/dev/core/-/issues/2719): 
  [20970](https://github.com/civicrm/civicrm-core/pull/20970))**

- **[REF] Rewrite PCP enumeration to avoid caching bug 
  ([28519](https://github.com/civicrm/civicrm-core/pull/28519))**

### CiviEvent

- **Fix rc-only regression -  back-office registration does not reload contact 
  ID ([28893](https://github.com/civicrm/civicrm-core/pull/28893))**

- **No event registration confirmation email sent for free events 
  ([dev/core#4893](https://lab.civicrm.org/dev/core/-/issues/4893): 
  [28928](https://github.com/civicrm/civicrm-core/pull/28928))**

- **Fix Smarty3 error in online event registration 
  ([28884](https://github.com/civicrm/civicrm-core/pull/28884))**

- **Declare amount private - use magic method to provide access to the old 
  value ([28769](https://github.com/civicrm/civicrm-core/pull/28769))**

### CiviGrant

- **[REF] Fix grant_report_received column to be not null and default to 0 
  ([28861](https://github.com/civicrm/civicrm-core/pull/28861))**

- **[REF] Fix Smarty Notices on Find Grants search 
  ([28862](https://github.com/civicrm/civicrm-core/pull/28862))**

### CiviMember

- **Logged in user who has an existing membership is not seeing this mentioned 
  on a Membership page 
  ([dev/core#4939](https://lab.civicrm.org/dev/core/-/issues/4939): 
  [29112](https://github.com/civicrm/civicrm-core/pull/29112))**

- **Auto-renew checkbox hidden by default 
  ([dev/core#4931](https://lab.civicrm.org/dev/core/-/issues/4931): 
  [29118](https://github.com/civicrm/civicrm-core/pull/29118))**

- **Fix Checking Auto renew for Non Quick Config Price Set when Membership Type 
  Auto renew is null 
  ([29069](https://github.com/civicrm/civicrm-core/pull/29069))**

- **[REF] Fix Hard Fail when loading back office add membership form with   
  membership types with no minimum fee set 
  ([28959](https://github.com/civicrm/civicrm-core/pull/28959))**

- **Fix pay-later receipt token in shipped version 
  ([28895](https://github.com/civicrm/civicrm-core/pull/28895))**

  Pay later text was missing in the online membership receipt.

### CiviMail

- **Remove possibly-unavailable job_id from unsub function 
  ([28966](https://github.com/civicrm/civicrm-core/pull/28966))**

## <a name="misc"></a>Miscellany

- **Disable failing test in PR runs for now 
  ([29277](https://github.com/civicrm/civicrm-core/pull/29277))**

- **Avoid crash in extensions that call getVar 
  ([29080](https://github.com/civicrm/civicrm-core/pull/29080))**

- **Make fail-heavy test as ornery 
  ([28913](https://github.com/civicrm/civicrm-core/pull/28913))**

- **Bump follow-redirects from 1.14.8 to 1.15.4 
  ([28942](https://github.com/civicrm/civicrm-core/pull/28942))**

- **Run regen ([28919](https://github.com/civicrm/civicrm-core/pull/28919))**

- **[NFC] Product - Fix duplicated key in xml file 
  ([28882](https://github.com/civicrm/civicrm-core/pull/28882))**

- **Move report test to civi_report 
  ([28867](https://github.com/civicrm/civicrm-core/pull/28867))**

- **CoreForm - Add noisy deprecation to addDate & addDateTime functions 
  ([28860](https://github.com/civicrm/civicrm-core/pull/28860))**

- **[NFC] Cleanup dummy DAO in ruleGroupTest class 
  ([28851](https://github.com/civicrm/civicrm-core/pull/28851))**

- **[NFC] Fix docblock reference in _checkAccess functions 
  ([28852](https://github.com/civicrm/civicrm-core/pull/28852))**

- **Minor cleanup in test class 
  ([28849](https://github.com/civicrm/civicrm-core/pull/28849))**

- **Regenerate ext DAO files using updated civix 
  ([28846](https://github.com/civicrm/civicrm-core/pull/28846))**

- **DAO - Return reference columns based on field metadata  
  ([28827](https://github.com/civicrm/civicrm-core/pull/28827))**

- **REF - Swap CRM_Utils_Array::collect with vanilla array_column 
  ([28668](https://github.com/civicrm/civicrm-core/pull/28668))**

- **[NFC] Add 'getLinks' action to phpStorm extension 
  ([28834](https://github.com/civicrm/civicrm-core/pull/28834))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

19ATF72; AGH Strategies - Andie Hunt; Artful Robot - Rich Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor; Business & Code - Alain Benbassat; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; Compuco - Olayiwola Odunsi; Coop SymbioTIC - Mathieu Lutfy; Dave D; European Centre for Press and Media Freedom (ECPMF) - Benjamin Bock; Fuzion - Jitendra Purohit; Humanists UK - Andrew West;; JMA Consulting - Seamus Lee; Joinery - Allen Shaw; Lemniscus - Noah Miller; Makoa - Usha F. Matisson; Megaphone Technology Consulting - Jon Goldberg; mflandorfer; MJW Consulting - Matthew Wire; Nicol Wistreich; patricklam; Squiffle Consulting - Aidan Saunders; Stephen Palmstrom; Third Sector Design - Michael McAndrew, William Mortada; Wikimedia Foundation - Eileen McNaughton, Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Australian Greens - John Twyman; chumkui; CiviCoop - Jaap Jansma; civicrm-builder; CiviDesk - Yashodha Chaku; Francesc Bassas i Bullich; JMA Consulting - Monish Deb; John Kingsnorth; Skvare - Mark Hanna; Tadpole Collective - Kevin Cristiano; Wildsight - Lars Sander-Green

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
