# CiviCRM 5.41.0

Released September 1, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CiviReport] Add "is null" and "is not null" to OP_MULTISELECT_SEPARATOR
  ([dev/core#2652](https://lab.civicrm.org/dev/core/-/issues/2652):
  [20794](https://github.com/civicrm/civicrm-core/pull/20794))**

  Makes it possible to filter by `is null` and `is not null` on reports that use
  OP_MULTISELECT_SEPARATOR.

- **Add ContributionProduct and EntityBatch APIv4 Entity
  ([20505](https://github.com/civicrm/civicrm-core/pull/20505))**

  Adds `ContributionProduct` and `EntityBatch` as APIv4 entities.

- **Add v4 managed api entity
  ([20932](https://github.com/civicrm/civicrm-core/pull/20932))**

  Adds `Managed` as an APIv4 entity.

- **APIv4 - Better handling of output value using GROUP_CONCAT
  ([20896](https://github.com/civicrm/civicrm-core/pull/20896))**

  Improves output formatting of the `GROUP_CONCAT` sql function in APIv4.

- **Search kit / afform allow default for filters
  ([dev/core#2734](https://lab.civicrm.org/dev/core/-/issues/2734):
  [21005](https://github.com/civicrm/civicrm-core/pull/21005))**

  Allows end users to set a default value for fields in SearchKit and Afform.

- **SearchKit - Add links to view/edit/delete relationships
  ([20886](https://github.com/civicrm/civicrm-core/pull/20886))**

  Adds links to view/edit/delete the relationship when joining on related
  contacts in SearchKit.

- **Search kit request - calculated field in display
  ([dev/core#2704](https://lab.civicrm.org/dev/core/-/issues/2704):
  [20947](https://github.com/civicrm/civicrm-core/pull/20947))**

  Supports SQL functions in the SearchKit UI.

- **SearchKit - Support all fields as tokens
  ([20880](https://github.com/civicrm/civicrm-core/pull/20880))**

  Improves SearchDisplay support for tokens (in link URLs, list labels, and
  rewritten fields).

- **Enable range search for money fields in search kit + afform
  ([20930](https://github.com/civicrm/civicrm-core/pull/20930))**

  Makes it possible to range search money fields in SearchKit and Afform UIs.

- **Use template variable to add or remove swap button.
  ([21003](https://github.com/civicrm/civicrm-core/pull/21003))**

  Uses template variable to add or remove swap button on the Activity edit form.

- **Add hook for validating checksum
  ([20858](https://github.com/civicrm/civicrm-core/pull/20858))**

  Adds a hook that can be called to override/modify checksum validation.

- **Distinguish custom field VIEW from EDIT permissions
  ([20837](https://github.com/civicrm/civicrm-core/pull/20837))**

  Fixes the previously blurry distinction between permission to VIEW or EDIT a
  group of custom fields.

- **CRM_Utils_Type::validatePhpType - Helper to validate PHP type expressions
  ([20923](https://github.com/civicrm/civicrm-core/pull/20923))**

  Adds a helper for evaluating the type expressions that appear in PHP
  docblocks. This is a building block for other code that uses docblocks for
  validation.

### CiviContribute

- **Proposal - make future recurring contribution instances modifiable & not
  fail if the only contribution is deleted. (Work Towards
  [dev/financial#6](https://lab.civicrm.org/dev/financial/-/issues/6):
  [20685](https://github.com/civicrm/civicrm-core/pull/20685))**

  Adds a button to the "Recurring Contributions" tab of the Contact Summary to
  create/view the template contribution.

- **Update label on payment instrument
  ([20977](https://github.com/civicrm/civicrm-core/pull/20977))**

  Defines a label "Payment Method" for payment instrument.

- **Improve accessibility for price fields of the type select by adding the
  price field label to the placeholder.
  ([20927](https://github.com/civicrm/civicrm-core/pull/20927))**

  Makes placeholder text for price fields of the type select more specific and
  more accessible by adding the label to them.

- **Move financialACLs to a core extension (Work Towards
  [20768](https://github.com/civicrm/civicrm-core/pull/20768))**

  Switches the Membership Browse page from DAO retrieval to using APIv4.

- **Move reCAPTCHA to core extension (Work Towards
  [dev/core#2571](https://lab.civicrm.org/dev/core/-/issues/2571):
  [20315](https://github.com/civicrm/civicrm-core/pull/20315))**

  Adds helper functions for reCAPTCHA extension.

- **Move legacy custom search framework to a core extension
  ([dev/core#2721](https://lab.civicrm.org/dev/core/-/issues/2721):
  [20952](https://github.com/civicrm/civicrm-core/pull/20952),
  [20955](https://github.com/civicrm/civicrm-core/pull/20955) and
  [20954](https://github.com/civicrm/civicrm-core/pull/20954))**

  Moves custom search framework to a core extension.

### WordPress Integration

- **Add shortcode support for profile map view
  ([dev/wordpress#106](https://lab.civicrm.org/dev/wordpress/-/issues/106):
  [252](https://github.com/civicrm/civicrm-wordpress/pull/252) and
  [20877](https://github.com/civicrm/civicrm-core/pull/20877))**

  Adds support for map view for profiles using shortcodes.

- **Add setup pcp page shortcode
  ([253](https://github.com/civicrm/civicrm-wordpress/pull/253))**

  Makes it possible to insert a PCP page using a shortcode.

- **Added setup pcp page wordpress shortcode
  ([20601](https://github.com/civicrm/civicrm-core/pull/20601))**

  Makes it possible to add a setup a PCP page using a shortcode.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Reconcile tokens misnamed or missing on legacy class
  ([21039](https://github.com/civicrm/civicrm-core/pull/21039))**

- **Reconcile contribution amount tokens
  ([21036](https://github.com/civicrm/civicrm-core/pull/21036) and
  [21038](https://github.com/civicrm/civicrm-core/pull/21038))**

  Reconcile tokens misnamed or missing on legacy class.

- **Fix advertised token for source
  ([21037](https://github.com/civicrm/civicrm-core/pull/21037))**

- **Update contribution_page_id token in sched reminders
  ([21035](https://github.com/civicrm/civicrm-core/pull/21035))**

- **Reconcile and upgrade tokens for payment instrument, financial type
  ([21000](https://github.com/civicrm/civicrm-core/pull/21000))**

- **Switch contribution action schedule tokens to use advertised tokens for
  cancel_date & source
  ([20999](https://github.com/civicrm/civicrm-core/pull/20999))**

- **Swap {$displayName} smarty for {contact.display_name} token
  ([20867](https://github.com/civicrm/civicrm-core/pull/20867) and
  [20885](https://github.com/civicrm/civicrm-core/pull/20885))**

  Work to make tokens more consistent.

- **Rename legacy token for contribution id to match sched reminder tokens
  ([20998](https://github.com/civicrm/civicrm-core/pull/20998))**

- **Give administer CiviCRM data access to administer custom groups
  ([20578](https://github.com/civicrm/civicrm-core/pull/20578))**

- **CustomGroup - change admin permission to 'administer CiviCRM data'
  ([20833](https://github.com/civicrm/civicrm-core/pull/20833))**

  Fine-tunes the permissions needed to access all custom data.

- **Selection in quick search result list is not visible
  ([dev/user-interface#37](https://lab.civicrm.org/dev/user-interface/-/issues/37):
  [21102](https://github.com/civicrm/civicrm-core/pull/21102))**

- **Redis 6.06 errors - Deprecated function - civicrm 5.38.0
  ([dev/core#2648](https://lab.civicrm.org/dev/core/-/issues/2648):
  [20587](https://github.com/civicrm/civicrm-core/pull/20587))**

- **CiviReport grouping broken wrt filters
  ([dev/core#2684](https://lab.civicrm.org/dev/core/-/issues/2684):
  [20820](https://github.com/civicrm/civicrm-core/pull/20820))**

  Fixes filters report templates to permit more than one table in a grouping.

- **On logging detail report show the words not the numbers
  ([dev/core#2691](https://lab.civicrm.org/dev/core/-/issues/2691):
  [20844](https://github.com/civicrm/civicrm-core/pull/20844))**

- **Logging skips custom fields if you specify a non-standard table name
  ([dev/core#2709](https://lab.civicrm.org/dev/core/-/issues/2709):
  [20918](https://github.com/civicrm/civicrm-core/pull/20918))**

- **Cannot disable contact type/sub-type
  ([dev/core#2710](https://lab.civicrm.org/dev/core/-/issues/2710):
  [20919](https://github.com/civicrm/civicrm-core/pull/20919))**

- **Connection fail in runSqlQuery function when using DSN with SSL
  ([dev/core#2726](https://lab.civicrm.org/dev/core/-/issues/2726):
  [20974](https://github.com/civicrm/civicrm-core/pull/20974))**

- **Contact Dashboard: relationships: wrong links appear if "Pledges" not
  displayed ([dev/core#2740](https://lab.civicrm.org/dev/core/-/issues/2740):
  [21051](https://github.com/civicrm/civicrm-core/pull/21051))**

- **Creating a regular group from advanced search displays commas for the type
  when looking at the groups listing page
  ([dev/core#2742](https://lab.civicrm.org/dev/core/-/issues/2742):
  [21053](https://github.com/civicrm/civicrm-core/pull/21053))**

- **Performance regression in API3 related to campaign_id parameter
  ([dev/core#2743](https://lab.civicrm.org/dev/core/-/issues/2743):
  [21099](https://github.com/civicrm/civicrm-core/pull/21099))**

- **APIv4 - Fix dumb typo breaking color lookup
  ([20817](https://github.com/civicrm/civicrm-core/pull/20817))**

- **Add test & fix for failing OR clause in apv4
  ([20906](https://github.com/civicrm/civicrm-core/pull/20906))**

- **APIv4 - Fix calculated fields in bridge entities
  ([20908](https://github.com/civicrm/civicrm-core/pull/20908))**

- **APIv4 - Fix pseudoconstant matching reliability across joins
  ([20799](https://github.com/civicrm/civicrm-core/pull/20799))**

- **APIv4 - Fix and add tests for comparison SQL functions
  ([20893](https://github.com/civicrm/civicrm-core/pull/20893))**

- **Fix v4 api to do custom field delete in tearDown
  ([20863](https://github.com/civicrm/civicrm-core/pull/20863))**

- **APIv4 - Fix output of membershipType auto_renew field
  ([20840](https://github.com/civicrm/civicrm-core/pull/20840))**

- **Afform - Use correct contact type when loading field options
  ([20996](https://github.com/civicrm/civicrm-core/pull/20996))**

- **SearchKit - Fix permission to access task list
  ([21045](https://github.com/civicrm/civicrm-core/pull/21045))**

  Fixes a regression preventing access to the tasks menu in search displays for
  non-admin users.

- **SearchKit - Auto-apply filters passed in from Afform markup
  ([20758](https://github.com/civicrm/civicrm-core/pull/20758))**

  Ensures that any scalar value passed as a filter via Afform markup will be
  auto-applied.

- **SearchKit - fix deprecated join
  ([20968](https://github.com/civicrm/civicrm-core/pull/20968))**

- **SearchKit - Fix pager count return value
  ([20878](https://github.com/civicrm/civicrm-core/pull/20878))**

- **Make report subtotals work for custom fields
  ([20752](https://github.com/civicrm/civicrm-core/pull/20752))**

- **Fix bulk adding custom fields with logging on
  ([21019](https://github.com/civicrm/civicrm-core/pull/21019))**

- **Reduce deadlock while inserting custom data for Address
  ([20924](https://github.com/civicrm/civicrm-core/pull/20924))**

- **Do not generate a notice when a vcard is downloaded with a non-primary email
  or non-primary phone number
  ([20993](https://github.com/civicrm/civicrm-core/pull/20993))**

- **Fix for failure (fatal error and silent failure) to clean up full text
  indices ([20921](https://github.com/civicrm/civicrm-core/pull/20921))**

- **Fix upgrade message when nothing was changed
  ([20994](https://github.com/civicrm/civicrm-core/pull/20994))**

- **Upgrade message is scrunched up next to the previous sentence
  ([20986](https://github.com/civicrm/civicrm-core/pull/20986))**

- **Add upgrade routine to remove old action schedule token
  ([20978](https://github.com/civicrm/civicrm-core/pull/20978))**

- **Improve cleanup on indexer test
  ([20909](https://github.com/civicrm/civicrm-core/pull/20909) and
  [20920](https://github.com/civicrm/civicrm-core/pull/20920))**

  Fix indexes to play nicely with MariaDB.

- **Activity tasks - don't add invalid tasks
  ([20951](https://github.com/civicrm/civicrm-core/pull/20951))**

- **Fix databaseSupportsUTF8MB4
  ([20905](https://github.com/civicrm/civicrm-core/pull/20905))**

- **Add ts() function within CRM_Core_Error::statusBounce() method
  ([20857](https://github.com/civicrm/civicrm-core/pull/20857))**

- **Greenwich - fix select2 font size
  ([20911](https://github.com/civicrm/civicrm-core/pull/20911))**

- **Fix onCrmUiSelect to use current scope and apply to the digest cycle
  ([20879](https://github.com/civicrm/civicrm-core/pull/20879))**

- **Also check timestamp types for update() when trying to update a timestamp
  field with a blank value
  ([326](https://github.com/civicrm/civicrm-packages/pull/326))**

- **Fix error message when unable to delete ManagedEntity
  ([20946](https://github.com/civicrm/civicrm-core/pull/20946))**

- **Capitalization Fix
  ([20913](https://github.com/civicrm/civicrm-core/pull/20913))**

- **Smarty notices for New Activity / New Case for tags for attachments
  ([20957](https://github.com/civicrm/civicrm-core/pull/20957))**

- **PHP E_NOTICE during upgrade
  ([20980](https://github.com/civicrm/civicrm-core/pull/20980))**

- **Fix PHP notice in recaptcha lib
  ([20899](https://github.com/civicrm/civicrm-core/pull/20899))**

- **some typo fixes
  ([20897](https://github.com/civicrm/civicrm-core/pull/20897))**

- **PHP notice fixes on options page
  ([20816](https://github.com/civicrm/civicrm-core/pull/20816))**

- **Fix a typo in social networking buttons
  ([20839](https://github.com/civicrm/civicrm-core/pull/20839))**

- **Enotice fix on extensions page
  ([20801](https://github.com/civicrm/civicrm-core/pull/20801))**

- **Smarty notices on logging detail report
  ([20948](https://github.com/civicrm/civicrm-core/pull/20948))**

- **Smarty warning about pager location on all CiviReports
  ([20949](https://github.com/civicrm/civicrm-core/pull/20949))**

- **Smarty notices - Missing type on logging civireport
  ([20843](https://github.com/civicrm/civicrm-core/pull/20843))**

- **Fix undefined tpl vars
  ([20828](https://github.com/civicrm/civicrm-core/pull/20828))**

- **Fix undefined tpl variables
  ([20813](https://github.com/civicrm/civicrm-core/pull/20813))**

- **Tpl notice fixes
  ([21050](https://github.com/civicrm/civicrm-core/pull/21050))**

- **tpl enotice fix
  ([20827](https://github.com/civicrm/civicrm-core/pull/20827))**

- **E-notice fix ([20830](https://github.com/civicrm/civicrm-core/pull/20830))**

- **Enotice fix ([21041](https://github.com/civicrm/civicrm-core/pull/21041))**

- **Enotice fix ([21040](https://github.com/civicrm/civicrm-core/pull/21040))**

### CiviCase

- **Smarty warnings on Manage Case
  ([21002](https://github.com/civicrm/civicrm-core/pull/21002))**

- **Case Dashboard: fix labels on my/all radio buttons, and simplify label text
  ([20958](https://github.com/civicrm/civicrm-core/pull/20958))**

- **Move/rename case export files for consistency
  ([20988](https://github.com/civicrm/civicrm-core/pull/20988))**

### CiviContribute

- **Token syntax plan - pseudoconstants (Work Towards
  [dev/core#2650](https://lab.civicrm.org/dev/core/-/issues/2650):
  [20864](https://github.com/civicrm/civicrm-core/pull/20864) and
  [20961](https://github.com/civicrm/civicrm-core/pull/20961))**

  Adds variations on the token {contribution.contribution_status_id} which
  support names and labels, i.e. `{contribution.contribution_status_id}`,
  `{contribution.contribution_status_id:name}` and
  `{contribution.contribution_status_id:label}`.

- **In Accounting Batch it is not filtered by custom fields
  ([dev/core#2642](https://lab.civicrm.org/dev/core/-/issues/2642):
  [20556](https://github.com/civicrm/civicrm-core/pull/20556))**

  Ensures that users can filter Accounting Batch transactions by custom fields.

- **Remove all calls to BAO_Contribution::completeOrder other than from
  Payment.create (Work Towards
  [dev/core#2693](https://lab.civicrm.org/dev/core/-/issues/2693):
  [20852](https://github.com/civicrm/civicrm-core/pull/20852))**

- **delocalize total amount before passing to setOverrideTotal
  ([21107](https://github.com/civicrm/civicrm-core/pull/21107))**

- **Deprecate guess work in line item handling
  ([20775](https://github.com/civicrm/civicrm-core/pull/20775))**

- **Fixes getTemplateContribution to use a more reliable way to load line items
  ([20784](https://github.com/civicrm/civicrm-core/pull/20784))**

- **Fix Payment.create to update financial_item.status_id
  ([20941](https://github.com/civicrm/civicrm-core/pull/20941))**

- **Fix unit translation for recurring contributions
  ([20308](https://github.com/civicrm/civicrm-core/pull/20308))**

- **fix missing 'on behalf of' and honoree labels in multilingual
  ([20482](https://github.com/civicrm/civicrm-core/pull/20482))**

- **Fix 'includes tax' translation for PriceSet Checkbox fields
  ([20926](https://github.com/civicrm/civicrm-core/pull/20926))**

- **Display configured currency on PCPPage instead of default
  ([20904](https://github.com/civicrm/civicrm-core/pull/20904))**

- **Line items not visible on recurring contribution
  ([dev/core#2624](https://lab.civicrm.org/dev/core/-/issues/2624):
  [20399](https://github.com/civicrm/civicrm-core/pull/20399))**

  Ensures Line items are visible on recurring contributions.

### CiviEvent

- **fix crmValidate() not loading on event registration pages
  ([21124](https://github.com/civicrm/civicrm-core/pull/21124))**

- **Fix transfer registration to transfer participant_payment row
  ([20670](https://github.com/civicrm/civicrm-core/pull/20670))**

### CiviGrant

- **enable paging if contact has more then 50 grants.
  ([21008](https://github.com/civicrm/civicrm-core/pull/21008))**

### CiviMail

- **Fix mailing task when there are no tasks
  ([20989](https://github.com/civicrm/civicrm-core/pull/20989))**

- **Make final mailing from A/B test same template type and options as A/B so it
  can be copied ([20096](https://github.com/civicrm/civicrm-core/pull/20096))**

- **Forward Mailing: remove duplicate buttons, cancel button
  ([20782](https://github.com/civicrm/civicrm-core/pull/20782))**

### CiviMember

- **Test, enotice fixes, handling for permissions key for Member_Tasks
  ([20944](https://github.com/civicrm/civicrm-core/pull/20944))**

- **[regression] Free membership pages fail with "No Payment Processor Selected"
  ([dev/core#2749](https://lab.civicrm.org/dev/core/-/issues/2749):
  [21100](https://github.com/civicrm/civicrm-core/pull/21100))**

- **New membership: fix tax amount translation
  ([20979](https://github.com/civicrm/civicrm-core/pull/20979))**

### Drupal Integration

- **Drupal8 CiviCRM conflicts with Masquerade module
  ([dev/drupal#54](https://lab.civicrm.org/dev/drupal/-/issues/54):
  [31](https://github.com/civicrm/civicrm-drupal-8/pull/31))**

### WordPress Integration

- **WordPress basepage_render shouldn't remove the 'the_content' filter AND
  CiviCRM Shortcode issue with YoastSEO
  ([dev/wordpress#107](https://lab.civicrm.org/dev/wordpress/-/issues/107) and
  [dev/wordpress#112](https://lab.civicrm.org/dev/wordpress/-/issues/112):
  [255](https://github.com/civicrm/civicrm-wordpress/pull/255))**

  Reverts the removal of the content filter which caused errors for sites using
  Avada themes and or the yoast plugin.

## <a name="misc"></a>Miscellany

- **crmMonaco - Multiple updates. Toward message-template editing.
  ([20786](https://github.com/civicrm/civicrm-core/pull/20786))**

- **Enable check on created participant payment rows
  ([20650](https://github.com/civicrm/civicrm-core/pull/20650))**

- **Minor simplification - use casting
  ([20847](https://github.com/civicrm/civicrm-core/pull/20847))**

- **Mark afform extensions as beta
  ([20821](https://github.com/civicrm/civicrm-core/pull/20821))**

- **Add deprecation warning for modifiedDates
  ([20805](https://github.com/civicrm/civicrm-core/pull/20805))**

- **Use type hinting for id
  ([20850](https://github.com/civicrm/civicrm-core/pull/20850))**

- **CRM_Utils_Array::pathMove - Add helper to move an item within array tree
  ([20866](https://github.com/civicrm/civicrm-core/pull/20866))**

- **Extract getCurrentMembership
  ([20882](https://github.com/civicrm/civicrm-core/pull/20882))**

- **[REF] Remove references to contribution_invoice_settings (Work Towards
  [dev/core#2719](https://lab.civicrm.org/dev/core/-/issues/2719):
  [20971](https://github.com/civicrm/civicrm-core/pull/20971) and
  [20862](https://github.com/civicrm/civicrm-core/pull/20862))**

- **[REF] Financial record processing - extract to new class to faciliate
  cleanup (Work Towards
  [dev/core#2715](https://lab.civicrm.org/dev/core/-/issues/2715):
  [20872](https://github.com/civicrm/civicrm-core/pull/20872))**

- **Failing api4 test
  api.v4.Action.CreateWithOptionGroupTest.testWithCustomDataForMultipleContacts
  ([dev/core#2699](https://lab.civicrm.org/dev/core/-/issues/2699):
  [20901](https://github.com/civicrm/civicrm-core/pull/20901))**

- **Remove deprecated lines of code
  ([20873](https://github.com/civicrm/civicrm-core/pull/20873))**

- **Remove a couple of instances of 'contribution_mode' from tests
  ([20831](https://github.com/civicrm/civicrm-core/pull/20831))**

- **Remove deprecated code
  ([20848](https://github.com/civicrm/civicrm-core/pull/20848))**

- **Remove never-true-if
  ([20853](https://github.com/civicrm/civicrm-core/pull/20853))**

- **Remove non-variable variables
  ([20881](https://github.com/civicrm/civicrm-core/pull/20881))**

- **Remove obsolete code
  ([20854](https://github.com/civicrm/civicrm-core/pull/20854))**

- **[REF] [Super trivial] -tighten up some casting
  ([20964](https://github.com/civicrm/civicrm-core/pull/20964))**

- **[REF] SearchKit - Refactor pick-lists to use onCrmUiSelect directive
  ([20910](https://github.com/civicrm/civicrm-core/pull/20910))**

- **[REF] Extract the function to load from the acl table
  ([20868](https://github.com/civicrm/civicrm-core/pull/20868))**

- **[REF] Refactor SearchKit displays to inherit traits from a common base
  ([20900](https://github.com/civicrm/civicrm-core/pull/20900))**

- **(REF) Extract TokenSmarty::render() from
  MessageTemplate::renderMessageTemplate()
  ([20870](https://github.com/civicrm/civicrm-core/pull/20870))**

- **[REF] Add in smarty modifier to replcae the upper smarty modifier to better
  handle umlouts / accents
  ([20892](https://github.com/civicrm/civicrm-core/pull/20892))**

- **(REF) APIv4 FieldSpec - Extract various traits (Civi\Schema\Traits\*)
  ([20875](https://github.com/civicrm/civicrm-core/pull/20875))**

- **[REF] Fix functions to be protected
  ([20869](https://github.com/civicrm/civicrm-core/pull/20869))**

- **(REF) Civi/Schema - Extract MagicGetterSetterTrait. Add test coverage.
  ([20865](https://github.com/civicrm/civicrm-core/pull/20865))**

- **[Ref] Remove never-passed parameter
  ([20871](https://github.com/civicrm/civicrm-core/pull/20871))**

- **[REF] Remove some non-variable variables
  ([20874](https://github.com/civicrm/civicrm-core/pull/20874))**

- **[REF] Further order api cleanup
  ([20829](https://github.com/civicrm/civicrm-core/pull/20829))**

- **[REF] Minor auth.net ipn simplification
  ([20718](https://github.com/civicrm/civicrm-core/pull/20718))**

- **[REF] Remove unused variables
  ([20834](https://github.com/civicrm/civicrm-core/pull/20834))**

- **[REF] Add in APIv4 Product Entity and Fix APIv4 Syntax Conformance test
  failures on ContributionProduct and EntityBatch APIs
  ([20819](https://github.com/civicrm/civicrm-core/pull/20819))**

- **[REF] Simplify isRenew handling on batch for membership
  ([20791](https://github.com/civicrm/civicrm-core/pull/20791))**

- **[REF] minor fix - move last of processing before receipting
  ([20969](https://github.com/civicrm/civicrm-core/pull/20969))**

- **[Ref] [Test] Move custom search tests to extension
  ([20990](https://github.com/civicrm/civicrm-core/pull/20990))**

- **[REF] Fix utf8mb4 test in APIv4 and re-enable the altering of database in
  the v3 version of the test and fix handling for first name field
  ([21001](https://github.com/civicrm/civicrm-core/pull/21001))**

- **[REF] Upgrade CKEditor to 4.16.2
  ([21108](https://github.com/civicrm/civicrm-core/pull/21108))**

- **(NFC) release-notes - Fix typo
  ([21104](https://github.com/civicrm/civicrm-core/pull/21104))**

- **[NFC] Fix APIv4 Utf8mb4 test to ensure no mixed collation errors
  ([21013](https://github.com/civicrm/civicrm-core/pull/21013))**

- **NFC - Reformat JSON file whitespace in Afform mock ext
  ([20967](https://github.com/civicrm/civicrm-core/pull/20967))**

- **[NFC] Remove exceptions from comments
  ([20943](https://github.com/civicrm/civicrm-core/pull/20943))**

- **[NFC] Typo in parameter for lybunt test
  ([20934](https://github.com/civicrm/civicrm-core/pull/20934))**

- **[NFC] Do a proper tear down of fts in QueryFormatterTest
  ([21004](https://github.com/civicrm/civicrm-core/pull/21004))**

- **[NFC/Unit test] - Failing test demonstrating blank timestamp updates
  ([20891](https://github.com/civicrm/civicrm-core/pull/20891))**

- **[NFC/Unit test] - Test for #20892 - New smarty plugin crmUpper
  ([20895](https://github.com/civicrm/civicrm-core/pull/20895))**

- **[NFC/Unit test] ReportTemplateTest - fix tests that assume setup from a
  separate test ([20887](https://github.com/civicrm/civicrm-core/pull/20887))**

- **APIv4 - Add test to ensure superfluous option groups are not created
  ([20902](https://github.com/civicrm/civicrm-core/pull/20902))**

- **[Test] Add cover for setting num_terms to 2
  ([20939](https://github.com/civicrm/civicrm-core/pull/20939))**

- **Api test cleanup fixes
  ([20876](https://github.com/civicrm/civicrm-core/pull/20876))**

- **Fix test to use valid financials
  ([20956](https://github.com/civicrm/civicrm-core/pull/20956))**

- **Fix test to use order api & setup valid financials
  ([20806](https://github.com/civicrm/civicrm-core/pull/20806))**

- **Unit test for invalidateChecksum hook
  ([20973](https://github.com/civicrm/civicrm-core/pull/20973))**

- **contributor-key.yml: updates for Symbiotic
  ([21044](https://github.com/civicrm/civicrm-core/pull/21044))**

- **Update contributor-key.yml
  ([21033](https://github.com/civicrm/civicrm-core/pull/21033))**

- **Update contributor-key.yml
  ([20812](https://github.com/civicrm/civicrm-core/pull/20812))**

- **Add to contributors file
  ([20842](https://github.com/civicrm/civicrm-core/pull/20842))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Caltha - Tomasz Pietrzkowski;
CiviCoop - Jaap Jansma, Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave
D; Diego Muñio; Erawat Chamanont; Gokhalemethod - Sadashiv; Greenpeace Central
and Eastern Europe - Patrick Figel; JMA Consulting - Monish Deb, Seamus Lee;
Kartik Kathuria; Lighthouse Consulting and Design - Brian Shaughnessy; Megaphone
Technology Consulting - Jon Goldberg; Miguel Almeida; MJW Consulting - Matthew
Wire; PERORA SRL - Samuele Masetto; Progressive Technology Project - Jamie
McClelland; Tadpole Collective - Kevin Cristiano; Third Sector Design - Kurund
Jalmi; Wikimedia Foundation - Eileen McNaughton, Elliott Eggleston; Wildsight -
Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; ALL IN APPLI; Anatole;
Artful Robot - Rich Lott; CEPR - Josh Brown; Christian Wach; CompuCorp - Jamie
Novick; Coop SymbioTIC - Shane Bill; enCircle Solutions Ltd - Darren Woods;
Fuzion - Jitendra Purohit, Luke Stewart; GValFr35; in2part; JMA Consulting - Joe
Murray; jptillman; Makoa - Usha F. Matisson; OPEN - dewy; Squiffle Consulting -
Aidan Saunders

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
