<?php
use CRM_CivicrmSearchUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Reports',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Reports',
        'label' => E::ts('Reports'),
        'api_entity' => 'Report',
        'api_params' => [
          'version' => 4,
          'select' => [
            'type',
            'type:label',
            'title',
            'description',
            'view_url',
            'edit_url',
            'tags',
            'primary_entities',

          ],
          'orderBy' => [],
          'where' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Reports_SearchDisplay_Reports',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Reports',
        'label' => E::ts('Reports'),
        'saved_search_id.name' => 'Reports',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            ['title', 'ASC'],
          ],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Title'),
              'sortable' => TRUE,
              'rewrite' => '[title] ([type:label])',
            ],
            [
              'type' => 'field',
              'key' => 'description',
              'label' => E::ts('Description'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'tags',
              'label' => E::ts('Tags'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'path' => '[view_url]',
                  'icon' => 'fa-eye',
                  'text' => E::ts('Open'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    [],
                  ],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
              'label' => E::ts('Open'),
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'path' => '[edit_url]',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    [],
                  ],
                ],
                [
                  'path' => '[view_url]&output=copy',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Save a Copy'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    ['type', '=', 'classic'],
                  ],
                ],
                [
                  'path' => '[view_url]&output=pdf',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('View as PDF'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    ['type', '=', 'classic'],
                  ],
                ],
                [
                  'path' => '[view_url]&output=print',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Print'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    ['type', '=', 'classic'],
                  ],
                ],
                [
                  'path' => '[view_url]&output=csv',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Export to CSV'),
                  'style' => 'default',
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'conditions' => [
                    ['type', '=', 'classic'],
                  ],
                ],
                [
                  'path' => '[view_url]&action=delete',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                  'conditions' => [
                    ['type', '=', 'classic'],
                  ],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
              'label' => E::ts('Actions'),
            ],
          ],
          'actions' => FALSE,
          'classes' => ['table', 'table-striped'],
          'toolbar' => [
            [
              'path' => 'civicrm/admin/search#/list?tab=template',
              'icon' => 'fa-external-link',
              'text' => E::ts('New SearchKit Report'),
              'style' => 'default',
              'task' => '',
              'entity' => '',
              'action' => '',
              'join' => '',
              'target' => '',
              'conditions' => [
                [],
              ],
            ],
            [
              'path' => 'civicrm/report/template/list',
              'icon' => 'fa-external-link',
              'text' => E::ts('New Classic Report'),
              'style' => 'default',
              'task' => '',
              'entity' => '',
              'action' => '',
              'join' => '',
              'target' => '',
              'conditions' => [
                [],
              ],
            ],
          ],
          'cssRules' => [
            //['disabled', 'is_active', '=', FALSE],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
