<?php
use CRM_CivicrmSearchUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Manage_Events',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Manage_Events',
        'label' => E::ts('Manage Events'),
        'api_entity' => 'Event',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'GROUP_CONCAT(DISTINCT Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01.city) AS GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_city',
            'GROUP_CONCAT(DISTINCT Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01.state_province_id:label) AS GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_state_province_id_label',
            'event_type_id:label',
            'start_date',
            'end_date',
            'is_public',
            'is_active',
            'COUNT(DISTINCT Event_Participant_event_id_01.id) AS COUNT_Event_Participant_event_id_01_id',
            'COUNT(Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01.id) AS COUNT_Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01_id',
            'COUNT(Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02.id) AS COUNT_Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02_id',
            'Event_Participant_event_id_01_Participant_Contact_contact_id_01.sort_name',
          ],
          'orderBy' => [],
          'where' => [
            [
              'is_template',
              '=',
              FALSE,
            ],
          ],
          'groupBy' => [
            'id',
          ],
          'join' => [
            [
              'LocBlock AS Event_LocBlock_loc_block_id_01',
              'LEFT',
              [
                'loc_block_id',
                '=',
                'Event_LocBlock_loc_block_id_01.id',
              ],
            ],
            [
              'Address AS Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01',
              'LEFT',
              [
                'Event_LocBlock_loc_block_id_01.address_id',
                '=',
                'Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01.id',
              ],
              [
                'Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01.is_primary',
                '=',
                TRUE,
              ],
            ],
            [
              'Participant AS Event_Participant_event_id_01',
              'LEFT',
              [
                'id',
                '=',
                'Event_Participant_event_id_01.event_id',
              ],
            ],
            [
              'ParticipantStatusType AS Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01',
              'LEFT',
              [
                'Event_Participant_event_id_01.status_id',
                '=',
                'Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01.id',
              ],
              [
                'Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01.is_counted',
                '=',
                TRUE,
              ],
            ],
            [
              'ParticipantStatusType AS Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02',
              'LEFT',
              [
                'Event_Participant_event_id_01.status_id',
                '=',
                'Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02.id',
              ],
              [
                'Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02.is_counted',
                '=',
                FALSE,
              ],
            ],
            [
              'Contact AS Event_Participant_event_id_01_Participant_Contact_contact_id_01',
              'LEFT',
              [
                'Event_Participant_event_id_01.contact_id',
                '=',
                'Event_Participant_event_id_01_Participant_Contact_contact_id_01.id',
              ],
              [
                'Event_Participant_event_id_01_Participant_Contact_contact_id_01.is_deleted',
                '=',
                FALSE,
              ],
            ],
          ],
          'having' => [],
        ],
        'description' => E::ts('this replaces the current Manage Events screen'),
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Manage_Events_SearchDisplay_Manage_Events_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Manage_Events_Table_1',
        'label' => E::ts('Manage Events Table 1'),
        'saved_search_id.name' => 'Manage_Events',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            [
              'start_date',
              'ASC',
            ],
          ],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'label' => E::ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Event'),
              'sortable' => TRUE,
              'link' => [
                'path' => 'civicrm/event/manage/settings?reset=1&action=update&id=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
              'title' => E::ts('Event info and settings'),
            ],
            [
              'type' => 'field',
              'key' => 'GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_city',
              'label' => E::ts('Location'),
              'sortable' => TRUE,
              'rewrite' => '{if \'[GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_state_province_id_label]\'} [GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_city] ([GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_state_province_id_label]) {else} [GROUP_CONCAT_Event_LocBlock_loc_block_id_01_LocBlock_Address_address_id_01_city] {/if}',
            ],
            [
              'type' => 'field',
              'key' => 'event_type_id:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'start_date',
              'label' => E::ts('Start Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'end_date',
              'label' => E::ts('End Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_public',
              'label' => E::ts('Public?'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => E::ts('Active?'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'COUNT_Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_01_id',
              'label' => E::ts('#Registered, Attended...'),
              'sortable' => TRUE,
              'link' => [
                'path' => 'civicrm/event/search?reset=1&force=1&status=true&event=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'COUNT_Event_Participant_event_id_01_Participant_ParticipantStatusType_status_id_02_id',
              'label' => E::ts('#Cancelled, No-show...'),
              'sortable' => TRUE,
              'link' => [
                'path' => 'civicrm/event/search?reset=1&force=1&status=false&event=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
            ],
            [
              'text' => E::ts('Configure'),
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'path' => 'civicrm/event/manage/settings?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Info and Settings'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage/location?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Location'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Fees'),
                  'style' => 'default',
                  'path' => 'civicrm/event/manage/fee?reset=1&action=update&id=[id]',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'path' => 'civicrm/event/manage/registration?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Online Registration'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage/reminder?reset=1&action=browse&setTab=1&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Schedule Reminders'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage/friend?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Tell a Friend'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage/pcp?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Personal Campaign Pages'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage/repeat?reset=1&action=update&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Repeat'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
              ],
              'type' => 'menu',
              'alignment' => '',
            ],
            [
              'text' => E::ts('Event Links'),
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Register Participant'),
                  'style' => 'default',
                  'path' => 'civicrm/participant/add?reset=1&action=add&context=standalone&eid=[id]',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'path' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('View Event'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => 'Event',
                  'action' => 'view',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
                [
                  'path' => 'civicrm/event/register?reset=1&action=preview&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Registration (Test-drive)'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/register?reset=1&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Registration (Live)'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/participant?reset=1&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Public Participant Listing'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
              ],
              'type' => 'menu',
              'alignment' => '',
            ],
            [
              'text' => E::ts('More'),
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'path' => 'civicrm/event/manage?reset=1&action=copy&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Copy'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'path' => 'civicrm/event/manage?action=delete&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Delete'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
              ],
              'type' => 'menu',
              'alignment' => '',
              'label' => '',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
          'toolbar' => [
            [
              'action' => 'add',
              'entity' => 'Event',
              'text' => E::ts('Add Event'),
              'icon' => 'fa-plus',
              'style' => 'primary',
              'target' => '',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
