<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Price_Sets',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Price_Sets',
        'label' => E::ts('Price Sets'),
        'api_entity' => 'PriceSet',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'extends:label',
            'COUNT(PriceSet_PriceField_price_set_id_01.id) AS COUNT_PriceSet_PriceField_price_set_id_01_id',
            'GROUP_CONCAT(DISTINCT PriceSet_PriceField_price_set_id_01.label) AS GROUP_CONCAT_PriceSet_PriceField_price_set_id_01_label',
            'is_active',
          ],
          'groupBy' => ['id'],
          'where' => [
            ['is_reserved', '=', FALSE],
            [
              'is_quick_config',
              '=',
              FALSE,
            ],
          ],
          'join' => [
            [
              'PriceField AS PriceSet_PriceField_price_set_id_01',
              'LEFT',
              [
                'id',
                '=',
                'PriceSet_PriceField_price_set_id_01.price_set_id',
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Price_Sets_SearchDisplay_Administer_Price_Sets',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Price_Sets',
        'label' => E::ts('Price Sets'),
        'saved_search_id.name' => 'Administer_Price_Sets',
        'type' => 'table',
        'settings' => [
          'description' => '',
          'sort' => [],
          'limit' => 50,
          'pager' => [
            'show_count' => TRUE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Title'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'extends:label',
              'label' => E::ts('Used For'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'html',
              'key' => 'GROUP_CONCAT_PriceSet_PriceField_price_set_id_01_label',
              'label' => E::ts('Fields'),
              'sortable' => TRUE,
              'rewrite' => '{capture assign=fields}[GROUP_CONCAT_PriceSet_PriceField_price_set_id_01_label]{/capture}{$fields|replace:\',\':\'<br>\'}',
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-list-alt',
                  'text' => E::ts('Fields (%1)', [1 => '[COUNT_PriceSet_PriceField_price_set_id_01_id]']),
                  'style' => 'default',
                  'path' => 'civicrm/admin/price/field#/?sid=[id]',
                  'condition' => [],
                  'task' => '',
                  'conditions' => [],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'PriceSet',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Settings'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'entity' => 'PriceSet',
                  'action' => 'preview',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-eye',
                  'text' => E::ts('Preview'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'PriceSet',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'conditions' => [
                    ['is_active', '=', FALSE],
                  ],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'PriceSet',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'conditions' => [
                    ['is_active', '=', TRUE],
                  ],
                ],
                [
                  'entity' => 'PriceSet',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'entity' => 'PriceSet',
                  'action' => 'copy',
                  'csrf' => 'qfKey',
                  'join' => '',
                  'icon' => 'fa-copy',
                  'text' => E::ts('Copy'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                  'target' => '',
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'toolbar' => [
            [
              'entity' => 'PriceSet',
              'action' => 'add',
              'target' => 'crm-popup',
              'style' => 'primary',
              'text' => E::ts('Add Price Set'),
              'icon' => 'fa-plus',
              'autoOpen' => TRUE,
              'path' => '',
              'task' => '',
              'join' => '',
              'conditions' => [],
            ],
          ],
          'actions' => TRUE,
          'classes' => ['table', 'table-striped'],
          'actions_display_mode' => 'menu',
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
