<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Price_Fields',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Price_Fields',
        'label' => E::ts('Price Fields'),
        'api_entity' => 'PriceField',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'label',
            'is_active',
            'is_required',
            'visibility_id:label',
            'active_on',
            'expire_on',
            'html_type:label',
            'COUNT(PriceField_PriceFieldValue_price_field_id_01.id) AS COUNT_PriceField_PriceFieldValue_price_field_id_01_id',
            'GROUP_CONCAT(DISTINCT PriceField_PriceFieldValue_price_field_id_01.label) AS GROUP_CONCAT_PriceField_PriceFieldValue_price_field_id_01_label',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => ['id'],
          'join' => [
            [
              'PriceFieldValue AS PriceField_PriceFieldValue_price_field_id_01',
              'LEFT',
              [
                'id',
                '=',
                'PriceField_PriceFieldValue_price_field_id_01.price_field_id',
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Price_Fields_SearchDisplay_Administer_Price_Fields',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Price_Fields',
        'label' => E::ts('Price Fields'),
        'saved_search_id.name' => 'Administer_Price_Fields',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            ['weight', 'ASC'],
          ],
          'limit' => 50,
          'pager' => [
            'show_count' => TRUE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'label',
              'label' => E::ts('Label'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'html_type:label',
              'label' => E::ts('Field Type'),
              'sortable' => FALSE,
            ],
            [
              'type' => 'field',
              'key' => 'is_required',
              'label' => E::ts('Required'),
              'sortable' => FALSE,
            ],
            [
              'type' => 'field',
              'key' => 'visibility_id:label',
              'label' => E::ts('Visibility'),
              'sortable' => FALSE,
            ],
            [
              'type' => 'field',
              'key' => 'active_on',
              'label' => E::ts('Active On'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'expire_on',
              'label' => E::ts('Expire On'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'html',
              'key' => 'GROUP_CONCAT_PriceField_PriceFieldValue_price_field_id_01_label',
              'label' => E::ts('Options'),
              'sortable' => FALSE,
              'rewrite' => '{capture assign=fields}[GROUP_CONCAT_PriceField_PriceFieldValue_price_field_id_01_label]{/capture}{$fields|replace:\',\':\'<br>\'}',
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-list-alt',
                  'text' => E::ts('Options'),
                  'style' => 'default',
                  'path' => 'civicrm/admin/price/field/option#/?fid=[id]',
                  'condition' => [],
                  'task' => '',
                  'conditions' => [
                    [
                      'html_type:name',
                      'IN',
                      ['Select', 'Radio', 'CheckBox'],
                    ],
                  ],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'PriceField',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Settings'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'PriceField',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'conditions' => [
                    ['is_active', '=', TRUE],
                  ],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'PriceField',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'conditions' => [
                    ['is_active', '=', FALSE],
                  ],
                ],
                [
                  'entity' => 'PriceField',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'task' => '',
                  'conditions' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => ['table', 'table-striped'],
          'draggable' => 'weight',
          'actions_display_mode' => 'menu',
          'toolbar' => [
            [
              'path' => 'civicrm/admin/price/field/edit?action=preview&sid=[price_set_id]&reset=1&context=field',
              'icon' => 'fa-external-link',
              'text' => E::ts('Preview'),
              'style' => 'default',
              'conditions' => [],
              'task' => '',
              'entity' => '',
              'action' => '',
              'join' => '',
              'target' => 'crm-popup',
            ],
            [
              'entity' => 'PriceField',
              'text' => E::ts('Add Price Field'),
              'icon' => 'fa-plus',
              'target' => 'crm-popup',
              'action' => 'add',
              'style' => 'primary',
              'join' => '',
              'path' => '',
              'task' => '',
              'conditions' => [],
            ],
          ],
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
