<?php

use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_PriceField_Values',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_PriceField_Values',
        'label' => E::ts('Administer Price Field Options'),
        'api_entity' => 'PriceFieldValue',
        'api_params' => [
          'version' => 4,
          'select' => [
            'label',
            'amount',
            'non_deductible_amount',
            'financial_type_id:label',
            'visibility_id:label',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_PriceField_Values_SearchDisplay_Administer_PriceField_Values',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_PriceField_Values',
        'label' => E::ts('Administer Price Field Options'),
        'saved_search_id.name' => 'Administer_PriceField_Values',
        'type' => 'table',
        'settings' => [
          'description' => '',
          'sort' => [],
          'limit' => 50,
          'pager' => [
            'show_count' => TRUE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
            ['font-bold', 'is_default', '=', TRUE],
          ],
          'columns' => [
            [
              'type' => 'field',
              'key' => 'label',
              'label' => E::ts('Label'),
              'sortable' => FALSE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'amount',
              'label' => E::ts('Amount'),
              'sortable' => FALSE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'non_deductible_amount',
              'label' => E::ts('Non-Deductible Amount'),
              'sortable' => FALSE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'financial_type_id:label',
              'label' => E::ts('Financial Type'),
              'sortable' => FALSE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'visibility_id:label',
              'label' => E::ts('Visibility'),
              'sortable' => FALSE,
              'editable' => TRUE,
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'PriceFieldValue',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'path' => '',
                  'condition' => [],
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'PriceFieldValue',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'condition' => [],
                  'path' => '',
                  'action' => '',
                  'join' => '',
                  'conditions' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'PriceFieldValue',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'condition' => [],
                  'path' => '',
                  'action' => '',
                  'join' => '',
                  'conditions' => [],
                ],
                [
                  'entity' => 'PriceFieldValue',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'condition' => [],
                  'task' => '',
                  'conditions' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => FALSE,
          'editableRow' => [
            'create' => TRUE,
            'createLabel' => E::ts('Add Option'),
          ],
          'classes' => ['table', 'table-striped'],
          'draggable' => 'weight',
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
