<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Membership_Status_Rules',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Membership_Status_Rules',
        'label' => E::ts('Administer Membership Status Rules'),
        'api_entity' => 'MembershipStatus',
        'api_params' => [
          'version' => 4,
          'select' => [
            'label',
            'is_active',
            'start_event:label',
            'start_event_adjust_interval',
            'start_event_adjust_unit:label',
            'end_event:label',
            'end_event_adjust_interval',
            'end_event_adjust_unit:label',
            'is_current_member',
            'is_admin',
            'weight',
            'is_reserved',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Membership_Status_Rules_SearchDisplay_Membership_Statuses_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Membership_Statuses_Table_1',
        'label' => E::ts('Membership Statuses Table 1'),
        'saved_search_id.name' => 'Administer_Membership_Status_Rules',
        'type' => 'table',
        'settings' => [
          'description' => '',
          'sort' => [],
          'limit' => 50,
          'pager' => [
            'show_count' => FALSE,
            'expose_limit' => FALSE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'label',
              'label' => E::ts('Status'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'start_event:label',
              'label' => E::ts('Start Event'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'start_event_adjust_interval',
              'label' => E::ts('Start Adjustment'),
              'sortable' => TRUE,
              'rewrite' => '[start_event_adjust_interval] [start_event_adjust_unit:label]',
            ],
            [
              'type' => 'field',
              'key' => 'end_event:label',
              'label' => E::ts('End Event'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'end_event_adjust_interval',
              'label' => E::ts('End Adjustment'),
              'sortable' => TRUE,
              'rewrite' => '[end_event_adjust_interval] [end_event_adjust_unit:label]',
            ],
            [
              'type' => 'field',
              'key' => 'is_current_member',
              'label' => E::ts('Current Member'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_admin',
              'label' => E::ts('Administrator Only'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
              'cssRules' => [],
            ],
            [
              'type' => 'field',
              'key' => 'is_reserved',
              'label' => E::ts('Reserved'),
              'sortable' => TRUE,
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'MembershipStatus',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Update Membership Status'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'MembershipStatus',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable Membership Statuses'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'MembershipStatus',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable Membership Statuses'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'MembershipStatus',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete Membership Status'),
                  'style' => 'danger',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => FALSE,
          'classes' => ['table', 'table-striped'],
          'draggable' => 'weight',
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
          ],
          'toolbar' => [
            [
              'action' => 'add',
              'entity' => 'MembershipStatus',
              'text' => E::ts('Add Membership Status'),
              'icon' => 'fa-plus',
              'style' => 'primary',
              'target' => 'crm-popup',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
