<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Badge_Layouts',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Badge_Layouts',
        'label' => E::ts('Administer Badge Layouts'),
        'api_entity' => 'PrintLabel',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'description',
            'is_active',
            'is_default',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Badge_Layouts_SearchDisplay_Administer_Badge_Layouts_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Badge_Layouts_Table_1',
        'label' => E::ts('Administer Badge Layouts Table'),
        'saved_search_id.name' => 'Administer_Badge_Layouts',
        'type' => 'table',
        'settings' => [
          'description' => '',
          'sort' => [],
          'limit' => 50,
          'pager' => [
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Title'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'description',
              'label' => E::ts('Description'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_default',
              'label' => E::ts('Default'),
              'sortable' => TRUE,
              'rewrite' => '[none]',
              'icons' => [
                [
                  'icon' => 'fa-check',
                  'side' => 'left',
                  'if' => ['is_default', '=', TRUE],
                ],
              ],
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'action' => 'update',
                  'entity' => 'PrintLabel',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'path' => '',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'task' => 'disable',
                  'entity' => 'PrintLabel',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => ['is_active', '=', TRUE],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'PrintLabel',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => ['is_active', '=', FALSE],
                ],
                [
                  'task' => 'delete',
                  'entity' => 'PrintLabel',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => ['table', 'table-striped'],
          'toolbar' => [
            [
              'action' => 'add',
              'entity' => 'PrintLabel',
              'icon' => 'fa-plus',
              'text' => E::ts('New Badge Layout'),
              'style' => 'primary',
              'target' => 'crm-popup',
              'path' => '',
              'task' => '',
              'join' => '',
              'condition' => [],
            ],
          ],
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
          ],
          'actions_display_mode' => 'menu',
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
