<?php
use CRM_Campaign_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Surveys',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Surveys',
        'label' => E::ts('Administer Surveys'),
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'Survey',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'campaign_id:label',
            'activity_type_id:label',
            'release_frequency',
            'default_number_of_contacts',
            'max_number_of_contacts',
            'is_active',
            'is_default',
            'result_id:label',
          ],
          'orderBy' => [],
          'where' => [
            ['activity_type_id:name', '!=', 'Petition'],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
        'expires_date' => NULL,
        'description' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Surveys_SearchDisplay_Surveys_Table',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Surveys_Table',
        'label' => E::ts('Administer Surveys'),
        'saved_search_id.name' => 'Administer_Surveys',
        'type' => 'table',
        'settings' => [
          'actions' => FALSE,
          'limit' => 50,
          'classes' => [
            'table',
            'table-striped',
          ],
          'pager' => [
            'show_count' => FALSE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'sort' => [
            ['is_active', 'DESC'],
            ['title', 'ASC'],
          ],
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Title'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'campaign_id:label',
              'label' => E::ts('Survey'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'activity_type_id:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
              'editable' => TRUE,
              'icons' => [
                [
                  'field' => 'activity_type_id:icon',
                  'side' => 'left',
                ],
              ],
            ],
            [
              'type' => 'field',
              'key' => 'release_frequency',
              'label' => E::ts('Release Frequency'),
              'sortable' => TRUE,
              'empty_value' => '',
              'rewrite' => '[release_frequency] Days',
            ],
            [
              'type' => 'field',
              'key' => 'default_number_of_contacts',
              'label' => E::ts('Reserve Each Time'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'max_number_of_contacts',
              'label' => E::ts('Total Reserve'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'result_id:label',
              'label' => E::ts('Result Set'),
              'sortable' => TRUE,
              'link' => [
                'path' => 'civicrm/survey/option-group#?option_group_id=[result_id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => 'crm-popup',
              ],
              'empty_value' => E::ts('Incomplete'),
              'cssRules' => [
                [
                  'bg-danger',
                  'result_id:label',
                  'IS EMPTY',
                ],
              ],
              'rewrite' => E::ts('View Options'),
              'icons' => [],
            ],
            [
              'type' => 'field',
              'key' => 'is_default',
              'label' => E::ts('Default'),
              'sortable' => TRUE,
              'rewrite' => ' ',
              'icons' => [
                [
                  'icon' => 'fa-check-square-o',
                  'side' => 'left',
                  'if' => [
                    'is_default',
                    '=',
                    TRUE,
                  ],
                ],
              ],
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'path' => '',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'condition' => [],
                  'entity' => 'Survey',
                  'action' => 'update',
                  'join' => '',
                  'target' => '',
                ],
                [
                  'task' => 'enable',
                  'entity' => 'Survey',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'condition' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'Survey',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'condition' => [],
                ],
                [
                  'entity' => 'Survey',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger small-popup',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => E::ts('Respondents'),
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'type' => 'menu',
              'alignment' => 'text-right',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '_blank',
                  'icon' => 'fa-user-plus',
                  'text' => E::ts('Reserve'),
                  'style' => 'default',
                  'path' => 'civicrm/survey/search?sid=[id]&reset=1&op=reserve',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'path' => 'civicrm/survey/search?sid=[id]&reset=1&op=interview&force=1',
                  'icon' => 'fa-clipboard',
                  'text' => E::ts('Interview'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '_blank',
                ],
                [
                  'path' => 'civicrm/survey/search?sid=[id]&reset=1&op=release&force=1',
                  'icon' => 'fa-user-times',
                  'text' => E::ts('Release'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '_blank',
                ],
              ],
            ],
          ],
          'toolbar' => [
            [
              'entity' => 'Survey',
              'action' => 'add',
              'target' => 'crm-popup',
              'icon' => 'fa-plus',
              'text' => E::ts('Add Survey'),
              'style' => 'primary',
            ],
          ],
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
];
