<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 * Upgrade logic for the 6.8.x series.
 *
 * Each minor version in the series is handled by either a `6.8.x.mysql.tpl` file,
 * or a function in this class named `upgrade_6_8_x`.
 * If only a .tpl file exists for a version, it will be run automatically.
 * If the function exists, it must explicitly add the 'runSql' task if there is a corresponding .mysql.tpl.
 *
 * This class may also implement `setPreUpgradeMessage()` and `setPostUpgradeMessage()` functions.
 */
class CRM_Upgrade_Incremental_php_SixEight extends CRM_Upgrade_Incremental_Base {

  /**
   * Upgrade step; adds tasks including 'runSql'.
   *
   * @param string $rev
   *   The version number matching this function name
   */
  public function upgrade_6_8_alpha1($rev): void {
    $this->addTask(ts('Upgrade DB to %1: SQL', [1 => $rev]), 'runSql', $rev);
    $this->addTask('Add column "UserJob.label"', 'alterSchemaField', 'UserJob', 'label', [
      'title' => ts('User Job Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Label for job.'),
    ], 'AFTER name');
  }

  /**
   * Upgrade step; adds tasks including 'runSql'.
   *
   * @param string $rev
   *   The version number matching this function name
   */
  public function upgrade_6_8_beta1($rev): void {
    $this->addTask('Add index to civicrm_translation_source', 'addIndex', 'civicrm_translation_source', 'source_key');
  }

}
