<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 */
class CRM_Contribute_Page_PaymentInfo extends CRM_Core_Page {

  /**
   * The component this payment is associated with (contribution, event, etc).
   *
   * @var string
   */
  protected $_component;

  /**
   * The context this is being called in (payment_info, payment)
   *
   * @var string
   */
  protected $_context;

  public function preProcess() {
    $this->_component = CRM_Utils_Request::retrieve('component', 'String', $this, TRUE);
    $this->_action = CRM_Utils_Request::retrieve('action', 'String', $this, FALSE, 'browse');
    $this->_id = CRM_Utils_Request::retrieve('id', 'Positive', $this, TRUE);
    $this->_context = CRM_Utils_Request::retrieve('context', 'Alphanumeric', $this, TRUE);
    $cid = CRM_Utils_Request::retrieve('cid', 'String', $this, TRUE);

    $this->assign('cid', $cid);
    $this->assign('id', $this->_id);
    $this->assign('context', $this->_context);
    $this->assign('component', $this->_component);
  }

  public function browse() {
    $getTrxnInfo = $this->_context == 'transaction';
    $paymentInfo = CRM_Contribute_BAO_Contribution::getPaymentInfo($this->_id, $this->_component, $getTrxnInfo, TRUE);
    if ($this->_context == 'payment_info') {
      $this->assign('paymentInfo', $paymentInfo);
    }
  }

  /**
   * Run page.
   *
   * This typically involves assigning the appropriate
   * smarty variable :)
   *
   * @return string
   *   The content generated by running this page
   */
  public function run() {
    $this->preProcess();
    if ($this->_action) {
      $this->browse();
    }

    return parent::run();
  }

}
